/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.view.facelets.impl;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.el.ELContext;
import javax.el.ELException;
import javax.el.ELResolver;
import javax.el.ExpressionFactory;
import javax.el.FunctionMapper;
import javax.el.ValueExpression;
import javax.el.VariableMapper;
import javax.faces.FacesException;
import javax.faces.application.Resource;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.view.facelets.FaceletContext;
import javax.faces.view.facelets.FaceletException;
import org.apache.myfaces.view.facelets.AbstractFacelet;
import org.apache.myfaces.view.facelets.AbstractFaceletContext;
import org.apache.myfaces.view.facelets.ELExpressionCacheMode;
import org.apache.myfaces.view.facelets.FaceletCompositionContext;
import org.apache.myfaces.view.facelets.PageContext;
import org.apache.myfaces.view.facelets.TemplateClient;
import org.apache.myfaces.view.facelets.TemplateContext;
import org.apache.myfaces.view.facelets.TemplateManager;
import org.apache.myfaces.view.facelets.el.DefaultVariableMapper;
import org.apache.myfaces.view.facelets.el.VariableMapperBase;
import org.apache.myfaces.view.facelets.impl.TemplateContextImpl;
import org.apache.myfaces.view.facelets.tag.jsf.core.AjaxHandler;

final class DefaultFaceletContext
extends AbstractFaceletContext {
    private final FacesContext _faces;
    private final ELContext _ctx;
    private final AbstractFacelet _facelet;
    private final List<AbstractFacelet> _faceletHierarchy;
    private VariableMapper _varMapper;
    private final DefaultVariableMapper _defaultVarMapper;
    private VariableMapperBase _varMapperBase;
    private FunctionMapper _fnMapper;
    private String _prefix;
    private StringBuilder _uniqueIdBuilder;
    private final FaceletCompositionContext _mctx;
    private LinkedList<AjaxHandler> _ajaxHandlerStack;
    private final List<TemplateContext> _isolatedTemplateContext;
    private int _currentTemplateContext;
    private ELExpressionCacheMode _elExpressionCacheMode;
    private boolean _isCacheELExpressions;
    private final List<PageContext> _isolatedPageContext;

    public DefaultFaceletContext(DefaultFaceletContext ctx, AbstractFacelet facelet, boolean ccWrap) {
        this._ctx = ctx._ctx;
        this._faces = ctx._faces;
        this._fnMapper = ctx._fnMapper;
        this._varMapper = ctx._varMapper;
        this._defaultVarMapper = ctx._defaultVarMapper;
        this._varMapperBase = ctx._varMapperBase;
        this._faceletHierarchy = new ArrayList<AbstractFacelet>(ctx._faceletHierarchy.size() + 1);
        this._faceletHierarchy.addAll(ctx._faceletHierarchy);
        this._faceletHierarchy.add(facelet);
        this._facelet = facelet;
        this._mctx = ctx._mctx;
        this._ajaxHandlerStack = ccWrap ? null : ctx._ajaxHandlerStack;
        this._isolatedTemplateContext = ctx._isolatedTemplateContext;
        this._currentTemplateContext = ctx._currentTemplateContext;
        this._isolatedPageContext = ctx._isolatedPageContext;
        this._elExpressionCacheMode = ctx._elExpressionCacheMode;
        this._isCacheELExpressions = ctx._isCacheELExpressions;
    }

    public DefaultFaceletContext(FacesContext faces, AbstractFacelet facelet, FaceletCompositionContext mctx) {
        this._ctx = faces.getELContext();
        this._faces = faces;
        this._fnMapper = this._ctx.getFunctionMapper();
        this._varMapper = this._ctx.getVariableMapper();
        if (this._varMapper == null) {
            this._defaultVarMapper = new DefaultVariableMapper();
            this._varMapper = this._defaultVarMapper;
            this._varMapperBase = this._defaultVarMapper;
        } else {
            this._defaultVarMapper = new DefaultVariableMapper(this._varMapper);
            this._varMapper = this._defaultVarMapper;
            this._varMapperBase = this._defaultVarMapper;
        }
        this._faceletHierarchy = new ArrayList<AbstractFacelet>(1);
        this._faceletHierarchy.add(facelet);
        this._facelet = facelet;
        this._mctx = mctx;
        this._isolatedTemplateContext = new ArrayList<TemplateContext>(1);
        this._isolatedTemplateContext.add(new TemplateContextImpl());
        this._currentTemplateContext = 0;
        this._defaultVarMapper.setTemplateContext(this._isolatedTemplateContext.get(this._currentTemplateContext));
        this._isolatedPageContext = new ArrayList<PageContext>(8);
        this._elExpressionCacheMode = mctx.getELExpressionCacheMode();
        this._isCacheELExpressions = !ELExpressionCacheMode.noCache.equals((Object)this._elExpressionCacheMode);
    }

    public FacesContext getFacesContext() {
        return this._faces;
    }

    public ExpressionFactory getExpressionFactory() {
        return this._facelet.getExpressionFactory();
    }

    public void setVariableMapper(VariableMapper varMapper) {
        this._varMapper = varMapper;
        this._varMapperBase = this._varMapper instanceof VariableMapperBase ? (VariableMapperBase)varMapper : null;
    }

    public void setFunctionMapper(FunctionMapper fnMapper) {
        this._fnMapper = fnMapper;
    }

    public void includeFacelet(UIComponent parent, String relativePath) throws IOException {
        this._facelet.include((AbstractFaceletContext)this, parent, relativePath);
    }

    public FunctionMapper getFunctionMapper() {
        return this._fnMapper;
    }

    public VariableMapper getVariableMapper() {
        return this._varMapper;
    }

    public Object getContext(Class key) {
        return this._ctx.getContext(key);
    }

    public void putContext(Class key, Object contextObject) {
        this._ctx.putContext(key, contextObject);
    }

    private void initPrefix() {
        if (this._prefix == null) {
            this._uniqueIdBuilder = new StringBuilder(this._faceletHierarchy.size() * 30);
            for (int i = 0; i < this._faceletHierarchy.size(); ++i) {
                AbstractFacelet facelet = this._faceletHierarchy.get(i);
                this._uniqueIdBuilder.append(facelet.getFaceletId());
            }
            this._prefix = Integer.toString(Math.abs(this._uniqueIdBuilder.toString().hashCode()));
        }
    }

    public String generateUniqueId(String base) {
        this.initPrefix();
        this._uniqueIdBuilder.setLength(0);
        String uniqueIdFromIterator = this.getFaceletCompositionContext().getUniqueIdFromIterator();
        if (uniqueIdFromIterator == null) {
            this.getFaceletCompositionContext().generateUniqueId(this._uniqueIdBuilder);
            if (!this.getFaceletCompositionContext().isInMetadataSection()) {
                this._uniqueIdBuilder.append('_');
                this._uniqueIdBuilder.append(this._prefix);
                this._uniqueIdBuilder.append('_');
                this._uniqueIdBuilder.append(base);
            }
            uniqueIdFromIterator = this._uniqueIdBuilder.toString();
            this.getFaceletCompositionContext().addUniqueId(uniqueIdFromIterator);
            return uniqueIdFromIterator;
        }
        this.getFaceletCompositionContext().incrementUniqueId();
        return uniqueIdFromIterator;
    }

    @Override
    public String generateUniqueFaceletTagId(String count, String base) {
        this.initPrefix();
        this._uniqueIdBuilder.setLength(0);
        this._uniqueIdBuilder.append(count);
        this._uniqueIdBuilder.append('_');
        this._uniqueIdBuilder.append(this._prefix);
        this._uniqueIdBuilder.append('_');
        this._uniqueIdBuilder.append(base);
        return this._uniqueIdBuilder.toString();
    }

    public Object getAttribute(String name) {
        ValueExpression ve;
        if (this._varMapper != null && (ve = this._varMapper.resolveVariable(name)) != null) {
            return ve.getValue((ELContext)this);
        }
        return null;
    }

    public void setAttribute(String name, Object value) {
        if (this._varMapper != null) {
            if (value == null) {
                this._varMapper.setVariable(name, null);
            } else {
                this._varMapper.setVariable(name, this._facelet.getExpressionFactory().createValueExpression(value, Object.class));
            }
        }
    }

    public void includeFacelet(UIComponent parent, URL absolutePath) throws IOException, FacesException, ELException {
        this._facelet.include((AbstractFaceletContext)this, parent, absolutePath);
    }

    public ELResolver getELResolver() {
        return this._ctx.getELResolver();
    }

    @Override
    public TemplateManager popClient(TemplateClient client) {
        return this._isolatedTemplateContext.get(this._currentTemplateContext).popClient(this);
    }

    @Override
    public void pushClient(TemplateClient client) {
        this._isolatedTemplateContext.get(this._currentTemplateContext).pushClient(this, this._facelet, client);
    }

    @Override
    public TemplateManager popExtendedClient(TemplateClient client) {
        return this._isolatedTemplateContext.get(this._currentTemplateContext).popExtendedClient(this);
    }

    @Override
    public void extendClient(TemplateClient client) {
        this._isolatedTemplateContext.get(this._currentTemplateContext).extendClient(this, this._facelet, client);
    }

    @Override
    public boolean includeDefinition(UIComponent parent, String name) throws IOException, FaceletException, FacesException, ELException {
        return this._isolatedTemplateContext.get(this._currentTemplateContext).includeDefinition(this, this._facelet, parent, name);
    }

    @Override
    public void pushCompositeComponentClient(TemplateClient client) {
        TemplateContextImpl itc = new TemplateContextImpl();
        ((TemplateContext)itc).setCompositeComponentClient(new CompositeComponentTemplateManager(this._facelet, client, this.getPageContext()));
        this._isolatedTemplateContext.add(itc);
        ++this._currentTemplateContext;
        this._defaultVarMapper.setTemplateContext(itc);
    }

    @Override
    public void popCompositeComponentClient() {
        if (this._currentTemplateContext > 0) {
            this._isolatedTemplateContext.remove(this._currentTemplateContext);
            --this._currentTemplateContext;
            this._defaultVarMapper.setTemplateContext(this._isolatedTemplateContext.get(this._currentTemplateContext));
        }
    }

    @Override
    public void pushTemplateContext(TemplateContext client) {
        this._isolatedTemplateContext.add(client);
        ++this._currentTemplateContext;
        this._defaultVarMapper.setTemplateContext(client);
    }

    @Override
    public TemplateContext popTemplateContext() {
        if (this._currentTemplateContext > 0) {
            TemplateContext itc = this._isolatedTemplateContext.get(this._currentTemplateContext);
            this._isolatedTemplateContext.remove(this._currentTemplateContext);
            --this._currentTemplateContext;
            this._defaultVarMapper.setTemplateContext(this._isolatedTemplateContext.get(this._currentTemplateContext));
            return itc;
        }
        return null;
    }

    @Override
    public TemplateContext getTemplateContext() {
        return this._isolatedTemplateContext.get(this._currentTemplateContext);
    }

    @Override
    public boolean includeCompositeComponentDefinition(UIComponent parent, String name) throws IOException, FaceletException, FacesException, ELException {
        TemplateManager ccClient = this._isolatedTemplateContext.get(this._currentTemplateContext).getCompositeComponentClient();
        if (ccClient != null) {
            return ccClient.apply(this, parent, name);
        }
        return false;
    }

    @Override
    public void pushPageContext(PageContext client) {
        this._isolatedPageContext.add(client);
        this._defaultVarMapper.setPageContext(client);
    }

    @Override
    public PageContext popPageContext() {
        if (!this._isolatedPageContext.isEmpty()) {
            int currentPageContext = this._isolatedPageContext.size() - 1;
            PageContext itc = this._isolatedPageContext.get(currentPageContext);
            this._isolatedPageContext.remove(currentPageContext);
            if (!this._isolatedPageContext.isEmpty()) {
                this._defaultVarMapper.setPageContext(this.getPageContext());
            } else {
                this._defaultVarMapper.setPageContext(null);
            }
            return itc;
        }
        return null;
    }

    @Override
    public PageContext getPageContext() {
        return this._isolatedPageContext.get(this._isolatedPageContext.size() - 1);
    }

    public boolean isPropertyResolved() {
        return this._ctx.isPropertyResolved();
    }

    public void setPropertyResolved(boolean resolved) {
        this._ctx.setPropertyResolved(resolved);
    }

    @Override
    public void applyCompositeComponent(UIComponent parent, Resource resource) throws IOException, FaceletException, FacesException, ELException {
        this._facelet.applyCompositeComponent(this, parent, resource);
    }

    @Override
    public Iterator<AjaxHandler> getAjaxHandlers() {
        if (this._ajaxHandlerStack != null && !this._ajaxHandlerStack.isEmpty()) {
            return this._ajaxHandlerStack.iterator();
        }
        return null;
    }

    @Override
    public void popAjaxHandlerToStack() {
        if (this._ajaxHandlerStack != null && !this._ajaxHandlerStack.isEmpty()) {
            this._ajaxHandlerStack.removeFirst();
        }
    }

    @Override
    public void pushAjaxHandlerToStack(AjaxHandler parent) {
        if (this._ajaxHandlerStack == null) {
            this._ajaxHandlerStack = new LinkedList();
        }
        this._ajaxHandlerStack.addFirst(parent);
    }

    @Override
    public boolean isBuildingCompositeComponentMetadata() {
        return this._facelet.isBuildingCompositeComponentMetadata();
    }

    @Override
    public FaceletCompositionContext getFaceletCompositionContext() {
        return this._mctx;
    }

    @Override
    public boolean isAnyFaceletsVariableResolved() {
        if (this._varMapperBase != null) {
            return this._varMapperBase.isAnyFaceletsVariableResolved();
        }
        return true;
    }

    @Override
    public boolean isAllowCacheELExpressions() {
        return this._isCacheELExpressions && this.getTemplateContext().isAllowCacheELExpressions() && this.getPageContext().isAllowCacheELExpressions();
    }

    @Override
    public void beforeConstructELExpression() {
        if (this._varMapperBase != null) {
            this._varMapperBase.beforeConstructELExpression();
        }
    }

    @Override
    public void afterConstructELExpression() {
        if (this._varMapperBase != null) {
            this._varMapperBase.afterConstructELExpression();
        }
    }

    @Override
    public ELExpressionCacheMode getELExpressionCacheMode() {
        return this._elExpressionCacheMode;
    }

    private static final class CompositeComponentTemplateManager
    extends TemplateManager
    implements TemplateClient {
        private final AbstractFacelet _owner;
        protected final TemplateClient _target;
        private final Set<String> _names = new HashSet<String>();
        private final PageContext _pageContext;

        public CompositeComponentTemplateManager(AbstractFacelet owner, TemplateClient target, PageContext pageContext) {
            this._owner = owner;
            this._target = target;
            this._pageContext = pageContext;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean apply(FaceletContext ctx, UIComponent parent, String name) throws IOException, FacesException, FaceletException, ELException {
            String testName;
            String string = testName = name != null ? name : "facelets._NULL_DEF_";
            if (this._names.contains(testName)) {
                return false;
            }
            this._names.add(testName);
            boolean found = false;
            DefaultFaceletContext actx = new DefaultFaceletContext((DefaultFaceletContext)ctx, this._owner, false);
            ctx.getFacesContext().getAttributes().put(FaceletContext.FACELET_CONTEXT_KEY, actx);
            try {
                ((AbstractFaceletContext)actx).pushPageContext(this._pageContext);
                found = this._target.apply(actx, parent, name);
            }
            finally {
                ((AbstractFaceletContext)actx).popPageContext();
            }
            ctx.getFacesContext().getAttributes().put(FaceletContext.FACELET_CONTEXT_KEY, ctx);
            this._names.remove(testName);
            return found;
        }

        public boolean equals(Object o) {
            return this._owner == o || this._target == o;
        }

        public int hashCode() {
            int result = this._owner != null ? ((Object)((Object)this._owner)).hashCode() : 0;
            result = 31 * result + (this._target != null ? this._target.hashCode() : 0);
            return result;
        }
    }
}

