/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.view.facelets.compiler;

public final class FaceletsProcessingInstructions {
    public static final String PROCESS_AS_JSPX = "jspx";
    public static final String PROCESS_AS_XHTML = "xhtml";
    public static final String PROCESS_AS_XML = "xml";
    private static final FaceletsProcessingInstructions FACELETS_PROCESSING_XHTML = new FaceletsProcessingInstructions(false, false, false, false, true, false, true);
    private static final FaceletsProcessingInstructions FACELETS_PROCESSING_XML = new FaceletsProcessingInstructions(true, true, true, true, true, true, true);
    private static final FaceletsProcessingInstructions FACELETS_PROCESSING_JSPX = new FaceletsProcessingInstructions(true, true, true, true, false, true, false);
    private static final FaceletsProcessingInstructions FACELETS_PROCESSING_XHTML_COMPRESS_SPACES = new FaceletsProcessingInstructions(false, false, false, false, true, false, true, true);
    private static final FaceletsProcessingInstructions FACELETS_PROCESSING_XML_COMPRESS_SPACES = new FaceletsProcessingInstructions(true, true, true, true, true, true, true, true);
    private static final FaceletsProcessingInstructions FACELETS_PROCESSING_JSPX_COMPRESS_SPACES = new FaceletsProcessingInstructions(true, true, true, true, false, true, false, true);
    private final boolean consumeXmlDocType;
    private final boolean consumeXmlDeclaration;
    private final boolean consumeProcessingInstructions;
    private final boolean consumeCDataSections;
    private final boolean escapeInlineText;
    private final boolean consumeXMLComments;
    private final boolean swallowCDataContent;
    private final boolean compressSpaces;

    public static final FaceletsProcessingInstructions getProcessingInstructions(String processAs) {
        if (processAs == null) {
            return FACELETS_PROCESSING_XHTML;
        }
        if (PROCESS_AS_XHTML.equals(processAs)) {
            return FACELETS_PROCESSING_XHTML;
        }
        if (PROCESS_AS_XML.equals(processAs)) {
            return FACELETS_PROCESSING_XML;
        }
        if (PROCESS_AS_JSPX.equals(processAs)) {
            return FACELETS_PROCESSING_JSPX;
        }
        return FACELETS_PROCESSING_XHTML;
    }

    public static final FaceletsProcessingInstructions getProcessingInstructions(String processAs, boolean compressSpaces) {
        if (!compressSpaces) {
            return FaceletsProcessingInstructions.getProcessingInstructions(processAs);
        }
        if (processAs == null) {
            return FACELETS_PROCESSING_XHTML_COMPRESS_SPACES;
        }
        if (PROCESS_AS_XHTML.equals(processAs)) {
            return FACELETS_PROCESSING_XHTML_COMPRESS_SPACES;
        }
        if (PROCESS_AS_XML.equals(processAs)) {
            return FACELETS_PROCESSING_XML_COMPRESS_SPACES;
        }
        if (PROCESS_AS_JSPX.equals(processAs)) {
            return FACELETS_PROCESSING_JSPX_COMPRESS_SPACES;
        }
        return FACELETS_PROCESSING_XHTML_COMPRESS_SPACES;
    }

    public FaceletsProcessingInstructions(boolean consumeXmlDocType, boolean consumeXmlDeclaration, boolean consumeProcessingInstructions, boolean consumeCDataSections, boolean escapeInlineText, boolean consumeXMLComments, boolean swallowCDataContent) {
        this.consumeXmlDocType = consumeXmlDocType;
        this.consumeXmlDeclaration = consumeXmlDeclaration;
        this.consumeProcessingInstructions = consumeProcessingInstructions;
        this.consumeCDataSections = consumeCDataSections;
        this.escapeInlineText = escapeInlineText;
        this.consumeXMLComments = consumeXMLComments;
        this.swallowCDataContent = swallowCDataContent;
        this.compressSpaces = false;
    }

    public FaceletsProcessingInstructions(boolean consumeXmlDocType, boolean consumeXmlDeclaration, boolean consumeProcessingInstructions, boolean consumeCDataSections, boolean escapeInlineText, boolean consumeXMLComments, boolean swallowCDataContent, boolean compressSpaces) {
        this.consumeXmlDocType = consumeXmlDocType;
        this.consumeXmlDeclaration = consumeXmlDeclaration;
        this.consumeProcessingInstructions = consumeProcessingInstructions;
        this.consumeCDataSections = consumeCDataSections;
        this.escapeInlineText = escapeInlineText;
        this.consumeXMLComments = consumeXMLComments;
        this.swallowCDataContent = swallowCDataContent;
        this.compressSpaces = compressSpaces;
    }

    public boolean isConsumeXmlDocType() {
        return this.consumeXmlDocType;
    }

    public boolean isConsumeXmlDeclaration() {
        return this.consumeXmlDeclaration;
    }

    public boolean isConsumeProcessingInstructions() {
        return this.consumeProcessingInstructions;
    }

    public boolean isConsumeCDataSections() {
        return this.consumeCDataSections;
    }

    public boolean isEscapeInlineText() {
        return this.escapeInlineText;
    }

    public boolean isConsumeXMLComments() {
        return this.consumeXMLComments;
    }

    public boolean isSwallowCDataContent() {
        return this.swallowCDataContent;
    }

    public boolean isCompressSpaces() {
        return this.compressSpaces;
    }
}

