/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.inmemory.content.fractal;

import org.apache.chemistry.opencmis.inmemory.content.fractal.ComplexPoint;

public class ComplexRectangle {
    private double iMin;
    private double iMax;
    private double rMin;
    private double rMax;

    public ComplexRectangle(double r1, double r2, double i1, double i2) {
        this.set(r1, r2, i1, i2);
    }

    public ComplexRectangle() {
        this.set(0.0, 0.0, 0.0, 0.0);
    }

    public ComplexRectangle(ComplexRectangle cr) {
        this.set(cr);
    }

    public double getIMin() {
        return this.iMin;
    }

    public double getIMax() {
        return this.iMax;
    }

    public double getRMin() {
        return this.rMin;
    }

    public double getRMax() {
        return this.rMax;
    }

    public double getHeight() {
        return this.iMax - this.iMin;
    }

    public double getWidth() {
        return this.rMax - this.rMin;
    }

    public void set(ComplexRectangle cr) {
        this.set(cr.getRMin(), cr.getRMax(), cr.getIMin(), cr.getIMax());
    }

    public void set(ComplexPoint p1, ComplexPoint p2) {
        this.set(p1.getReal(), p2.getReal(), p1.getImaginary(), p2.getImaginary());
    }

    public void set(double r1, double r2, double i1, double i2) {
        if (r1 > r2) {
            this.rMin = r2;
            this.rMax = r1;
        } else {
            this.rMin = r1;
            this.rMax = r2;
        }
        if (i1 > i2) {
            this.iMin = i2;
            this.iMax = i1;
        } else {
            this.iMin = i1;
            this.iMax = i2;
        }
    }
}

