/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.image;

import java.awt.Point;
import java.util.Arrays;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import org.apache.sis.image.ErrorAction;
import org.apache.sis.internal.feature.Resources;
import org.apache.sis.util.ArgumentChecks;

public interface ErrorHandler {
    public static final ErrorHandler THROW = ErrorAction.THROW;
    public static final ErrorHandler LOG = ErrorAction.LOG;

    public void handle(Report var1);

    public static class Report {
        private int[] indices;
        private int length;
        private LogRecord description;

        public synchronized boolean isEmpty() {
            return this.length == 0 && this.description == null;
        }

        private static boolean equals(Throwable throwable, Throwable throwable2) {
            if (throwable == throwable2) {
                return true;
            }
            return throwable != null && throwable2 != null && throwable.getClass() == throwable2.getClass() && Objects.equals(throwable.getMessage(), throwable2.getMessage()) && Arrays.equals(throwable.getStackTrace(), throwable2.getStackTrace());
        }

        private static void addSuppressed(Throwable throwable, Throwable throwable2) {
            if (Report.equals(throwable, throwable2) || Report.equals(throwable.getCause(), throwable2)) {
                return;
            }
            for (Throwable throwable3 : throwable.getSuppressed()) {
                if (!Report.equals(throwable3, throwable2)) continue;
                return;
            }
            throwable.addSuppressed(throwable2);
        }

        public synchronized boolean add(Point point, Throwable throwable, Supplier<LogRecord> supplier) {
            ArgumentChecks.ensureNonNull("error", throwable);
            if (point != null) {
                if (this.indices == null) {
                    this.indices = new int[8];
                } else if (this.length >= this.indices.length) {
                    this.indices = Arrays.copyOf(this.indices, this.indices.length * 2);
                }
                this.indices[this.length++] = point.x;
                this.indices[this.length++] = point.y;
            }
            if (this.description == null) {
                if (supplier != null) {
                    this.description = supplier.get();
                }
                if (this.description == null) {
                    this.description = point != null ? Resources.forLocale(null).getLogRecord(Level.WARNING, (short)9, point.x, point.y) : new LogRecord(Level.WARNING, throwable.toString());
                }
                this.description.setThrown(throwable);
                return true;
            }
            Report.addSuppressed(this.description.getThrown(), throwable);
            return false;
        }

        public synchronized Point[] getTileIndices() {
            Point[] pointArray = new Point[this.length >>> 1];
            int n = 0;
            while (n < this.length) {
                pointArray[n >>> 1] = new Point(this.indices[n++], this.indices[n++]);
            }
            return pointArray;
        }

        public synchronized LogRecord getDescription() {
            return this.description;
        }
    }
}

