/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.storage;

import java.util.Locale;
import java.util.Optional;
import org.apache.sis.internal.storage.MetadataBuilder;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.Resource;
import org.apache.sis.storage.event.StoreEvent;
import org.apache.sis.storage.event.StoreListener;
import org.apache.sis.storage.event.StoreListeners;
import org.apache.sis.storage.event.WarningEvent;
import org.apache.sis.util.AbstractInternationalString;
import org.apache.sis.util.CharSequences;
import org.opengis.geometry.Envelope;
import org.opengis.metadata.Metadata;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.GenericName;
import org.opengis.util.InternationalString;

public class AbstractResource
extends StoreListeners
implements Resource {
    private Metadata metadata;

    public AbstractResource(StoreListeners storeListeners) {
        super(storeListeners, null);
    }

    @Override
    public Optional<GenericName> getIdentifier() throws DataStoreException {
        return Optional.empty();
    }

    public Optional<Envelope> getEnvelope() throws DataStoreException {
        return Optional.empty();
    }

    @Override
    public final synchronized Metadata getMetadata() throws DataStoreException {
        if (this.metadata == null) {
            this.metadata = this.createMetadata();
        }
        return this.metadata;
    }

    protected Metadata createMetadata() throws DataStoreException {
        MetadataBuilder metadataBuilder = new MetadataBuilder();
        this.createMetadata(metadataBuilder);
        return metadataBuilder.build(true);
    }

    protected void createMetadata(MetadataBuilder metadataBuilder) throws DataStoreException {
        this.getIdentifier().ifPresent(genericName -> metadataBuilder.addTitle((CharSequence)((Object)new Sentence((GenericName)genericName))));
        this.getEnvelope().ifPresent(envelope -> {
            try {
                metadataBuilder.addExtent((Envelope)envelope);
            }
            catch (UnsupportedOperationException | TransformException throwable) {
                this.warning((Exception)throwable);
            }
        });
    }

    protected synchronized void clearCache() {
        this.metadata = null;
    }

    @Override
    public <T extends StoreEvent> void addListener(Class<T> clazz, StoreListener<? super T> storeListener) {
        if (storeListener == null || clazz == null || clazz.isAssignableFrom(WarningEvent.class)) {
            super.addListener(clazz, storeListener);
        }
    }

    private static final class Sentence
    extends AbstractInternationalString {
        private final InternationalString name;

        Sentence(GenericName genericName) {
            this.name = genericName.toInternationalString();
        }

        @Override
        public String toString(Locale locale) {
            return CharSequences.camelCaseToSentence(this.name.toString(locale)).toString();
        }

        public int hashCode() {
            return ~this.name.hashCode();
        }

        public boolean equals(Object object) {
            return object instanceof Sentence && this.name.equals(((Sentence)object).name);
        }
    }
}

