/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.inmemory.server;

import java.util.ArrayList;
import java.util.List;
import org.apache.chemistry.opencmis.commons.data.ContentStream;
import org.apache.chemistry.opencmis.commons.data.ObjectData;
import org.apache.chemistry.opencmis.commons.data.ObjectInFolderContainer;
import org.apache.chemistry.opencmis.commons.data.ObjectInFolderData;
import org.apache.chemistry.opencmis.commons.data.ObjectInFolderList;
import org.apache.chemistry.opencmis.commons.data.ObjectList;
import org.apache.chemistry.opencmis.commons.data.ObjectParentData;
import org.apache.chemistry.opencmis.commons.data.RenditionData;
import org.apache.chemistry.opencmis.commons.definitions.TypeDefinition;
import org.apache.chemistry.opencmis.commons.enums.CmisVersion;
import org.apache.chemistry.opencmis.commons.enums.IncludeRelationships;
import org.apache.chemistry.opencmis.commons.enums.RelationshipDirection;
import org.apache.chemistry.opencmis.commons.impl.server.ObjectInfoImpl;
import org.apache.chemistry.opencmis.commons.impl.server.RenditionInfoImpl;
import org.apache.chemistry.opencmis.commons.server.CallContext;
import org.apache.chemistry.opencmis.commons.server.ObjectInfo;
import org.apache.chemistry.opencmis.commons.server.ObjectInfoHandler;
import org.apache.chemistry.opencmis.inmemory.storedobj.api.Content;
import org.apache.chemistry.opencmis.inmemory.storedobj.api.DocumentVersion;
import org.apache.chemistry.opencmis.inmemory.storedobj.api.Filing;
import org.apache.chemistry.opencmis.inmemory.storedobj.api.ObjectStore;
import org.apache.chemistry.opencmis.inmemory.storedobj.api.StoreManager;
import org.apache.chemistry.opencmis.inmemory.storedobj.api.StoredObject;
import org.apache.chemistry.opencmis.inmemory.storedobj.api.VersionedDocument;
import org.apache.chemistry.opencmis.inmemory.types.PropertyCreationHelper;
import org.apache.chemistry.opencmis.server.support.TypeManager;

public class AtomLinkInfoProvider {
    private final StoreManager fStoreManager;

    public AtomLinkInfoProvider(StoreManager storeManager) {
        this.fStoreManager = storeManager;
    }

    public void fillInformationForAtomLinks(CallContext callContext, String repositoryId, StoredObject so, ObjectData od, ObjectInfoImpl objInfo) {
        DocumentVersion pwc;
        if (null == objInfo || null == so) {
            return;
        }
        boolean cmis11 = callContext.getCmisVersion() != CmisVersion.CMIS_1_0;
        TypeDefinition typeDef = this.fStoreManager.getTypeById(repositoryId, so.getTypeId(), cmis11).getTypeDefinition();
        ObjectStore objStore = this.fStoreManager.getObjectStore(repositoryId);
        objInfo.setId(so.getId());
        objInfo.setName(so.getName());
        objInfo.setCreatedBy(so.getCreatedBy());
        objInfo.setCreationDate(so.getCreatedAt());
        objInfo.setLastModificationDate(so.getModifiedAt());
        objInfo.setTypeId(so.getTypeId());
        objInfo.setBaseType(typeDef.getBaseTypeId());
        objInfo.setObject(od);
        if (so instanceof DocumentVersion) {
            DocumentVersion ver = (DocumentVersion)so;
            pwc = ver.getParentDocument().getPwc();
            objInfo.setIsCurrentVersion(ver == ver.getParentDocument().getLatestVersion(false));
            objInfo.setVersionSeriesId(ver.getParentDocument().getId());
            objInfo.setWorkingCopyId(pwc == null ? null : pwc.getId());
            objInfo.setWorkingCopyOriginalId(pwc == ver && ver.getParentDocument().getLatestVersion(false) != null ? ver.getParentDocument().getLatestVersion(false).getId() : null);
        } else if (so instanceof VersionedDocument) {
            VersionedDocument doc = (VersionedDocument)so;
            pwc = doc.getPwc();
            objInfo.setIsCurrentVersion(false);
            objInfo.setVersionSeriesId(doc.getId());
            objInfo.setWorkingCopyId(pwc == null ? null : pwc.getId());
            objInfo.setWorkingCopyOriginalId(null);
        } else {
            objInfo.setIsCurrentVersion(true);
            objInfo.setVersionSeriesId(null);
            objInfo.setWorkingCopyId(null);
            objInfo.setWorkingCopyOriginalId(null);
        }
        if (so instanceof Content) {
            ContentStream contentStream = ((Content)((Object)so)).getContent();
            objInfo.setHasContent(contentStream != null);
            objInfo.setContentType(contentStream != null ? contentStream.getMimeType() : null);
            objInfo.setFileName(contentStream != null ? contentStream.getFileName() : null);
        } else {
            objInfo.setHasContent(false);
            objInfo.setContentType(null);
            objInfo.setFileName(null);
        }
        if (so instanceof Filing) {
            Filing sop = (Filing)((Object)so);
            objInfo.setHasParent(sop.hasParent());
        } else {
            objInfo.setHasParent(false);
        }
        List<RenditionData> renditions = objStore.getRenditions(so, "*", 0L, 0L);
        if (renditions == null || renditions.size() == 0) {
            objInfo.setRenditionInfos(null);
        } else {
            ArrayList<RenditionInfoImpl> infos = new ArrayList<RenditionInfoImpl>();
            for (RenditionData renditionData : renditions) {
                RenditionInfoImpl info = new RenditionInfoImpl();
                info.setKind(renditionData.getKind());
                info.setId(renditionData.getStreamId());
                info.setContentType(renditionData.getMimeType());
                info.setLength(renditionData.getBigLength());
                info.setTitle(renditionData.getTitle());
                infos.add(info);
            }
            objInfo.setRenditionInfos(infos);
        }
        objInfo.setSupportsRelationships(true);
        List<StoredObject> rels = objStore.getRelationships(so.getId(), null, RelationshipDirection.SOURCE);
        ArrayList<String> srcIds = new ArrayList<String>(rels.size());
        for (StoredObject rel : rels) {
            srcIds.add(rel.getId());
        }
        rels = objStore.getRelationships(so.getId(), null, RelationshipDirection.TARGET);
        ArrayList<String> arrayList = new ArrayList<String>(rels.size());
        for (StoredObject rel : rels) {
            arrayList.add(rel.getId());
        }
        objInfo.setRelationshipSourceIds(srcIds);
        objInfo.setRelationshipTargetIds(arrayList);
        objInfo.setSupportsPolicies(true);
        objInfo.setHasAcl(true);
        objInfo.setSupportsDescendants(true);
        objInfo.setSupportsFolderTree(true);
    }

    public void fillInformationForAtomLinks(CallContext callContext, String repositoryId, StoredObject so, ObjectInfoImpl objectInfo) {
        TypeManager tm = this.fStoreManager.getTypeManager(repositoryId);
        ObjectStore objStore = this.fStoreManager.getObjectStore(repositoryId);
        ObjectData od = PropertyCreationHelper.getObjectData(callContext, tm, objStore, so, null, null, false, IncludeRelationships.NONE, null, false, false, null);
        this.fillInformationForAtomLinks(callContext, repositoryId, so, od, objectInfo);
    }

    public void fillInformationForAtomLinks(CallContext callContext, String repositoryId, String objectId, ObjectInfoImpl objectInfo) {
        if (null == objectInfo || null == objectId) {
            return;
        }
        ObjectStore objectStore = this.fStoreManager.getObjectStore(repositoryId);
        StoredObject so = objectStore.getObjectById(objectId);
        this.fillInformationForAtomLinks(callContext, repositoryId, so, objectInfo);
    }

    public void fillInformationForAtomLinks(CallContext callContext, String repositoryId, String objectId, ObjectInfoHandler objectInfos, ObjectInFolderList objList) {
        if (null == objectInfos || null == objList || null == objectId) {
            return;
        }
        ObjectInfoImpl objectInfo = new ObjectInfoImpl();
        this.fillInformationForAtomLinks(callContext, repositoryId, objectId, objectInfo);
        objectInfos.addObjectInfo((ObjectInfo)objectInfo);
        for (ObjectInFolderData object : objList.getObjects()) {
            objectInfo = new ObjectInfoImpl();
            this.fillInformationForAtomLinks(callContext, repositoryId, object.getObject().getId(), objectInfo);
            objectInfos.addObjectInfo((ObjectInfo)objectInfo);
        }
    }

    public void fillInformationForAtomLinks(CallContext callContext, String repositoryId, String objectId, ObjectInfoHandler objectInfos, ObjectList objList) {
        List listObjects;
        ObjectInfoImpl objectInfo = new ObjectInfoImpl();
        if (null != objectId) {
            this.fillInformationForAtomLinks(callContext, repositoryId, objectId, objectInfo);
            objectInfos.addObjectInfo((ObjectInfo)objectInfo);
        }
        if (null != objList && null != objList.getObjects() && null != (listObjects = objList.getObjects())) {
            for (ObjectData object : listObjects) {
                objectInfo = new ObjectInfoImpl();
                this.fillInformationForAtomLinks(object, objectInfo);
                objectInfos.addObjectInfo((ObjectInfo)objectInfo);
            }
        }
    }

    private void fillInformationForAtomLinks(ObjectData od, ObjectInfoImpl objectInfo) {
        objectInfo.setObject(od);
    }

    private void fillInformationForAtomLinks(CallContext callContext, String repositoryId, ObjectInfoHandler objectInfos, ObjectInFolderContainer oifc) {
        if (null == objectInfos || null == oifc) {
            return;
        }
        this.fillInformationForAtomLinks(callContext, repositoryId, objectInfos, oifc.getObject());
        if (null != oifc.getChildren()) {
            for (ObjectInFolderContainer object : oifc.getChildren()) {
                ObjectInfoImpl objectInfo = new ObjectInfoImpl();
                this.fillInformationForAtomLinks(callContext, repositoryId, objectInfos, object);
                objectInfos.addObjectInfo((ObjectInfo)objectInfo);
            }
        }
    }

    public void fillInformationForAtomLinks(CallContext callContext, String repositoryId, String objectId, ObjectInfoHandler objectInfos, List<ObjectInFolderContainer> oifcList) {
        if (null == objectInfos || null == oifcList || null == objectId) {
            return;
        }
        ObjectInfoImpl objectInfo = new ObjectInfoImpl();
        this.fillInformationForAtomLinks(callContext, repositoryId, objectId, objectInfo);
        objectInfos.addObjectInfo((ObjectInfo)objectInfo);
        for (ObjectInFolderContainer object : oifcList) {
            this.fillInformationForAtomLinks(callContext, repositoryId, objectInfos, object);
        }
    }

    private void fillInformationForAtomLinks(CallContext callContext, String repositoryId, ObjectInfoHandler objectInfos, ObjectInFolderData object) {
        ObjectInfoImpl objectInfo = new ObjectInfoImpl();
        this.fillInformationForAtomLinks(callContext, repositoryId, object.getObject().getId(), objectInfo);
        objectInfos.addObjectInfo((ObjectInfo)objectInfo);
    }

    public void fillInformationForAtomLinksGetParents(CallContext callContext, String repositoryId, String objectId, ObjectInfoHandler objectInfos, List<ObjectParentData> objParents) {
        if (null == objectInfos || null == objParents || null == objectId) {
            return;
        }
        ObjectInfoImpl objectInfo = new ObjectInfoImpl();
        this.fillInformationForAtomLinks(callContext, repositoryId, objectId, objectInfo);
        for (ObjectParentData object : objParents) {
            objectInfo = new ObjectInfoImpl();
            this.fillInformationForAtomLinks(callContext, repositoryId, object.getObject().getId(), objectInfo);
            objectInfos.addObjectInfo((ObjectInfo)objectInfo);
        }
    }
}

