/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing;

import java.util.Collection;
import java.util.Iterator;
import org.apache.sis.internal.jaxb.Context;
import org.apache.sis.internal.metadata.NameMeaning;
import org.apache.sis.internal.referencing.NilReferencingObject;
import org.apache.sis.internal.util.Strings;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.util.GenericName;

final class NameIterator
implements Iterator<ReferenceIdentifier> {
    private ReferenceIdentifier next;
    private final Iterator<GenericName> alias;

    NameIterator(IdentifiedObject identifiedObject) {
        this.alias = identifiedObject.getAlias().iterator();
        this.next = identifiedObject.getName();
        if (NameIterator.isUnnamed(this.next)) {
            this.next();
        }
    }

    static boolean isUnnamed(ReferenceIdentifier referenceIdentifier) {
        return referenceIdentifier == null || referenceIdentifier == NilReferencingObject.UNNAMED;
    }

    @Override
    public boolean hasNext() {
        return this.next != null;
    }

    @Override
    public ReferenceIdentifier next() {
        ReferenceIdentifier referenceIdentifier = this.next;
        while (this.alias.hasNext()) {
            GenericName genericName = this.alias.next();
            if (!(genericName instanceof ReferenceIdentifier)) continue;
            this.next = (ReferenceIdentifier)genericName;
            return referenceIdentifier;
        }
        this.next = null;
        return referenceIdentifier;
    }

    public static int count(IdentifiedObject identifiedObject) {
        int n = 0;
        NameIterator nameIterator = new NameIterator(identifiedObject);
        while (nameIterator.hasNext()) {
            nameIterator.next();
            ++n;
        }
        return n;
    }

    /*
     * WARNING - void declaration
     */
    static String getID(Context context, IdentifiedObject identifiedObject, ReferenceIdentifier referenceIdentifier, Collection<? extends GenericName> collection, Collection<? extends ReferenceIdentifier> collection2) {
        String string = Context.getObjectID(context, identifiedObject);
        if (string == null) {
            StringBuilder stringBuilder = new StringBuilder();
            if (collection2 != null) {
                for (ReferenceIdentifier referenceIdentifier2 : collection2) {
                    if (Strings.appendUnicodeIdentifier(stringBuilder, '-', referenceIdentifier2.getCodeSpace(), "", true) | Strings.appendUnicodeIdentifier(stringBuilder, '-', NameMeaning.toObjectType(identifiedObject.getClass()), "", false) | Strings.appendUnicodeIdentifier(stringBuilder, '-', referenceIdentifier2.getCode(), "", true) && Context.setObjectForID(context, identifiedObject, string = stringBuilder.toString())) {
                        return string;
                    }
                    stringBuilder.setLength(0);
                }
            }
            if ((NameIterator.isUnnamed(referenceIdentifier) || !Strings.appendUnicodeIdentifier(stringBuilder, '-', referenceIdentifier.getCode(), "", false)) && collection != null) {
                GenericName genericName;
                Iterator<? extends ReferenceIdentifier> iterator = collection.iterator();
                while (iterator.hasNext() && !Strings.appendUnicodeIdentifier(stringBuilder, '-', (genericName = (GenericName)iterator.next()).toString(), "", false)) {
                }
            }
            if (stringBuilder.length() != 0 && !Context.setObjectForID(context, identifiedObject, string = stringBuilder.toString())) {
                int n = stringBuilder.append('-').length();
                boolean bl = false;
                do {
                    void var8_13;
                    if (++var8_13 == 100) {
                        return null;
                    }
                    string = stringBuilder.append((int)var8_13).toString();
                    stringBuilder.setLength(n);
                } while (!Context.setObjectForID(context, identifiedObject, string));
            }
        }
        return string;
    }
}

