/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.client2.jsonextract;

import com.dropbox.client2.jsonextract.JsonBase;
import com.dropbox.client2.jsonextract.JsonExtractionException;
import com.dropbox.client2.jsonextract.JsonExtractor;
import com.dropbox.client2.jsonextract.JsonThing;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public final class JsonList
extends JsonBase<List<Object>>
implements Iterable<JsonThing> {
    public JsonList(List<Object> internal, String path) {
        super(internal, path);
    }

    public JsonList(List<Object> internal) {
        super(internal);
    }

    private static String pathConcatIndex(String path, int index) {
        return JsonThing.pathConcat(path, Integer.toString(index));
    }

    public JsonThing get(int index) throws JsonExtractionException {
        if (index >= ((List)this.internal).size()) {
            throw this.error("expecting array to have an element at index " + index + ", but it only has length " + ((List)this.internal).size());
        }
        return new JsonThing(((List)this.internal).get(index), JsonList.pathConcatIndex(this.path, index));
    }

    public void expectLength(int length) throws JsonExtractionException {
        if (((List)this.internal).size() != length) {
            throw this.error("expecting array to have length " + length + ", but it has length " + ((List)this.internal).size());
        }
    }

    public int length() {
        return ((List)this.internal).size();
    }

    @Override
    public Iterator<JsonThing> iterator() {
        return new WrapperIterator(this.path, ((List)this.internal).iterator());
    }

    public <T> ArrayList<T> extract(JsonExtractor<T> elementExtractor) throws JsonExtractionException {
        ArrayList<T> result = new ArrayList<T>(this.length());
        for (Object o : (List)this.internal) {
            result.add(elementExtractor.extract(new JsonThing(o)));
        }
        return result;
    }

    public static final class Extractor<T>
    extends JsonExtractor<List<T>> {
        public final JsonExtractor<T> elementExtractor;

        public Extractor(JsonExtractor<T> elementExtractor) {
            this.elementExtractor = elementExtractor;
        }

        @Override
        public List<T> extract(JsonThing jt) throws JsonExtractionException {
            return jt.expectList().extract(this.elementExtractor);
        }
    }

    private static final class WrapperIterator
    implements Iterator<JsonThing> {
        private int numReturned = 0;
        private final String path;
        private final Iterator<Object> internal;

        private WrapperIterator(String path, Iterator<Object> internal) {
            this.path = path;
            this.internal = internal;
        }

        @Override
        public boolean hasNext() {
            return this.internal.hasNext();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("can't remove");
        }

        @Override
        public JsonThing next() {
            int index = this.numReturned++;
            return new JsonThing(this.internal.next(), JsonList.pathConcatIndex(this.path, index));
        }
    }
}

