/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.crawler.connectors.confluence.v6.model;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.manifoldcf.crawler.connectors.confluence.v6.model.ConfluenceResource;
import org.apache.manifoldcf.crawler.connectors.confluence.v6.model.Group;
import org.apache.manifoldcf.crawler.connectors.confluence.v6.model.User;
import org.apache.manifoldcf.crawler.connectors.confluence.v6.model.builder.ConfluenceResourceBuilder;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public class Restrictions
extends ConfluenceResource {
    protected static final String KEY_READ = "read";
    protected static final String KEY_OPERATION = "operation";
    protected static final String KEY_RESTRICTIONS = "restrictions";
    protected static final String KEY_USER = "user";
    protected static final String KEY_RESULTS = "results";
    protected static final String KEY_USERNAME = "username";
    protected static final String KEY_USER_KEY = "userKey";
    protected static final String KEY_DISPLAY_NAME = "displayName";
    protected static final String KEY_GROUP = "group";
    protected static final String KEY_NAME = "name";
    protected static final String KEY_TYPE = "type";
    protected static final String KEY_UPDATE = "update";
    protected ReadRestrictions readRestrictions;

    public ReadRestrictions getReadRestrictions() {
        return this.readRestrictions;
    }

    public static ConfluenceResourceBuilder<? extends Restrictions> builder() {
        return new RestrictionsBuilder();
    }

    public static class RestrictionsBuilder
    implements ConfluenceResourceBuilder<Restrictions> {
        @Override
        public Restrictions fromJson(JSONObject restrictionsJson) {
            return this.fromJson(restrictionsJson, new Restrictions());
        }

        @Override
        public Restrictions fromJson(JSONObject restrictionsJson, Restrictions restrictions) {
            Restrictions restrictions2 = restrictions;
            Objects.requireNonNull(restrictions2);
            restrictions.readRestrictions = restrictions2.new ReadRestrictions(restrictionsJson);
            return restrictions;
        }

        @Override
        public Class<Restrictions> getType() {
            return Restrictions.class;
        }
    }

    public class ReadRestrictions {
        protected final List<User> users = new ArrayList<User>();
        protected final List<Group> groups = new ArrayList<Group>();

        public List<User> getUsers() {
            return this.users;
        }

        public List<Group> getGroups() {
            return this.groups;
        }

        protected ReadRestrictions() {
        }

        protected ReadRestrictions(JSONObject readRestrictionsJson) {
            int i;
            if (readRestrictionsJson.get((Object)Restrictions.KEY_USER) != null) {
                JSONObject jsonUsers = (JSONObject)readRestrictionsJson.get((Object)Restrictions.KEY_USER);
                JSONArray usersResults = (JSONArray)jsonUsers.get((Object)Restrictions.KEY_RESULTS);
                for (i = 0; i < usersResults.size(); ++i) {
                    JSONObject jsonUser = (JSONObject)usersResults.get(i);
                    User user = User.builder().fromJson(jsonUser);
                    this.users.add(user);
                }
            }
            if (readRestrictionsJson.get((Object)Restrictions.KEY_GROUP) != null) {
                JSONObject jsonGroups = (JSONObject)readRestrictionsJson.get((Object)Restrictions.KEY_GROUP);
                JSONArray groupsResults = (JSONArray)jsonGroups.get((Object)Restrictions.KEY_RESULTS);
                for (i = 0; i < groupsResults.size(); ++i) {
                    JSONObject jsonGroup = (JSONObject)groupsResults.get(i);
                    Group group = Group.builder().fromJson(jsonGroup);
                    this.groups.add(group);
                }
            }
        }
    }
}

