/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io.eval;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import org.apache.commons.math3.stat.inference.TTest;
import org.apache.solr.client.solrj.io.Tuple;
import org.apache.solr.client.solrj.io.eval.RecursiveNumericListEvaluator;
import org.apache.solr.client.solrj.io.eval.TwoValueWorker;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpression;
import org.apache.solr.client.solrj.io.stream.expr.StreamFactory;

public class PairedTTestEvaluator
extends RecursiveNumericListEvaluator
implements TwoValueWorker {
    protected static final long serialVersionUID = 1L;

    public PairedTTestEvaluator(StreamExpression expression, StreamFactory factory) throws IOException {
        super(expression, factory);
        if (this.containedEvaluators.size() != 2) {
            throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - expecting two parameters but found %d", expression, this.containedEvaluators.size()));
        }
    }

    @Override
    public Object doWork(Object value1, Object value2) throws IOException {
        TTest tTest = new TTest();
        HashMap map = new HashMap();
        Tuple tuple = new Tuple(map);
        if (value1 instanceof List) {
            List values1 = (List)value1;
            double[] samples1 = new double[values1.size()];
            for (int i = 0; i < samples1.length; ++i) {
                samples1[i] = ((Number)values1.get(i)).doubleValue();
            }
            if (value2 instanceof List) {
                List values2 = (List)value2;
                double[] samples2 = new double[values2.size()];
                for (int i = 0; i < samples2.length; ++i) {
                    samples2[i] = ((Number)values2.get(i)).doubleValue();
                }
                double tstat = tTest.pairedT(samples1, samples2);
                double pval = tTest.pairedTTest(samples1, samples2);
                tuple.put("t-statistic", tstat);
                tuple.put("p-value", pval);
                return tuple;
            }
            throw new IOException("Second parameter for pairedTtest must be a double array");
        }
        throw new IOException("First parameter for pairedTtest must be a double array");
    }
}

