/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.inmemory;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.chemistry.opencmis.commons.definitions.PropertyDefinition;
import org.apache.chemistry.opencmis.commons.definitions.TypeDefinition;
import org.apache.chemistry.opencmis.commons.definitions.TypeDefinitionContainer;
import org.apache.chemistry.opencmis.commons.exceptions.CmisNotSupportedException;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.AbstractPropertyDefinition;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.TypeDefinitionContainerImpl;
import org.apache.chemistry.opencmis.inmemory.types.DocumentTypeCreationHelper;
import org.apache.chemistry.opencmis.inmemory.types.TypeUtil;
import org.apache.chemistry.opencmis.server.support.TypeManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TypeManagerImpl
implements TypeManager {
    private static final Logger LOG = LoggerFactory.getLogger((String)TypeManagerImpl.class.getName());
    private final Map<String, TypeDefinitionContainer> fTypesMap = new HashMap<String, TypeDefinitionContainer>();

    public TypeDefinitionContainer getTypeById(String typeId) {
        return this.fTypesMap.get(typeId);
    }

    public TypeDefinition getTypeByQueryName(String typeQueryName) {
        for (Map.Entry<String, TypeDefinitionContainer> entry : this.fTypesMap.entrySet()) {
            if (!entry.getValue().getTypeDefinition().getQueryName().equals(typeQueryName)) continue;
            return entry.getValue().getTypeDefinition();
        }
        return null;
    }

    public Collection<TypeDefinitionContainer> getTypeDefinitionList() {
        return Collections.unmodifiableCollection(this.fTypesMap.values());
    }

    public List<TypeDefinitionContainer> getRootTypes() {
        ArrayList<TypeDefinitionContainer> rootTypes = new ArrayList<TypeDefinitionContainer>();
        for (TypeDefinitionContainer type : this.fTypesMap.values()) {
            if (!TypeManagerImpl.isRootType(type)) continue;
            rootTypes.add(type);
        }
        return rootTypes;
    }

    public void initTypeSystem(List<TypeDefinition> typesList, boolean createCmisDefaultTypes) {
        if (createCmisDefaultTypes) {
            this.createCmisDefaultTypes();
        }
        if (null != typesList) {
            for (TypeDefinition typeDef : typesList) {
                this.addTypeDefinition(typeDef, true);
            }
        }
    }

    public void addTypeDefinition(TypeDefinition cmisType, boolean addInheritedProperties) {
        LOG.info("Adding type definition with name " + cmisType.getLocalName() + " and id " + cmisType.getId() + " to repository.");
        TypeDefinitionContainerImpl typeContainer = new TypeDefinitionContainerImpl(cmisType);
        if (null != cmisType.getParentTypeId()) {
            TypeDefinitionContainer parentTypeContainer = this.fTypesMap.get(cmisType.getParentTypeId());
            parentTypeContainer.getChildren().add(typeContainer);
            if (addInheritedProperties) {
                Map propDefs = typeContainer.getTypeDefinition().getPropertyDefinitions();
                this.addInheritedProperties(propDefs, parentTypeContainer.getTypeDefinition());
            }
        }
        this.fTypesMap.put(cmisType.getId(), (TypeDefinitionContainer)typeContainer);
    }

    public void updateTypeDefinition(TypeDefinition typeDefinition) {
        throw new CmisNotSupportedException("updating a type definition is not supported.");
    }

    public void deleteTypeDefinition(String typeId) {
        TypeDefinitionContainer typeDef = this.fTypesMap.remove(typeId);
        TypeDefinitionContainer parentTypeContainer = this.fTypesMap.get(typeDef.getTypeDefinition().getParentTypeId());
        parentTypeContainer.getChildren().remove(typeDef);
        this.fTypesMap.remove(typeId);
    }

    public void clearTypeSystem() {
        this.fTypesMap.clear();
        this.createCmisDefaultTypes();
    }

    public String getPropertyIdForQueryName(TypeDefinition typeDefinition, String propQueryName) {
        for (PropertyDefinition pd : typeDefinition.getPropertyDefinitions().values()) {
            if (!pd.getQueryName().equals(propQueryName)) continue;
            return pd.getId();
        }
        return null;
    }

    private void addInheritedProperties(Map<String, PropertyDefinition<?>> propDefs, TypeDefinition typeDefinition) {
        TypeDefinitionContainer parentTypeContainer;
        if (null == typeDefinition) {
            return;
        }
        if (null != typeDefinition.getPropertyDefinitions()) {
            TypeManagerImpl.addInheritedPropertyDefinitions(propDefs, typeDefinition.getPropertyDefinitions());
        }
        TypeDefinition parentType = null == (parentTypeContainer = this.fTypesMap.get(typeDefinition.getParentTypeId())) ? null : parentTypeContainer.getTypeDefinition();
        this.addInheritedProperties(propDefs, parentType);
    }

    private static void addInheritedPropertyDefinitions(Map<String, PropertyDefinition<?>> propDefs, Map<String, PropertyDefinition<?>> superPropDefs) {
        for (Map.Entry<String, PropertyDefinition<?>> superProp : superPropDefs.entrySet()) {
            PropertyDefinition<?> superPropDef = superProp.getValue();
            PropertyDefinition<?> clone = TypeManagerImpl.clonePropertyDefinition(superPropDef);
            ((AbstractPropertyDefinition)clone).setIsInherited(Boolean.valueOf(true));
            propDefs.put(superProp.getKey(), clone);
        }
    }

    private void createCmisDefaultTypes() {
        List<TypeDefinition> typesList = DocumentTypeCreationHelper.createDefaultTypes();
        for (TypeDefinition typeDef : typesList) {
            TypeDefinitionContainerImpl typeContainer = new TypeDefinitionContainerImpl(typeDef);
            this.fTypesMap.put(typeDef.getId(), (TypeDefinitionContainer)typeContainer);
        }
    }

    private static boolean isRootType(TypeDefinitionContainer c) {
        return c.getTypeDefinition().getId().equals(c.getTypeDefinition().getBaseTypeId().value());
    }

    private static PropertyDefinition<?> clonePropertyDefinition(PropertyDefinition<?> src) {
        AbstractPropertyDefinition<?> clone = TypeUtil.clonePropertyDefinition(src);
        return clone;
    }
}

