/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.crawler.connectors.webcrawler;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.manifoldcf.core.cachemanager.BaseDescription;
import org.apache.manifoldcf.core.cachemanager.ExecutorBase;
import org.apache.manifoldcf.core.database.BaseTable;
import org.apache.manifoldcf.core.interfaces.CacheManagerFactory;
import org.apache.manifoldcf.core.interfaces.ColumnDescription;
import org.apache.manifoldcf.core.interfaces.ICacheClass;
import org.apache.manifoldcf.core.interfaces.ICacheDescription;
import org.apache.manifoldcf.core.interfaces.ICacheExecutor;
import org.apache.manifoldcf.core.interfaces.ICacheHandle;
import org.apache.manifoldcf.core.interfaces.ICacheManager;
import org.apache.manifoldcf.core.interfaces.IDBInterface;
import org.apache.manifoldcf.core.interfaces.IResultRow;
import org.apache.manifoldcf.core.interfaces.IResultSet;
import org.apache.manifoldcf.core.interfaces.IThreadContext;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;
import org.apache.manifoldcf.core.interfaces.StringSet;
import org.apache.manifoldcf.core.interfaces.StringSetBuffer;

public class DNSManager
extends BaseTable {
    public static final String _rcsid = "@(#)$Id: DNSManager.java 988245 2010-08-23 18:39:35Z kwright $";
    protected static DNSCacheClass dnsCacheClass = new DNSCacheClass();
    protected static final String hostField = "hostname";
    protected static final String fqdnField = "canonicalhostname";
    protected static final String ipaddressField = "ipaddress";
    protected static final String expirationField = "expirationtime";
    ICacheManager cacheManager;

    public DNSManager(IThreadContext tc, IDBInterface database) throws ManifoldCFException {
        super(database, "dnsdata");
        this.cacheManager = CacheManagerFactory.make((IThreadContext)tc);
    }

    public void install() throws ManifoldCFException {
        block0: {
            Map existing = this.getTableSchema(null, null);
            if (existing != null) break block0;
            HashMap<String, ColumnDescription> map = new HashMap<String, ColumnDescription>();
            map.put(hostField, new ColumnDescription("VARCHAR(255)", true, false, null, null, false));
            map.put(fqdnField, new ColumnDescription("VARCHAR(255)", false, true, null, null, false));
            map.put(ipaddressField, new ColumnDescription("VARCHAR(16)", false, true, null, null, false));
            map.put(expirationField, new ColumnDescription("BIGINT", false, false, null, null, false));
            this.performCreate(map, null);
        }
    }

    public void deinstall() throws ManifoldCFException {
        this.performDrop(null);
    }

    public DNSInfo lookup(String hostName, long currentTime) throws ManifoldCFException {
        HostDescription[] objectDescriptions = new HostDescription[1];
        StringSetBuffer ssb = new StringSetBuffer();
        ssb.add(DNSManager.getDNSKey(hostName));
        objectDescriptions[0] = new HostDescription(hostName, new StringSet(ssb));
        HostExecutor exec = new HostExecutor(this, objectDescriptions[0]);
        this.cacheManager.findObjectsAndExecute((ICacheDescription[])objectDescriptions, null, (ICacheExecutor)exec, this.getTransactionID());
        DNSInfo rd = exec.getResults();
        if (rd == null || rd.getExpirationTime() <= currentTime) {
            return null;
        }
        return rd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeDNSData(String hostName, String fqdn, String ipaddress, long expirationTime) throws ManifoldCFException {
        StringSetBuffer ssb = new StringSetBuffer();
        ssb.add(DNSManager.getDNSKey(hostName));
        StringSet cacheKeys = new StringSet(ssb);
        ICacheHandle ch = this.cacheManager.enterCache(null, cacheKeys, this.getTransactionID());
        try {
            this.beginTransaction();
            try {
                ArrayList<String> params = new ArrayList<String>();
                params.add(hostName);
                IResultSet set = this.performQuery("SELECT * FROM " + this.getTableName() + " WHERE " + hostField + "=?", params, null, null);
                HashMap<String, Object> values = new HashMap<String, Object>();
                values.put(expirationField, new Long(expirationTime));
                if (fqdn == null) {
                    fqdn = "";
                }
                values.put(fqdnField, fqdn);
                if (ipaddress == null) {
                    ipaddress = "";
                }
                values.put(ipaddressField, ipaddress);
                if (set.getRowCount() > 0) {
                    params.clear();
                    params.add(hostName);
                    this.performUpdate(values, " WHERE hostname=?", params, null);
                } else {
                    values.put(hostField, hostName);
                    this.performInsert(values, null);
                }
                this.cacheManager.invalidateKeys(ch);
            }
            catch (ManifoldCFException e) {
                this.signalRollback();
                throw e;
            }
            catch (Error e) {
                this.signalRollback();
                throw e;
            }
            finally {
                this.endTransaction();
            }
        }
        finally {
            this.cacheManager.leaveCache(ch);
        }
    }

    protected static String getDNSKey(String hostName) {
        return "DNS_" + hostName;
    }

    protected DNSInfo readDNSInfo(String hostName) throws ManifoldCFException {
        String fqdn;
        ArrayList<String> list = new ArrayList<String>();
        list.add(hostName);
        IResultSet set = this.performQuery("SELECT ipaddress,canonicalhostname,expirationtime FROM " + this.getTableName() + " WHERE " + hostField + "=?", list, null, null);
        if (set.getRowCount() == 0) {
            return null;
        }
        IResultRow row = set.getRow(0);
        long expiration = (Long)row.getValue(expirationField);
        String ipaddress = (String)row.getValue(ipaddressField);
        if (ipaddress != null && ipaddress.length() == 0) {
            ipaddress = null;
        }
        if ((fqdn = (String)row.getValue(fqdnField)) != null && fqdn.length() == 0) {
            fqdn = null;
        }
        return new DNSInfo(ipaddress, fqdn, expiration, hostName);
    }

    protected static class HostExecutor
    extends ExecutorBase {
        protected DNSManager thisManager;
        protected DNSInfo returnValue;
        protected HostDescription thisHost;

        public HostExecutor(DNSManager manager, HostDescription objectDescription) {
            this.thisManager = manager;
            this.thisHost = objectDescription;
            this.returnValue = null;
        }

        public DNSInfo getResults() {
            return this.returnValue;
        }

        public Object[] create(ICacheDescription[] objectDescriptions) throws ManifoldCFException {
            Object[] rval = new DNSInfo[objectDescriptions.length];
            for (int i = 0; i < rval.length; ++i) {
                HostDescription desc = (HostDescription)objectDescriptions[i];
                rval[i] = this.thisManager.readDNSInfo(desc.getHostName());
            }
            return rval;
        }

        public void exists(ICacheDescription objectDescription, Object cachedObject) throws ManifoldCFException {
            HostDescription objectDesc = (HostDescription)objectDescription;
            DNSInfo data = (DNSInfo)cachedObject;
            if (objectDesc.equals((Object)this.thisHost)) {
                this.returnValue = data;
            }
        }

        public void execute() throws ManifoldCFException {
        }
    }

    protected static class DNSCacheClass
    implements ICacheClass {
        protected DNSCacheClass() {
        }

        public String getClassName() {
            return "DNSCLASS";
        }

        public int getMaxLRUCount() {
            return 2000;
        }
    }

    protected static class HostDescription
    extends BaseDescription {
        protected String hostName;
        protected String criticalSectionName;
        protected StringSet cacheKeys;

        public HostDescription(String hostName, StringSet invKeys) {
            super("dnscache");
            this.hostName = hostName;
            this.criticalSectionName = ((Object)((Object)this)).getClass().getName() + "-" + hostName;
            this.cacheKeys = invKeys;
        }

        public String getHostName() {
            return this.hostName;
        }

        public int hashCode() {
            return this.hostName.hashCode();
        }

        public boolean equals(Object o) {
            if (!(o instanceof HostDescription)) {
                return false;
            }
            HostDescription d = (HostDescription)((Object)o);
            return d.hostName.equals(this.hostName);
        }

        public String getCriticalSectionName() {
            return this.criticalSectionName;
        }

        public StringSet getObjectKeys() {
            return this.cacheKeys;
        }

        public ICacheClass getObjectClass() {
            return dnsCacheClass;
        }
    }

    protected static class DNSInfo {
        protected long expiration;
        protected String hostName;
        protected String ipaddress;
        protected String fqdn;

        public DNSInfo(String ipaddress, String fqdn, long expiration, String hostName) {
            this.ipaddress = ipaddress;
            this.fqdn = fqdn;
            this.expiration = expiration;
            this.hostName = hostName;
        }

        public String getIPAddress() {
            return this.ipaddress;
        }

        public String getFQDN() {
            return this.fqdn;
        }

        public long getExpirationTime() {
            return this.expiration;
        }

        public String getHostName() {
            return this.hostName;
        }
    }
}

