/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import org.apache.kafka.common.protocol.Protocol;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.requests.AbstractRequestResponse;

public class ResponseHeader
extends AbstractRequestResponse {
    private static Field CORRELATION_KEY_FIELD = Protocol.RESPONSE_HEADER.get("correlation_id");
    private final int correlationId;

    public ResponseHeader(Struct header) {
        super(header);
        this.correlationId = this.struct.getInt(CORRELATION_KEY_FIELD);
    }

    public ResponseHeader(int correlationId) {
        super(new Struct(Protocol.RESPONSE_HEADER));
        this.struct.set(CORRELATION_KEY_FIELD, (Object)correlationId);
        this.correlationId = correlationId;
    }

    public int correlationId() {
        return this.correlationId;
    }

    public static ResponseHeader parse(ByteBuffer buffer) {
        return new ResponseHeader((Struct)Protocol.RESPONSE_HEADER.read(buffer));
    }
}

