/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.authorities.authorities.jdbc;

import java.io.IOException;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.manifoldcf.agents.interfaces.ServiceInterruption;
import org.apache.manifoldcf.authorities.authorities.BaseAuthorityConnector;
import org.apache.manifoldcf.authorities.authorities.jdbc.Messages;
import org.apache.manifoldcf.authorities.interfaces.AuthorizationResponse;
import org.apache.manifoldcf.authorities.system.Logging;
import org.apache.manifoldcf.connectorcommon.interfaces.IKeystoreManager;
import org.apache.manifoldcf.connectorcommon.interfaces.KeystoreManagerFactory;
import org.apache.manifoldcf.core.cachemanager.BaseDescription;
import org.apache.manifoldcf.core.interfaces.BinaryInput;
import org.apache.manifoldcf.core.interfaces.CacheManagerFactory;
import org.apache.manifoldcf.core.interfaces.ConfigParams;
import org.apache.manifoldcf.core.interfaces.ICacheCreateHandle;
import org.apache.manifoldcf.core.interfaces.ICacheDescription;
import org.apache.manifoldcf.core.interfaces.ICacheHandle;
import org.apache.manifoldcf.core.interfaces.ICacheManager;
import org.apache.manifoldcf.core.interfaces.IHTTPOutput;
import org.apache.manifoldcf.core.interfaces.IPostParameters;
import org.apache.manifoldcf.core.interfaces.IThreadContext;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;
import org.apache.manifoldcf.core.interfaces.StringSet;
import org.apache.manifoldcf.core.interfaces.TimeMarker;
import org.apache.manifoldcf.jdbc.JDBCConnection;
import org.apache.manifoldcf.jdbc.JDBCConstants;
import org.apache.manifoldcf.ui.util.Encoder;

public class JDBCAuthority
extends BaseAuthorityConnector {
    public static final String _rcsid = "@(#)$Id: JDBCAuthority.java $";
    protected JDBCConnection connection = null;
    protected String jdbcProvider = null;
    protected String accessMethod = null;
    protected String host = null;
    protected String databaseName = null;
    protected String rawDriverString = null;
    protected String userName = null;
    protected String password = null;
    protected String idQuery = null;
    protected String tokenQuery = null;
    private long responseLifetime = 60000L;
    private int LRUsize = 1000;
    private ICacheManager cacheManager = null;
    protected static StringSet emptyStringSet = new StringSet();

    public void setThreadContext(IThreadContext tc) throws ManifoldCFException {
        super.setThreadContext(tc);
        this.cacheManager = CacheManagerFactory.make((IThreadContext)tc);
    }

    public void connect(ConfigParams configParams) {
        super.connect(configParams);
        this.jdbcProvider = configParams.getParameter(JDBCConstants.providerParameter);
        this.accessMethod = configParams.getParameter(JDBCConstants.methodParameter);
        this.host = configParams.getParameter(JDBCConstants.hostParameter);
        this.databaseName = configParams.getParameter(JDBCConstants.databaseNameParameter);
        this.rawDriverString = configParams.getParameter(JDBCConstants.driverStringParameter);
        this.userName = configParams.getParameter(JDBCConstants.databaseUserName);
        this.password = configParams.getObfuscatedParameter(JDBCConstants.databasePassword);
        this.idQuery = configParams.getParameter(JDBCConstants.databaseUserIdQuery);
        this.tokenQuery = configParams.getParameter(JDBCConstants.databaseTokensQuery);
    }

    public String check() throws ManifoldCFException {
        try {
            this.getSession();
            this.connection.testConnection();
            return super.check();
        }
        catch (ServiceInterruption e) {
            if (Logging.authorityConnectors.isDebugEnabled()) {
                Logging.authorityConnectors.debug((Object)("Service interruption in check(): " + e.getMessage()), (Throwable)e);
            }
            return "Transient error: " + e.getMessage();
        }
    }

    public void disconnect() throws ManifoldCFException {
        this.connection = null;
        this.host = null;
        this.jdbcProvider = null;
        this.accessMethod = null;
        this.databaseName = null;
        this.rawDriverString = null;
        this.userName = null;
        this.password = null;
        super.disconnect();
    }

    protected void getSession() throws ManifoldCFException, ServiceInterruption {
        if (this.connection == null) {
            if (this.jdbcProvider == null || this.jdbcProvider.length() == 0) {
                throw new ManifoldCFException("Missing parameter '" + JDBCConstants.providerParameter + "'");
            }
            if (!(this.host != null && this.host.length() != 0 || this.rawDriverString != null && this.rawDriverString.length() != 0)) {
                throw new ManifoldCFException("Missing parameter '" + JDBCConstants.hostParameter + "' or '" + JDBCConstants.driverStringParameter + "'");
            }
            this.connection = new JDBCConnection(this.jdbcProvider, this.accessMethod == null || this.accessMethod.equals("name"), this.host, this.databaseName, this.rawDriverString, this.userName, this.password);
        }
    }

    private String createCacheConnectionString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.jdbcProvider).append("|").append(this.host == null ? "" : this.host).append("|").append(this.databaseName == null ? "" : this.databaseName).append("|").append(this.rawDriverString == null ? "" : this.rawDriverString).append("|").append(this.userName);
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AuthorizationResponse getAuthorizationResponse(String userName) throws ManifoldCFException {
        JdbcAuthorizationResponseDescription objectDescription = new JdbcAuthorizationResponseDescription(userName, this.createCacheConnectionString(), this.idQuery, this.tokenQuery, this.responseLifetime, this.LRUsize);
        ICacheHandle ch = this.cacheManager.enterCache(new ICacheDescription[]{objectDescription}, null, null);
        try {
            AuthorizationResponse response;
            ICacheCreateHandle createHandle;
            block8: {
                AuthorizationResponse authorizationResponse;
                createHandle = this.cacheManager.enterCreateSection(ch);
                try {
                    response = (AuthorizationResponse)this.cacheManager.lookupObject(createHandle, (ICacheDescription)objectDescription);
                    if (response == null) break block8;
                    authorizationResponse = response;
                }
                catch (Throwable throwable) {
                    this.cacheManager.leaveCreateSection(createHandle);
                    throw throwable;
                }
                this.cacheManager.leaveCreateSection(createHandle);
                return authorizationResponse;
            }
            response = this.getAuthorizationResponseUncached(userName);
            this.cacheManager.saveObject(createHandle, (ICacheDescription)objectDescription, (Object)response);
            AuthorizationResponse authorizationResponse = response;
            this.cacheManager.leaveCreateSection(createHandle);
            return authorizationResponse;
        }
        finally {
            this.cacheManager.leaveCache(ch);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public AuthorizationResponse getAuthorizationResponseUncached(String userName) throws ManifoldCFException {
        block27: {
            this.getSession();
            vm = new VariableMap();
            JDBCAuthority.addConstant(vm, JDBCConstants.idReturnVariable, JDBCConstants.idReturnColumnName);
            JDBCAuthority.addVariable(vm, JDBCConstants.userNameVariable, userName);
            paramList = new ArrayList<E>();
            sb = new StringBuilder();
            JDBCAuthority.substituteQuery(this.idQuery, vm, sb, paramList);
            try {
                idSet = this.connection.executeUncachedQuery(sb.toString(), paramList, -1);
            }
            catch (ServiceInterruption e) {
                return JDBCAuthority.RESPONSE_UNREACHABLE;
            }
            catch (ManifoldCFException e) {
                throw e;
            }
            row = idSet.getNextRow();
            if (row != null) break block27;
            var8_13 = JDBCAuthority.RESPONSE_USERNOTFOUND;
            idSet.close();
            return var8_13;
        }
        try {
            block29: {
                block28: {
                    try {
                        oUid = row.getValue(JDBCConstants.idReturnColumnName);
                        if (oUid == null) {
                            throw new ManifoldCFException("Bad id query; doesn't return $(IDCOLUMN) column.  Try using quotes around $(IDCOLUMN) variable, e.g. \"$(IDCOLUMN)\".");
                        }
                        uid = JDBCConnection.readAsString(oUid);
                        break block28;
                    }
                    finally {
                        row.close();
                    }
                    {
                        catch (Throwable var10_17) {
                            throw var10_17;
                        }
                    }
                    finally {
                        idSet.close();
                    }
                }
                if (uid.isEmpty()) {
                    return JDBCAuthority.RESPONSE_USERNOTFOUND;
                }
                vm = new VariableMap();
                JDBCAuthority.addConstant(vm, JDBCConstants.tokenReturnVariable, JDBCConstants.tokenReturnColumnName);
                JDBCAuthority.addVariable(vm, JDBCConstants.userNameVariable, userName);
                JDBCAuthority.addVariable(vm, JDBCConstants.userIDVariable, uid);
                sb = new StringBuilder();
                paramList = new ArrayList<E>();
                JDBCAuthority.substituteQuery(this.tokenQuery, vm, sb, paramList);
                try {
                    idSet = this.connection.executeUncachedQuery(sb.toString(), paramList, -1);
                }
                catch (ServiceInterruption e) {
                    return JDBCAuthority.RESPONSE_UNREACHABLE;
                }
                catch (ManifoldCFException e) {
                    throw e;
                }
                tokenArray = new ArrayList<String>();
                while (true) lbl-1000:
                // 4 sources

                {
                    if ((row = idSet.getNextRow()) == null) {
                        break block29;
                    }
                    try {
                        oToken = row.getValue(JDBCConstants.tokenReturnColumnName);
                        if (oToken == null) {
                            throw new ManifoldCFException("Bad token query; doesn't return $(TOKENCOLUMN) column.  Try using quotes around $(TOKENCOLUMN) variable, e.g. \"$(TOKENCOLUMN)\".");
                        }
                        token = JDBCConnection.readAsString(oToken);
                        if (token.isEmpty()) ** GOTO lbl-1000
                        tokenArray.add(token);
                    }
                    finally {
                        row.close();
                        continue;
                    }
                    break;
                }
                ** GOTO lbl-1000
                finally {
                    idSet.close();
                }
            }
            return new AuthorizationResponse(tokenArray.toArray(new String[0]), 0);
        }
        catch (ServiceInterruption e) {
            Logging.authorityConnectors.warn((Object)("JDBCAuthority: Service interruption: " + e.getMessage()), (Throwable)e);
            return JDBCAuthority.RESPONSE_UNREACHABLE;
        }
    }

    public void outputConfigurationHeader(IThreadContext threadContext, IHTTPOutput out, Locale locale, ConfigParams parameters, List<String> tabsArray) throws ManifoldCFException, IOException {
        tabsArray.add(Messages.getString(locale, "JDBCAuthority.DatabaseType"));
        tabsArray.add(Messages.getString(locale, "JDBCAuthority.Server"));
        tabsArray.add(Messages.getString(locale, "JDBCAuthority.Credentials"));
        tabsArray.add(Messages.getString(locale, "JDBCAuthority.Queries"));
        out.print("<script type=\"text/javascript\">\n<!--\nfunction checkConfigForSave()\n{\n  if (editconnection.databasehost.value == \"\" && editconnection.rawjdbcstring.value == \"\")\n  {\n    alert(\"" + Messages.getBodyJavascriptString(locale, "JDBCAuthority.PleaseFillInADatabaseServerName") + "\");\n    SelectTab(\"" + Messages.getBodyJavascriptString(locale, "JDBCAuthority.Server") + "\");\n    editconnection.databasehost.focus();\n    return false;\n  }\n  if (editconnection.databasename.value == \"\" && editconnection.rawjdbcstring.value == \"\")\n  {\n    alert(\"" + Messages.getBodyJavascriptString(locale, "JDBCAuthority.PleaseFillInTheNameOfTheDatabase") + "\");\n    SelectTab(\"" + Messages.getBodyJavascriptString(locale, "JDBCAuthority.Server") + "\");\n    editconnection.databasename.focus();\n    return false;\n  }\n  if (editconnection.username.value == \"\")\n  {\n    alert(\"" + Messages.getBodyJavascriptString(locale, "JDBCAuthority.PleaseSupplyTheDatabaseUsernameForThisConnection") + "\");\n    SelectTab(\"" + Messages.getBodyJavascriptString(locale, "JDBCAuthority.Credentials") + "\");\n    editconnection.username.focus();\n    return false;\n  }\n  return true;\n}\n\n//-->\n</script>\n");
    }

    public void outputConfigurationBody(IThreadContext threadContext, IHTTPOutput out, Locale locale, ConfigParams parameters, String tabName) throws ManifoldCFException, IOException {
        String lTokenQuery;
        String databasePassword;
        String databaseUser;
        String rawJDBCString;
        String lDatabaseName;
        String lHost;
        String lAccessMethod;
        String lJdbcProvider = parameters.getParameter(JDBCConstants.providerParameter);
        if (lJdbcProvider == null) {
            lJdbcProvider = "oracle:thin:@";
        }
        if ((lAccessMethod = parameters.getParameter(JDBCConstants.methodParameter)) == null) {
            lAccessMethod = "name";
        }
        if ((lHost = parameters.getParameter(JDBCConstants.hostParameter)) == null) {
            lHost = "localhost";
        }
        if ((lDatabaseName = parameters.getParameter(JDBCConstants.databaseNameParameter)) == null) {
            lDatabaseName = "database";
        }
        if ((rawJDBCString = parameters.getParameter(JDBCConstants.driverStringParameter)) == null) {
            rawJDBCString = "";
        }
        if ((databaseUser = parameters.getParameter(JDBCConstants.databaseUserName)) == null) {
            databaseUser = "";
        }
        databasePassword = (databasePassword = parameters.getObfuscatedParameter(JDBCConstants.databasePassword)) == null ? "" : out.mapPasswordToKey(databasePassword);
        String lIdQuery = parameters.getParameter(JDBCConstants.databaseUserIdQuery);
        if (lIdQuery == null) {
            lIdQuery = "SELECT idfield AS $(IDCOLUMN) FROM usertable WHERE login = $(USERNAME)";
        }
        if ((lTokenQuery = parameters.getParameter(JDBCConstants.databaseTokensQuery)) == null) {
            lTokenQuery = "SELECT groupnamefield AS $(TOKENCOLUMN) FROM grouptable WHERE user_id = $(UID) OR login = $(USERNAME)";
        }
        if (tabName.equals(Messages.getString(locale, "JDBCAuthority.DatabaseType"))) {
            out.print("<table class=\"displaytable\">\n  <tr><td class=\"separator\" colspan=\"2\"><hr/></td></tr>\n  <tr>\n    <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "JDBCAuthority.DatabaseType2") + "</nobr></td><td class=\"value\">\n      <select multiple=\"false\" name=\"databasetype\" size=\"2\">\n        <option value=\"oracle:thin:@\" " + (lJdbcProvider.equals("oracle:thin:@") ? "selected=\"selected\"" : "") + ">Oracle</option>\n        <option value=\"postgresql://\" " + (lJdbcProvider.equals("postgresql:") ? "selected=\"selected\"" : "") + ">Postgres SQL</option>\n        <option value=\"jtds:sqlserver://\" " + (lJdbcProvider.equals("jtds:sqlserver:") ? "selected=\"selected\"" : "") + ">MS SQL Server (&gt; V6.5)</option>\n        <option value=\"jtds:sybase://\" " + (lJdbcProvider.equals("jtds:sybase:") ? "selected=\"selected\"" : "") + ">Sybase (&gt;= V10)</option>\n        <option value=\"mysql://\" " + (lJdbcProvider.equals("mysql:") ? "selected=\"selected\"" : "") + ">MySQL (&gt;= V5)</option>\n        <option value=\"mariadb://\" " + (lJdbcProvider.equals("mariadb:") ? "selected=\"selected\"" : "") + ">MariaDB</option>\n      </select>\n    </td>\n  </tr>\n  <tr><td class=\"separator\" colspan=\"2\"><hr/></td></tr>\n  <tr>\n    <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "JDBCAuthority.AccessMethod") + "</nobr></td><td class=\"value\">\n      <select multiple=\"false\" name=\"accessmethod\" size=\"2\">\n        <option value=\"name\" " + (lAccessMethod.equals("name") ? "selected=\"selected\"" : "") + ">" + Messages.getBodyString(locale, "JDBCAuthority.ByName") + "</option>\n        <option value=\"label\" " + (lAccessMethod.equals("label") ? "selected=\"selected\"" : "") + ">" + Messages.getBodyString(locale, "JDBCAuthority.ByLabel") + "</option>\n      </select>\n    </td>\n  </tr>\n</table>\n");
        } else {
            out.print("<input type=\"hidden\" name=\"databasetype\" value=\"" + lJdbcProvider + "\"/>\n<input type=\"hidden\" name=\"accessmethod\" value=\"" + lAccessMethod + "\"/>\n");
        }
        if (tabName.equals(Messages.getString(locale, "JDBCAuthority.Server"))) {
            out.print("<table class=\"displaytable\">\n  <tr><td class=\"separator\" colspan=\"2\"><hr/></td></tr>\n  <tr>\n    <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "JDBCAuthority.DatabaseHostAndPort") + "</nobr></td><td class=\"value\"><input type=\"text\" size=\"64\" name=\"databasehost\" value=\"" + Encoder.attributeEscape((String)lHost) + "\"/></td>\n  </tr>\n  <tr>\n    <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "JDBCAuthority.DatabaseServiceNameOrInstanceDatabase") + "</nobr></td><td class=\"value\"><input type=\"text\" size=\"32\" name=\"databasename\" value=\"" + Encoder.attributeEscape((String)lDatabaseName) + "\"/></td>\n  </tr>\n  <tr>\n    <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "JDBCAuthority.RawDatabaseConnectString") + "</nobr></td><td class=\"value\"><input type=\"text\" size=\"80\" name=\"rawjdbcstring\" value=\"" + Encoder.attributeEscape((String)rawJDBCString) + "\"/></td>\n  </tr>\n</table>\n");
        } else {
            out.print("<input type=\"hidden\" name=\"databasehost\" value=\"" + Encoder.attributeEscape((String)lHost) + "\"/>\n<input type=\"hidden\" name=\"databasename\" value=\"" + Encoder.attributeEscape((String)lDatabaseName) + "\"/>\n<input type=\"hidden\" name=\"rawjdbcstring\" value=\"" + Encoder.attributeEscape((String)rawJDBCString) + "\"/>\n");
        }
        if (tabName.equals(Messages.getString(locale, "JDBCAuthority.Credentials"))) {
            out.print("<table class=\"displaytable\">\n  <tr><td class=\"separator\" colspan=\"2\"><hr/></td></tr>\n  <tr>\n    <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "JDBCAuthority.UserName") + "</nobr></td><td class=\"value\"><input type=\"text\" size=\"32\" name=\"username\" value=\"" + Encoder.attributeEscape((String)databaseUser) + "\"/></td>\n  </tr>\n  <tr>\n    <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "JDBCAuthority.Password") + "</nobr></td><td class=\"value\"><input type=\"password\" size=\"32\" name=\"password\" value=\"" + Encoder.attributeEscape((String)databasePassword) + "\"/></td>\n  </tr>\n</table>\n");
        } else {
            out.print("<input type=\"hidden\" name=\"username\" value=\"" + Encoder.attributeEscape((String)databaseUser) + "\"/>\n<input type=\"hidden\" name=\"password\" value=\"" + Encoder.attributeEscape((String)databasePassword) + "\"/>\n");
        }
        if (tabName.equals(Messages.getString(locale, "JDBCAuthority.Queries"))) {
            out.print("<table class=\"displaytable\">\n  <tr><td class=\"separator\" colspan=\"2\"><hr/></td></tr>\n  <tr>\n    <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "JDBCAuthority.UserIdQuery") + "</nobr><br/><nobr>" + Messages.getBodyString(locale, "JDBCAuthority.returnUserIdOrEmptyResultset") + "</nobr></td>\n    <td class=\"value\"><textarea name=\"idquery\" cols=\"64\" rows=\"6\">" + Encoder.bodyEscape((String)lIdQuery) + "</textarea></td>\n  </tr>\n  <tr>\n    <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "JDBCAuthority.TokenQuery") + "</nobr><br/><nobr>" + Messages.getBodyString(locale, "JDBCAuthority.returnTokensForUser") + "</nobr></td>\n    <td class=\"value\"><textarea name=\"tokenquery\" cols=\"64\" rows=\"6\">" + Encoder.bodyEscape((String)lTokenQuery) + "</textarea></td>\n  </tr>\n</table>\n");
        } else {
            out.print("<input type=\"hidden\" name=\"idquery\" value=\"" + Encoder.attributeEscape((String)lIdQuery) + "\"/>\n<input type=\"hidden\" name=\"tokenquery\" value=\"" + Encoder.attributeEscape((String)lTokenQuery) + "\"/>\n");
        }
    }

    public String processConfigurationPost(IThreadContext threadContext, IPostParameters variableContext, Locale locale, ConfigParams parameters) throws ManifoldCFException {
        String lTokenQuery;
        String lIdQuery;
        String lPassword;
        String lUserName;
        String rawJDBCString;
        String lDatabaseName;
        String lHost;
        String accessMethod;
        String type = variableContext.getParameter("databasetype");
        if (type != null) {
            parameters.setParameter(JDBCConstants.providerParameter, type);
        }
        if ((accessMethod = variableContext.getParameter("accessmethod")) != null) {
            parameters.setParameter(JDBCConstants.methodParameter, accessMethod);
        }
        if ((lHost = variableContext.getParameter("databasehost")) != null) {
            parameters.setParameter(JDBCConstants.hostParameter, lHost);
        }
        if ((lDatabaseName = variableContext.getParameter("databasename")) != null) {
            parameters.setParameter(JDBCConstants.databaseNameParameter, lDatabaseName);
        }
        if ((rawJDBCString = variableContext.getParameter("rawjdbcstring")) != null) {
            parameters.setParameter(JDBCConstants.driverStringParameter, rawJDBCString);
        }
        if ((lUserName = variableContext.getParameter("username")) != null) {
            parameters.setParameter(JDBCConstants.databaseUserName, lUserName);
        }
        if ((lPassword = variableContext.getParameter("password")) != null) {
            parameters.setObfuscatedParameter(JDBCConstants.databasePassword, variableContext.mapKeyToPassword(lPassword));
        }
        if ((lIdQuery = variableContext.getParameter("idquery")) != null) {
            parameters.setParameter(JDBCConstants.databaseUserIdQuery, lIdQuery);
        }
        if ((lTokenQuery = variableContext.getParameter("tokenquery")) != null) {
            parameters.setParameter(JDBCConstants.databaseTokensQuery, lTokenQuery);
        }
        return null;
    }

    public void viewConfiguration(IThreadContext threadContext, IHTTPOutput out, Locale locale, ConfigParams parameters) throws ManifoldCFException, IOException {
        out.print("<table class=\"displaytable\">\n  <tr>\n    <td class=\"description\" colspan=\"1\"><nobr>" + Messages.getBodyString(locale, "JDBCAuthority.Parameters") + "</nobr></td>\n    <td class=\"value\" colspan=\"3\">\n");
        Iterator iter = parameters.listParameters();
        while (iter.hasNext()) {
            String param = (String)iter.next();
            String value = parameters.getParameter(param);
            if (param.length() >= "password".length() && param.substring(param.length() - "password".length()).equalsIgnoreCase("password")) {
                out.print("      <nobr>" + Encoder.bodyEscape((String)param) + "=********</nobr><br/>\n");
                continue;
            }
            if (param.length() >= "keystore".length() && param.substring(param.length() - "keystore".length()).equalsIgnoreCase("keystore")) {
                IKeystoreManager kmanager = KeystoreManagerFactory.make((String)"", (String)value);
                out.print("      <nobr>" + Encoder.bodyEscape((String)param) + "=&lt;" + Integer.toString(kmanager.getContents().length) + " certificate(s)&gt;</nobr><br/>\n");
                continue;
            }
            out.print("      <nobr>" + Encoder.bodyEscape((String)param) + "=" + Encoder.bodyEscape((String)value) + "</nobr><br/>\n");
        }
        out.print("    </td>\n  </tr>\n</table>\n");
    }

    protected static void substituteQuery(String inputString, VariableMap inputMap, StringBuilder outputQuery, ArrayList outputParams) throws ManifoldCFException {
        int startIndex = 0;
        while (true) {
            int nextIndex;
            if ((nextIndex = inputString.indexOf("$(", startIndex)) == -1) {
                outputQuery.append(inputString.substring(startIndex));
                break;
            }
            int endIndex = inputString.indexOf(")", nextIndex);
            if (endIndex == -1) {
                outputQuery.append(inputString.substring(startIndex));
                break;
            }
            String variableName = inputString.substring(nextIndex + 2, endIndex);
            VariableMapItem item = inputMap.getVariable(variableName);
            if (item == null) {
                throw new ManifoldCFException("No such substitution variable: $(" + variableName + ")");
            }
            outputQuery.append(inputString.substring(startIndex, nextIndex));
            outputQuery.append(item.getValue());
            ArrayList inputParams = item.getParameters();
            if (inputParams != null) {
                int i = 0;
                while (i < inputParams.size()) {
                    Object x = inputParams.get(i++);
                    outputParams.add(x);
                }
            }
            startIndex = endIndex + 1;
        }
    }

    protected static void addVariable(VariableMap map, String varName, String variable) {
        ArrayList<String> params = new ArrayList<String>();
        params.add(variable);
        map.addVariable(varName, "?", params);
    }

    protected static void addConstant(VariableMap map, String varName, String value) {
        map.addVariable(varName, value, null);
    }

    protected static void loadPS(PreparedStatement ps, ArrayList data) throws SQLException, ManifoldCFException {
        if (data != null) {
            for (int i = 0; i < data.size(); ++i) {
                String value;
                Object x = data.get(i);
                if (x instanceof String) {
                    value = (String)x;
                    ps.setString(i + 1, value);
                }
                if (x instanceof BinaryInput) {
                    value = (BinaryInput)x;
                    ps.setAsciiStream(i + 1, value.getStream(), (int)value.getLength());
                }
                if (x instanceof java.util.Date) {
                    ps.setDate(i + 1, new Date(((java.util.Date)x).getTime()));
                }
                if (x instanceof Long) {
                    ps.setLong(i + 1, (Long)x);
                }
                if (x instanceof TimeMarker) {
                    ps.setTimestamp(i + 1, new Timestamp((Long)x));
                }
                if (x instanceof Double) {
                    ps.setDouble(i + 1, (Double)x);
                }
                if (x instanceof Integer) {
                    ps.setInt(i + 1, (Integer)x);
                }
                if (!(x instanceof Float)) continue;
                ps.setFloat(i + 1, ((Float)x).floatValue());
            }
        }
    }

    protected class JdbcAuthorizationResponseDescription
    extends BaseDescription {
        protected final String userName;
        protected final String connectionString;
        protected final String userQuery;
        protected final String tokenQuery;
        protected final long responseLifetime;
        protected long expirationTime;

        public JdbcAuthorizationResponseDescription(String userName, String connectionString, String userQuery, String tokenQuery, long responseLifetime, int LRUsize) {
            super("JDBCAuthority", LRUsize);
            this.expirationTime = -1L;
            this.userName = userName;
            this.connectionString = connectionString;
            this.userQuery = userQuery;
            this.tokenQuery = tokenQuery;
            this.responseLifetime = responseLifetime;
        }

        public StringSet getObjectKeys() {
            return emptyStringSet;
        }

        public String getCriticalSectionName() {
            StringBuilder sb = new StringBuilder(((Object)((Object)this)).getClass().getName());
            sb.append("-").append(this.userName).append("-").append(this.connectionString).append("-").append(this.userQuery).append("-").append(this.tokenQuery);
            return sb.toString();
        }

        public long getObjectExpirationTime(long currentTime) {
            if (this.expirationTime == -1L) {
                this.expirationTime = currentTime + this.responseLifetime;
            }
            return this.expirationTime;
        }

        public int hashCode() {
            return this.userName.hashCode() + this.connectionString.hashCode() + this.userQuery.hashCode() + this.tokenQuery.hashCode();
        }

        public boolean equals(Object o) {
            if (!(o instanceof JdbcAuthorizationResponseDescription)) {
                return false;
            }
            JdbcAuthorizationResponseDescription ard = (JdbcAuthorizationResponseDescription)((Object)o);
            if (!ard.userName.equals(this.userName)) {
                return false;
            }
            if (!ard.connectionString.equals(this.connectionString)) {
                return false;
            }
            if (!ard.userQuery.equals(this.userQuery)) {
                return false;
            }
            return ard.tokenQuery.equals(this.tokenQuery);
        }
    }

    protected static class VariableMap {
        protected Map variableMap = new HashMap();

        public void addVariable(String variableName, String value, ArrayList parameters) {
            VariableMapItem e = new VariableMapItem(value, parameters);
            this.variableMap.put(variableName, e);
        }

        public VariableMapItem getVariable(String variableName) {
            return (VariableMapItem)this.variableMap.get(variableName);
        }
    }

    protected static class VariableMapItem {
        protected String value;
        protected ArrayList params;

        public VariableMapItem(String value, ArrayList params) {
            this.value = value;
            this.params = params;
        }

        public String getValue() {
            return this.value;
        }

        public ArrayList getParameters() {
            return this.params;
        }
    }
}

