/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.index.tree;

import org.apache.sis.index.tree.PointTreeNode;

final class QuadTreeNode
extends PointTreeNode {
    private static final long serialVersionUID = 3860185925702742700L;
    static final int NE = 0;
    static final int NW = 1;
    static final int SE = 2;
    static final int SW = 3;
    private Object nw;
    private Object ne;
    private Object se;
    private Object sw;

    QuadTreeNode() {
    }

    @Override
    final PointTreeNode newInstance() {
        return new QuadTreeNode();
    }

    @Override
    final void clear() {
        this.sw = null;
        this.se = null;
        this.ne = null;
        this.nw = null;
    }

    @Override
    final Object getChild(int n) {
        Object object;
        switch (n) {
            case 1: {
                object = this.nw;
                break;
            }
            case 0: {
                object = this.ne;
                break;
            }
            case 3: {
                object = this.sw;
                break;
            }
            case 2: {
                object = this.se;
                break;
            }
            default: {
                throw new IndexOutOfBoundsException();
            }
        }
        return object;
    }

    @Override
    final void setChild(int n, Object object) {
        switch (n) {
            case 1: {
                this.nw = object;
                break;
            }
            case 0: {
                this.ne = object;
                break;
            }
            case 3: {
                this.sw = object;
                break;
            }
            case 2: {
                this.se = object;
                break;
            }
            default: {
                throw new IndexOutOfBoundsException();
            }
        }
    }

    @Override
    protected Object clone() {
        QuadTreeNode quadTreeNode = (QuadTreeNode)super.clone();
        for (int i = 0; i < 4; ++i) {
            Object object = quadTreeNode.getChild(i);
            if (!(object instanceof PointTreeNode)) continue;
            quadTreeNode.setChild(i, ((PointTreeNode)object).clone());
        }
        return quadTreeNode;
    }
}

