/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.cs;

import java.util.Map;
import javax.measure.Unit;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.sis.internal.referencing.AxisDirections;
import org.apache.sis.measure.Units;
import org.apache.sis.referencing.cs.AbstractCS;
import org.apache.sis.referencing.cs.AxesConvention;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.cs.VerticalCS;

@XmlType(name="VerticalCSType")
@XmlRootElement(name="VerticalCS")
public class DefaultVerticalCS
extends AbstractCS
implements VerticalCS {
    private static final long serialVersionUID = 1201155778896630499L;

    DefaultVerticalCS(Map<String, ?> map, CoordinateSystemAxis[] coordinateSystemAxisArray) {
        super(map, coordinateSystemAxisArray);
    }

    public DefaultVerticalCS(Map<String, ?> map, CoordinateSystemAxis coordinateSystemAxis) {
        super(map, coordinateSystemAxis);
    }

    protected DefaultVerticalCS(VerticalCS verticalCS) {
        super((CoordinateSystem)verticalCS);
    }

    public static DefaultVerticalCS castOrCopy(VerticalCS verticalCS) {
        return verticalCS == null || verticalCS instanceof DefaultVerticalCS ? (DefaultVerticalCS)verticalCS : new DefaultVerticalCS(verticalCS);
    }

    @Override
    final int validateAxis(AxisDirection axisDirection, Unit<?> unit) {
        if (!AxisDirection.UP.equals((Object)AxisDirections.absolute(axisDirection))) {
            return 1;
        }
        if ((unit = unit.getSystemUnit()).equals(Units.METRE) || unit.equals(Units.PASCAL) || unit.equals(Units.SECOND) || unit.equals(Units.UNITY)) {
            return 0;
        }
        return 2;
    }

    public Class<? extends VerticalCS> getInterface() {
        return VerticalCS.class;
    }

    @Override
    public DefaultVerticalCS forConvention(AxesConvention axesConvention) {
        return (DefaultVerticalCS)super.forConvention(axesConvention);
    }

    @Override
    final AbstractCS createForAxes(Map<String, ?> map, CoordinateSystemAxis[] coordinateSystemAxisArray) {
        switch (coordinateSystemAxisArray.length) {
            case 1: {
                return new DefaultVerticalCS(map, coordinateSystemAxisArray);
            }
        }
        throw DefaultVerticalCS.unexpectedDimension(map, coordinateSystemAxisArray, 1);
    }

    private DefaultVerticalCS() {
    }
}

