/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.agents.output.kafka;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.manifoldcf.agents.interfaces.IOutputAddActivity;
import org.apache.manifoldcf.agents.interfaces.IOutputNotifyActivity;
import org.apache.manifoldcf.agents.interfaces.RepositoryDocument;
import org.apache.manifoldcf.agents.interfaces.ServiceInterruption;
import org.apache.manifoldcf.agents.output.BaseOutputConnector;
import org.apache.manifoldcf.agents.output.kafka.KafkaMessage;
import org.apache.manifoldcf.agents.output.kafka.Messages;
import org.apache.manifoldcf.core.interfaces.ConfigParams;
import org.apache.manifoldcf.core.interfaces.IHTTPOutput;
import org.apache.manifoldcf.core.interfaces.IPasswordMapperActivity;
import org.apache.manifoldcf.core.interfaces.IPostParameters;
import org.apache.manifoldcf.core.interfaces.IThreadContext;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;
import org.apache.manifoldcf.core.interfaces.Specification;
import org.apache.manifoldcf.core.interfaces.VersionContext;

public class KafkaOutputConnector
extends BaseOutputConnector {
    public static final String _rcsid = "@(#)$Id: KafkaOutputConnector.java 988245 2010-08-23 18:39:35Z kwright $";
    public static final String INGEST_ACTIVITY = "document ingest";
    public static final String JOB_COMPLETE_ACTIVITY = "output notification";
    private static final String KAFKA_TAB_PARAMETERS = "KafkaConnector.Parameters";
    private static final String EDIT_CONFIG_HEADER_FORWARD = "editConfiguration.js";
    private static final String EDIT_CONFIG_FORWARD_PARAMETERS = "editConfiguration_Parameters.html";
    private static final String VIEW_CONFIG_FORWARD = "viewConfiguration.html";
    private static final String FILE_BODY_TEXT_FIELDNAME = "f_bodytext";
    private static final String DOCUMENT_URI_FIELDNAME = "document_URI";
    protected static final String allowAttributeName = "allow_token_";
    protected static final String denyAttributeName = "deny_token_";
    protected static final String noSecurityToken = "__nosecurity__";
    protected static final boolean useNullValue = false;
    KafkaProducer producer = null;

    public void setProducer(KafkaProducer producer) {
        this.producer = producer;
    }

    public String[] getActivitiesList() {
        return new String[]{INGEST_ACTIVITY, JOB_COMPLETE_ACTIVITY};
    }

    public void connect(ConfigParams configParameters) {
        super.connect(configParameters);
        Properties props = new Properties();
        String IP = this.params.getParameter("ip");
        String PORT = this.params.getParameter("port");
        props.put("bootstrap.servers", IP + ":" + PORT);
        props.put("retries", "3");
        props.put("acks", "all");
        props.put("compression.type", "none");
        props.put("batch.size", (Object)200);
        props.put("block.on.buffer.full", (Object)true);
        props.put("key.serializer", "org.apache.kafka.common.serialization.StringSerializer");
        props.put("value.serializer", "org.apache.kafka.common.serialization.ByteArraySerializer");
        this.producer = new KafkaProducer(props);
    }

    public void disconnect() throws ManifoldCFException {
        super.disconnect();
    }

    private static void fillInServerConfigurationMap(Map<String, Object> newMap, IPasswordMapperActivity mapper, ConfigParams parameters) {
        String IP = parameters.getParameter("ip");
        String port = parameters.getParameter("port");
        String topic = parameters.getParameter("topic");
        if (IP == null) {
            IP = "localhost";
        }
        if (port == null) {
            port = "9092";
        }
        if (topic == null) {
            topic = "topic";
        }
        newMap.put("IP", IP);
        newMap.put("PORT", port);
        newMap.put("TOPIC", topic);
    }

    public void outputConfigurationHeader(IThreadContext threadContext, IHTTPOutput out, Locale locale, ConfigParams parameters, List<String> tabsArray) throws ManifoldCFException, IOException {
        tabsArray.add(Messages.getString(locale, KAFKA_TAB_PARAMETERS));
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        KafkaOutputConnector.fillInServerConfigurationMap(paramMap, (IPasswordMapperActivity)out, parameters);
        Messages.outputResourceWithVelocity(out, locale, EDIT_CONFIG_HEADER_FORWARD, paramMap);
    }

    public void outputConfigurationBody(IThreadContext threadContext, IHTTPOutput out, Locale locale, ConfigParams parameters, String tabName) throws ManifoldCFException, IOException {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("TABNAME", tabName);
        KafkaOutputConnector.fillInServerConfigurationMap(paramMap, (IPasswordMapperActivity)out, parameters);
        Messages.outputResourceWithVelocity(out, locale, EDIT_CONFIG_FORWARD_PARAMETERS, paramMap);
    }

    public void viewConfiguration(IThreadContext threadContext, IHTTPOutput out, Locale locale, ConfigParams parameters) throws ManifoldCFException, IOException {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        KafkaOutputConnector.fillInServerConfigurationMap(paramMap, (IPasswordMapperActivity)out, parameters);
        Messages.outputResourceWithVelocity(out, locale, VIEW_CONFIG_FORWARD, paramMap);
    }

    public String processConfigurationPost(IThreadContext threadContext, IPostParameters variableContext, ConfigParams parameters) throws ManifoldCFException {
        String topic;
        String port;
        String IP = variableContext.getParameter("ip");
        if (IP != null) {
            parameters.setParameter("ip", IP);
        }
        if ((port = variableContext.getParameter("port")) != null) {
            parameters.setParameter("port", port);
        }
        if ((topic = variableContext.getParameter("topic")) != null) {
            parameters.setParameter("topic", topic);
        }
        return null;
    }

    public String check() throws ManifoldCFException {
        try {
            List partitions = this.producer.partitionsFor(this.params.getParameter("topic"));
            return super.check();
        }
        catch (ManifoldCFException e) {
            return "Connection failed: " + e.getMessage();
        }
    }

    public VersionContext getPipelineDescription(Specification spec) throws ManifoldCFException, ServiceInterruption {
        return new VersionContext("", this.params, spec);
    }

    public int addOrReplaceDocumentWithException(String documentURI, VersionContext pipelineDescription, RepositoryDocument document, String authorityNameString, IOutputAddActivity activities) throws ManifoldCFException, ServiceInterruption, IOException {
        try {
            KafkaMessage kafkaMessage = new KafkaMessage();
            byte[] finalString = kafkaMessage.createJSON(document);
            String topic = KafkaOutputConnector.getConfig(this.params, "topic", "topic");
            ProducerRecord record = new ProducerRecord(topic, (Object)finalString);
            this.producer.send(record).get();
        }
        catch (InterruptedException e) {
            new ManifoldCFException("interrupted", 2);
        }
        catch (ExecutionException e) {
            new ManifoldCFException("interrupted", 2);
        }
        activities.recordActivity(null, INGEST_ACTIVITY, new Long(document.getBinaryLength()), documentURI, "OK", null);
        return 0;
    }

    private static String getConfig(ConfigParams config, String parameter, String defaultValue) {
        if (config == null) {
            return defaultValue;
        }
        String protocol = config.getParameter(parameter);
        if (protocol == null) {
            return defaultValue;
        }
        return protocol;
    }

    public void noteJobComplete(IOutputNotifyActivity activities) throws ManifoldCFException, ServiceInterruption {
        activities.recordActivity(null, JOB_COMPLETE_ACTIVITY, null, "", "OK", null);
    }
}

