/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.core.tests;

import java.lang.reflect.Method;
import org.apache.manifoldcf.core.tests.BaseHSQLDB;
import org.junit.After;
import org.junit.Before;

public class BaseHSQLDBext
extends BaseHSQLDB {
    protected DatabaseThread databaseThread = null;

    @Override
    protected void writeDatabaseControlProperties(StringBuilder output) throws Exception {
        output.append("  <property name=\"org.apache.manifoldcf.hsqldbdatabaseprotocol\" value=\"hsql\"/>\n  <property name=\"org.apache.manifoldcf.hsqldbdatabaseserver\" value=\"localhost\"/>\n  <property name=\"org.apache.manifoldcf.hsqldbdatabaseinstance\" value=\"xdb\"/>\n");
    }

    @Override
    protected String getDatabaseSuperuserName() throws Exception {
        return "sa";
    }

    @Override
    protected String getDatabaseSuperuserPassword() throws Exception {
        return "";
    }

    @Before
    public void startHSQLDBInstance() throws Exception {
        this.startDatabase();
    }

    @After
    public void stopHSQLDBInstance() throws Exception {
        this.stopDatabase();
    }

    protected void startDatabase() throws Exception {
        this.databaseThread = new DatabaseThread();
        this.databaseThread.start();
    }

    protected void stopDatabase() throws Exception {
        while (this.databaseThread.isAlive()) {
            this.databaseThread.interrupt();
            Thread.yield();
        }
        this.databaseThread.join();
    }

    protected static class DatabaseThread
    extends Thread {
        public DatabaseThread() {
            this.setName("Database runner thread");
        }

        @Override
        public void run() {
            try {
                Class<?> x = Class.forName("org.hsqldb.Server");
                String[] args = new String[]{"-database.0", "file:extdb;hsqldb.tx=mvcc;hsqldb.cache_file_scale=512", "-dbname.0", "xdb"};
                Method m = x.getMethod("main", String[].class);
                m.invoke(null, new Object[]{args});
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

