/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.core.lockmanager;

import java.io.File;
import org.apache.manifoldcf.core.lockmanager.ZooKeeperInstance;
import org.junit.After;
import org.junit.Before;

public class ZooKeeperBase {
    protected File tempDir;
    protected ZooKeeperInstance instance;

    @Before
    public void startZooKeeper() throws Exception {
        this.tempDir = new File("zookeeper");
        this.tempDir.mkdir();
        this.instance = new ZooKeeperInstance(8348, this.tempDir);
        this.instance.start();
    }

    @After
    public void stopZookeeper() throws Exception {
        this.instance.stop();
        ZooKeeperBase.deleteRecursively(this.tempDir);
    }

    protected static void deleteRecursively(File tempDir) throws Exception {
        if (tempDir.isDirectory()) {
            File[] files;
            for (File f : files = tempDir.listFiles()) {
                ZooKeeperBase.deleteRecursively(f);
            }
        }
        tempDir.delete();
    }
}

