/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.lucene.search.function;

import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.search.Explanation;
import org.elasticsearch.common.lucene.search.function.CombineFunction;
import org.elasticsearch.common.lucene.search.function.ScoreFunction;

public class BoostScoreFunction
extends ScoreFunction {
    private final float boost;

    public BoostScoreFunction(float boost) {
        super(CombineFunction.MULT);
        this.boost = boost;
    }

    public float getBoost() {
        return this.boost;
    }

    @Override
    public void setNextReader(AtomicReaderContext context) {
    }

    @Override
    public double score(int docId, float subQueryScore) {
        return this.boost;
    }

    @Override
    public Explanation explainScore(int docId, Explanation subQueryExpl) {
        Explanation exp = new Explanation(this.boost, "static boost factor");
        exp.addDetail(new Explanation(this.boost, "boostFactor"));
        return exp;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BoostScoreFunction that = (BoostScoreFunction)o;
        return Float.compare(that.boost, this.boost) == 0;
    }

    public int hashCode() {
        return this.boost != 0.0f ? Float.floatToIntBits(this.boost) : 0;
    }

    public String toString() {
        return "boost[" + this.boost + "]";
    }
}

