/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.settings;

import java.util.Map;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.cluster.settings.ClusterUpdateSettingsRequest;
import org.elasticsearch.action.admin.cluster.settings.ClusterUpdateSettingsResponse;
import org.elasticsearch.action.support.master.TransportMasterNodeOperationAction;
import org.elasticsearch.cluster.AckedClusterStateUpdateTask;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlocks;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.routing.allocation.AllocationService;
import org.elasticsearch.cluster.routing.allocation.RoutingAllocation;
import org.elasticsearch.cluster.settings.ClusterDynamicSettings;
import org.elasticsearch.cluster.settings.DynamicSettings;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Priority;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.ImmutableSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportClusterUpdateSettingsAction
extends TransportMasterNodeOperationAction<ClusterUpdateSettingsRequest, ClusterUpdateSettingsResponse> {
    private final AllocationService allocationService;
    private final DynamicSettings dynamicSettings;

    @Inject
    public TransportClusterUpdateSettingsAction(Settings settings, TransportService transportService, ClusterService clusterService, ThreadPool threadPool, AllocationService allocationService, @ClusterDynamicSettings DynamicSettings dynamicSettings) {
        super(settings, transportService, clusterService, threadPool);
        this.allocationService = allocationService;
        this.dynamicSettings = dynamicSettings;
    }

    @Override
    protected String executor() {
        return "same";
    }

    @Override
    protected String transportAction() {
        return "cluster/settings/update";
    }

    @Override
    protected ClusterUpdateSettingsRequest newRequest() {
        return new ClusterUpdateSettingsRequest();
    }

    @Override
    protected ClusterUpdateSettingsResponse newResponse() {
        return new ClusterUpdateSettingsResponse();
    }

    @Override
    protected void masterOperation(final ClusterUpdateSettingsRequest request, ClusterState state, final ActionListener<ClusterUpdateSettingsResponse> listener) throws ElasticsearchException {
        final ImmutableSettings.Builder transientUpdates = ImmutableSettings.settingsBuilder();
        final ImmutableSettings.Builder persistentUpdates = ImmutableSettings.settingsBuilder();
        this.clusterService.submitStateUpdateTask("cluster_update_settings", Priority.URGENT, new AckedClusterStateUpdateTask(){
            private volatile boolean changed = false;

            @Override
            public boolean mustAck(DiscoveryNode discoveryNode) {
                return true;
            }

            @Override
            public void onAllNodesAcked(@Nullable Throwable t) {
                if (this.changed) {
                    this.reroute(true);
                } else {
                    listener.onResponse(new ClusterUpdateSettingsResponse(true, transientUpdates.build(), persistentUpdates.build()));
                }
            }

            @Override
            public void onAckTimeout() {
                if (this.changed) {
                    this.reroute(false);
                } else {
                    listener.onResponse(new ClusterUpdateSettingsResponse(false, transientUpdates.build(), persistentUpdates.build()));
                }
            }

            private void reroute(final boolean updateSettingsAcked) {
                TransportClusterUpdateSettingsAction.this.clusterService.submitStateUpdateTask("reroute_after_cluster_update_settings", Priority.URGENT, new AckedClusterStateUpdateTask(){

                    @Override
                    public boolean mustAck(DiscoveryNode discoveryNode) {
                        return updateSettingsAcked;
                    }

                    @Override
                    public void onAllNodesAcked(@Nullable Throwable t) {
                        listener.onResponse(new ClusterUpdateSettingsResponse(updateSettingsAcked, transientUpdates.build(), persistentUpdates.build()));
                    }

                    @Override
                    public void onAckTimeout() {
                        listener.onResponse(new ClusterUpdateSettingsResponse(false, transientUpdates.build(), persistentUpdates.build()));
                    }

                    @Override
                    public TimeValue ackTimeout() {
                        return request.timeout();
                    }

                    @Override
                    public TimeValue timeout() {
                        return request.masterNodeTimeout();
                    }

                    @Override
                    public void onFailure(String source, Throwable t) {
                        TransportClusterUpdateSettingsAction.this.logger.debug("failed to perform [{}]", t, source);
                    }

                    @Override
                    public ClusterState execute(ClusterState currentState) {
                        RoutingAllocation.Result routingResult = TransportClusterUpdateSettingsAction.this.allocationService.reroute(currentState);
                        if (!routingResult.changed()) {
                            return currentState;
                        }
                        return ClusterState.builder(currentState).routingResult(routingResult).build();
                    }

                    @Override
                    public void clusterStateProcessed(String source, ClusterState oldState, ClusterState newState) {
                    }
                });
            }

            @Override
            public TimeValue ackTimeout() {
                return request.timeout();
            }

            @Override
            public TimeValue timeout() {
                return request.masterNodeTimeout();
            }

            @Override
            public void onFailure(String source, Throwable t) {
                TransportClusterUpdateSettingsAction.this.logger.debug("failed to perform [{}]", t, source);
                listener.onFailure(t);
            }

            @Override
            public ClusterState execute(ClusterState currentState) {
                boolean updatedReadOnly;
                ImmutableSettings.Builder transientSettings = ImmutableSettings.settingsBuilder();
                transientSettings.put(currentState.metaData().transientSettings());
                for (Map.Entry entry : request.transientSettings().getAsMap().entrySet()) {
                    if (TransportClusterUpdateSettingsAction.this.dynamicSettings.hasDynamicSetting((String)entry.getKey()) || ((String)entry.getKey()).startsWith("logger.")) {
                        String error = TransportClusterUpdateSettingsAction.this.dynamicSettings.validateDynamicSetting((String)entry.getKey(), (String)entry.getValue());
                        if (error == null) {
                            transientSettings.put((String)entry.getKey(), (String)entry.getValue());
                            transientUpdates.put((String)entry.getKey(), (String)entry.getValue());
                            this.changed = true;
                            continue;
                        }
                        TransportClusterUpdateSettingsAction.this.logger.warn("ignoring transient setting [{}], [{}]", entry.getKey(), error);
                        continue;
                    }
                    TransportClusterUpdateSettingsAction.this.logger.warn("ignoring transient setting [{}], not dynamically updateable", entry.getKey());
                }
                ImmutableSettings.Builder persistentSettings = ImmutableSettings.settingsBuilder();
                persistentSettings.put(currentState.metaData().persistentSettings());
                for (Map.Entry entry : request.persistentSettings().getAsMap().entrySet()) {
                    if (TransportClusterUpdateSettingsAction.this.dynamicSettings.hasDynamicSetting((String)entry.getKey()) || ((String)entry.getKey()).startsWith("logger.")) {
                        String error = TransportClusterUpdateSettingsAction.this.dynamicSettings.validateDynamicSetting((String)entry.getKey(), (String)entry.getValue());
                        if (error == null) {
                            persistentSettings.put((String)entry.getKey(), (String)entry.getValue());
                            persistentUpdates.put((String)entry.getKey(), (String)entry.getValue());
                            this.changed = true;
                            continue;
                        }
                        TransportClusterUpdateSettingsAction.this.logger.warn("ignoring persistent setting [{}], [{}]", entry.getKey(), error);
                        continue;
                    }
                    TransportClusterUpdateSettingsAction.this.logger.warn("ignoring persistent setting [{}], not dynamically updateable", entry.getKey());
                }
                if (!this.changed) {
                    return currentState;
                }
                MetaData.Builder metaData = MetaData.builder(currentState.metaData()).persistentSettings(persistentSettings.build()).transientSettings(transientSettings.build());
                ClusterBlocks.Builder blocks = ClusterBlocks.builder().blocks(currentState.blocks());
                boolean bl = updatedReadOnly = metaData.persistentSettings().getAsBoolean("cluster.blocks.read_only", (Boolean)false) != false || metaData.transientSettings().getAsBoolean("cluster.blocks.read_only", (Boolean)false) != false;
                if (updatedReadOnly) {
                    blocks.addGlobalBlock(MetaData.CLUSTER_READ_ONLY_BLOCK);
                } else {
                    blocks.removeGlobalBlock(MetaData.CLUSTER_READ_ONLY_BLOCK);
                }
                return ClusterState.builder(currentState).metaData(metaData).blocks(blocks).build();
            }

            @Override
            public void clusterStateProcessed(String source, ClusterState oldState, ClusterState newState) {
            }
        });
    }
}

