/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.client.bindings.spi.http;

import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import org.apache.chemistry.opencmis.commons.exceptions.CmisConnectionException;
import org.apache.chemistry.opencmis.commons.impl.Base64;
import org.apache.chemistry.opencmis.commons.impl.IOUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Response {
    private static final int MAX_ERROR_LENGTH = 131072;
    private final int responseCode;
    private final String responseMessage;
    private final Map<String, List<String>> headers;
    private InputStream stream;
    private String errorContent;
    private BigInteger length;
    private String charset;
    private boolean hasResponseStream;

    public Response(int responseCode, String responseMessage, Map<String, List<String>> headers, InputStream responseStream, InputStream errorStream) {
        this.responseCode = responseCode;
        this.responseMessage = responseMessage;
        this.stream = responseStream;
        this.hasResponseStream = this.stream != null;
        boolean isGZIP = responseStream instanceof GZIPInputStream;
        this.headers = new HashMap<String, List<String>>();
        if (headers != null) {
            for (Map.Entry<String, List<String>> e : headers.entrySet()) {
                this.headers.put(e.getKey() == null ? null : e.getKey().toLowerCase(), e.getValue());
            }
        }
        this.charset = "UTF-8";
        String contentType = this.getContentTypeHeader();
        if (contentType != null) {
            String[] parts = contentType.split(";");
            for (int i = 1; i < parts.length; ++i) {
                String part = parts[i].trim().toLowerCase();
                if (!part.startsWith("charset")) continue;
                int x = part.indexOf(61);
                this.charset = part.substring(x + 1).trim();
                break;
            }
        }
        if (errorStream != null) {
            if (contentType != null) {
                String contentTypeLower = contentType.toLowerCase().split(";")[0];
                if (contentTypeLower.startsWith("text/") || contentTypeLower.endsWith("+xml") || contentTypeLower.startsWith("application/xml") || contentTypeLower.startsWith("application/json")) {
                    errorStream = new BufferedInputStream(errorStream, 65536);
                    StringBuilder sb = new StringBuilder();
                    try {
                        int b;
                        String encoding = this.getContentEncoding();
                        if (encoding != null) {
                            if (encoding.toLowerCase().trim().equals("gzip") && !isGZIP) {
                                errorStream = new GZIPInputStream(errorStream, 4096);
                            } else if (encoding.toLowerCase().trim().equals("deflate")) {
                                errorStream = new InflaterInputStream(errorStream, new Inflater(true), 4096);
                            }
                        }
                        InputStreamReader reader = new InputStreamReader(errorStream, this.charset);
                        char[] buffer = new char[4096];
                        while ((b = reader.read(buffer)) > -1) {
                            sb.append(buffer, 0, b);
                            if (sb.length() < 131072) continue;
                        }
                        reader.close();
                        this.errorContent = sb.toString();
                    }
                    catch (IOException e) {
                        this.errorContent = "Unable to retrieve content: " + e.getMessage();
                    }
                }
            } else {
                IOUtils.closeQuietly((Closeable)errorStream);
            }
            IOUtils.closeQuietly((Closeable)responseStream);
            return;
        }
        this.length = null;
        String lengthStr = this.getHeader("Content-Length");
        if (lengthStr != null && !isGZIP) {
            try {
                this.length = new BigInteger(lengthStr);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        if (this.stream == null || BigInteger.ZERO.equals(this.length) || responseCode == 204) {
            this.hasResponseStream = false;
        } else {
            this.stream = new BufferedInputStream(this.stream, 65536);
            try {
                this.hasResponseStream = IOUtils.checkForBytes((InputStream)this.stream);
            }
            catch (IOException ioe) {
                throw new CmisConnectionException("IO exception!", (Throwable)ioe);
            }
            if (this.hasResponseStream) {
                String transferEncoding;
                String encoding = this.getContentEncoding();
                if (encoding != null) {
                    if (encoding.toLowerCase().trim().equals("gzip") && !isGZIP) {
                        this.length = null;
                        try {
                            this.stream = new GZIPInputStream(this.stream, 4096);
                        }
                        catch (IOException e) {
                            this.errorContent = e.getMessage();
                            this.stream = null;
                            IOUtils.closeQuietly((Closeable)responseStream);
                        }
                    } else if (encoding.toLowerCase().trim().equals("deflate")) {
                        this.length = null;
                        this.stream = new InflaterInputStream(this.stream, new Inflater(true), 4096);
                    }
                }
                if ((transferEncoding = this.getContentTransferEncoding()) != null && transferEncoding.toLowerCase().trim().equals("base64")) {
                    this.length = null;
                    this.stream = new Base64.InputStream(this.stream);
                }
            }
        }
    }

    public int getResponseCode() {
        return this.responseCode;
    }

    public String getResponseMessage() {
        return this.responseMessage;
    }

    public Map<String, List<String>> getHeaders() {
        return this.headers;
    }

    public String getHeader(String name) {
        List<String> list = this.headers.get(name.toLowerCase(Locale.US));
        if (list == null || list.isEmpty()) {
            return null;
        }
        return list.get(0);
    }

    public String getContentTypeHeader() {
        return this.getHeader("Content-Type");
    }

    public BigInteger getContentLengthHeader() {
        String lengthStr = this.getHeader("Content-Length");
        if (lengthStr == null) {
            return null;
        }
        try {
            return new BigInteger(lengthStr);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public String getLocactionHeader() {
        return this.getHeader("Location");
    }

    public String getContentLocactionHeader() {
        return this.getHeader("Content-Location");
    }

    public String getContentTransferEncoding() {
        return this.getHeader("Content-Transfer-Encoding");
    }

    public String getContentEncoding() {
        return this.getHeader("Content-Encoding");
    }

    public String getContentDisposition() {
        return this.getHeader("Content-Disposition");
    }

    public String getCharset() {
        return this.charset;
    }

    public BigInteger getContentLength() {
        return this.length;
    }

    public boolean hasResponseStream() {
        return this.hasResponseStream;
    }

    public InputStream getStream() {
        return this.stream;
    }

    public String getErrorContent() {
        return this.errorContent;
    }
}

