/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.apache.solr.client.solrj.io.PushBackStream;
import org.apache.solr.client.solrj.io.StreamContext;
import org.apache.solr.client.solrj.io.Tuple;
import org.apache.solr.client.solrj.io.TupleStream;

public class MergeStream
extends TupleStream {
    private static final long serialVersionUID = 1L;
    private PushBackStream streamA;
    private PushBackStream streamB;
    private Comparator<Tuple> comp;

    public MergeStream(TupleStream streamA, TupleStream streamB, Comparator<Tuple> comp) {
        this.streamA = new PushBackStream(streamA);
        this.streamB = new PushBackStream(streamB);
        this.comp = comp;
    }

    @Override
    public void setStreamContext(StreamContext context) {
        this.streamA.setStreamContext(context);
        this.streamB.setStreamContext(context);
    }

    @Override
    public List<TupleStream> children() {
        ArrayList<TupleStream> l = new ArrayList<TupleStream>();
        l.add(this.streamA);
        l.add(this.streamB);
        return l;
    }

    @Override
    public void open() throws IOException {
        this.streamA.open();
        this.streamB.open();
    }

    @Override
    public void close() throws IOException {
        this.streamA.close();
        this.streamB.close();
    }

    @Override
    public Tuple read() throws IOException {
        Tuple a = this.streamA.read();
        Tuple b = this.streamB.read();
        if (a.EOF && b.EOF) {
            return a;
        }
        if (a.EOF) {
            this.streamA.pushBack(a);
            return b;
        }
        if (b.EOF) {
            this.streamB.pushBack(b);
            return a;
        }
        int c = this.comp.compare(a, b);
        if (c < 0) {
            this.streamB.pushBack(b);
            return a;
        }
        this.streamA.pushBack(a);
        return b;
    }

    @Override
    public int getCost() {
        return 0;
    }
}

