/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.util.featuregen;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import opennlp.tools.util.featuregen.BrownCluster;

public class BrownTokenClasses {
    public static final int[] pathLengths = new int[]{4, 6, 10, 20};

    public static List<String> getWordClasses(String token, BrownCluster brownLexicon) {
        if (brownLexicon.lookupToken(token) == null) {
            return Collections.emptyList();
        }
        String brownClass = brownLexicon.lookupToken(token);
        ArrayList<String> pathLengthsList = new ArrayList<String>();
        pathLengthsList.add(brownClass.substring(0, StrictMath.min(brownClass.length(), pathLengths[0])));
        for (int i = 1; i < pathLengths.length; ++i) {
            if (pathLengths[i - 1] >= brownClass.length()) continue;
            pathLengthsList.add(brownClass.substring(0, StrictMath.min(brownClass.length(), pathLengths[i])));
        }
        return pathLengthsList;
    }
}

