/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.test.appender;

import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.plugins.Configurable;
import org.apache.logging.log4j.plugins.Plugin;
import org.apache.logging.log4j.plugins.PluginAttribute;
import org.apache.logging.log4j.plugins.PluginFactory;
import org.apache.logging.log4j.plugins.validation.constraints.Required;

@Configurable(elementType="appender", printObject=true)
@Plugin(value="Block")
public class BlockingAppender
extends AbstractAppender {
    public volatile boolean running = true;

    private BlockingAppender(String name) {
        super(name, null, null, false, null);
    }

    public void append(LogEvent event) {
        while (this.running) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {
                this.running = false;
                Thread.currentThread().interrupt();
            }
        }
    }

    public boolean stop(long timeout, TimeUnit timeUnit) {
        this.setStopping();
        super.stop(timeout, timeUnit, false);
        this.running = false;
        this.setStopped();
        return true;
    }

    @PluginFactory
    public static BlockingAppender createAppender(@PluginAttribute @Required(message="A name for the Appender must be specified") String name) {
        return new BlockingAppender(name);
    }
}

