/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.chainsaw.zeroconf;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.DomDriver;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import javax.jmdns.JmDNS;
import javax.jmdns.ServiceEvent;
import javax.jmdns.ServiceInfo;
import javax.jmdns.ServiceListener;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.log4j.chainsaw.LogFilePatternLayoutBuilder;
import org.apache.log4j.chainsaw.SmallButton;
import org.apache.log4j.chainsaw.help.HelpManager;
import org.apache.log4j.chainsaw.icons.ChainsawIcons;
import org.apache.log4j.chainsaw.plugins.GUIPluginSkeleton;
import org.apache.log4j.chainsaw.prefs.SettingsManager;
import org.apache.log4j.chainsaw.vfs.VFSLogFilePatternReceiver;
import org.apache.log4j.chainsaw.zeroconf.ZeroConfDeviceModel;
import org.apache.log4j.chainsaw.zeroconf.ZeroConfPreferenceModel;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.net.MulticastReceiver;
import org.apache.log4j.net.SocketHubReceiver;
import org.apache.log4j.net.SocketReceiver;
import org.apache.log4j.net.UDPReceiver;
import org.apache.log4j.net.XMLSocketReceiver;
import org.apache.log4j.net.ZeroConfSupport;
import org.apache.log4j.plugins.Plugin;
import org.apache.log4j.plugins.PluginEvent;
import org.apache.log4j.plugins.PluginListener;
import org.apache.log4j.plugins.Receiver;
import org.apache.log4j.spi.LoggerRepositoryEx;

public class ZeroConfPlugin
extends GUIPluginSkeleton {
    private static final Logger LOG = Logger.getLogger(ZeroConfPlugin.class);
    private ZeroConfDeviceModel discoveredDevices = new ZeroConfDeviceModel();
    private JTable deviceTable = new JTable(this.discoveredDevices);
    private final JScrollPane scrollPane = new JScrollPane(this.deviceTable);
    private ZeroConfPreferenceModel preferenceModel;
    private Map serviceInfoToReceiveMap = new HashMap();
    private JMenu connectToMenu = new JMenu("Connect to");
    private JMenuItem helpItem = new JMenuItem(new AbstractAction("Learn more about ZeroConf...", ChainsawIcons.ICON_HELP){

        @Override
        public void actionPerformed(ActionEvent e) {
            HelpManager.getInstance().showHelpForClass(ZeroConfPlugin.class);
        }
    });
    private JMenuItem nothingToConnectTo = new JMenuItem("No devices discovered");
    private static final String MULTICAST_APPENDER_SERVICE_NAME = "_log4j_xml_mcast_appender.local.";
    private static final String UDP_APPENDER_SERVICE_NAME = "_log4j_xml_udp_appender.local.";
    private static final String XML_SOCKET_APPENDER_SERVICE_NAME = "_log4j_xml_tcpconnect_appender.local.";
    private static final String SOCKET_APPENDER_SERVICE_NAME = "_log4j_obj_tcpconnect_appender.local.";
    private static final String SOCKETHUB_APPENDER_SERVICE_NAME = "_log4j_obj_tcpaccept_appender.local.";
    private static final String TCP_APPENDER_SERVICE_NAME = "_log4j._tcp.local.";
    private static final String NEW_UDP_APPENDER_SERVICE_NAME = "_log4j._udp.local.";
    private JmDNS jmDNS;

    public ZeroConfPlugin() {
        this.setName("Zeroconf");
        this.deviceTable.setRowHeight(20);
    }

    @Override
    public void shutdown() {
        if (this.jmDNS != null) {
            try {
                this.jmDNS.close();
            }
            catch (Exception e) {
                LOG.error((Object)"Unable to close JMDNS", (Throwable)e);
            }
        }
        this.save();
    }

    private void save() {
        File fileLocation = this.getPreferenceFileLocation();
        XStream stream = new XStream((HierarchicalStreamDriver)new DomDriver());
        try {
            stream.toXML((Object)this.preferenceModel, (Writer)new FileWriter(fileLocation));
        }
        catch (Exception e) {
            LOG.error((Object)"Failed to save ZeroConfPlugin configuration file", (Throwable)e);
        }
    }

    private File getPreferenceFileLocation() {
        return new File(SettingsManager.getInstance().getSettingsDirectory(), "zeroconfprefs.xml");
    }

    public void activateOptions() {
        this.setLayout(new BorderLayout());
        this.jmDNS = (JmDNS)ZeroConfSupport.getJMDNSInstance();
        this.registerServiceListenersForAppenders();
        this.deviceTable.addMouseListener(new ConnectorMouseListener());
        JToolBar toolbar = new JToolBar();
        SmallButton helpButton = new SmallButton(this.helpItem.getAction());
        helpButton.setText(this.helpItem.getText());
        toolbar.add(helpButton);
        toolbar.setFloatable(false);
        this.add((Component)toolbar, "North");
        this.add((Component)this.scrollPane, "Center");
        this.injectMenu();
        ((LoggerRepositoryEx)LogManager.getLoggerRepository()).getPluginRegistry().addPluginListener(new PluginListener(){

            @Override
            public void pluginStarted(PluginEvent e) {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void pluginStopped(PluginEvent e) {
                Plugin plugin = e.getPlugin();
                Map map = ZeroConfPlugin.this.serviceInfoToReceiveMap;
                synchronized (map) {
                    Iterator iter = ZeroConfPlugin.this.serviceInfoToReceiveMap.entrySet().iterator();
                    while (iter.hasNext()) {
                        Map.Entry entry = iter.next();
                        if (entry.getValue() != plugin) continue;
                        iter.remove();
                    }
                }
                ZeroConfPlugin.this.discoveredDevices.fireTableDataChanged();
            }
        });
        File fileLocation = this.getPreferenceFileLocation();
        XStream stream = new XStream((HierarchicalStreamDriver)new DomDriver());
        if (fileLocation.exists()) {
            try {
                this.preferenceModel = (ZeroConfPreferenceModel)stream.fromXML((Reader)new FileReader(fileLocation));
            }
            catch (Exception e) {
                LOG.error((Object)"Failed to load ZeroConfPlugin configuration file", (Throwable)e);
            }
        } else {
            this.preferenceModel = new ZeroConfPreferenceModel();
        }
        this.discoveredDevices.setZeroConfPreferenceModel(this.preferenceModel);
        this.discoveredDevices.setZeroConfPluginParent(this);
    }

    private void registerServiceListenersForAppenders() {
        HashSet<String> serviceNames = new HashSet<String>();
        serviceNames.add(MULTICAST_APPENDER_SERVICE_NAME);
        serviceNames.add(SOCKET_APPENDER_SERVICE_NAME);
        serviceNames.add(SOCKETHUB_APPENDER_SERVICE_NAME);
        serviceNames.add(UDP_APPENDER_SERVICE_NAME);
        serviceNames.add(XML_SOCKET_APPENDER_SERVICE_NAME);
        serviceNames.add(TCP_APPENDER_SERVICE_NAME);
        serviceNames.add(NEW_UDP_APPENDER_SERVICE_NAME);
        Iterator iter = serviceNames.iterator();
        while (iter.hasNext()) {
            String serviceName = iter.next().toString();
            this.jmDNS.addServiceListener(serviceName, (ServiceListener)new ZeroConfServiceListener());
            this.jmDNS.addServiceListener(serviceName, (ServiceListener)this.discoveredDevices);
        }
    }

    private void injectMenu() {
        JFrame frame = (JFrame)SwingUtilities.getWindowAncestor(this);
        if (frame == null) {
            LOG.info((Object)"Could not locate parent JFrame to add menu to");
        } else {
            JMenuBar menuBar = frame.getJMenuBar();
            if (menuBar == null) {
                menuBar = new JMenuBar();
                frame.setJMenuBar(menuBar);
            }
            this.insertToLeftOfHelp(menuBar, this.connectToMenu);
            this.connectToMenu.add(this.nothingToConnectTo);
            this.discoveredDevices.addTableModelListener(new TableModelListener(){

                @Override
                public void tableChanged(TableModelEvent e) {
                    if (ZeroConfPlugin.this.discoveredDevices.getRowCount() == 0) {
                        ZeroConfPlugin.this.connectToMenu.add((Component)ZeroConfPlugin.this.nothingToConnectTo, 0);
                    } else if (ZeroConfPlugin.this.discoveredDevices.getRowCount() > 0) {
                        ZeroConfPlugin.this.connectToMenu.remove(ZeroConfPlugin.this.nothingToConnectTo);
                    }
                }
            });
            this.nothingToConnectTo.setEnabled(false);
            this.connectToMenu.addSeparator();
            this.connectToMenu.add(this.helpItem);
        }
    }

    private void insertToLeftOfHelp(JMenuBar menuBar, JMenu item) {
        for (int i = 0; i < menuBar.getMenuCount(); ++i) {
            JMenu menu = menuBar.getMenu(i);
            if (!menu.getText().equalsIgnoreCase("help")) continue;
            menuBar.add((Component)item, i - 1);
        }
        LOG.warn((Object)("menu '" + item.getText() + "' was NOT added because the 'Help' menu could not be located"));
    }

    private void deviceDiscovered(final ServiceInfo info) {
        final String name = info.getName();
        JMenuItem connectToDeviceMenuItem = new JMenuItem(new AbstractAction(info.getName()){

            @Override
            public void actionPerformed(ActionEvent e) {
                ZeroConfPlugin.this.connectTo(info);
            }
        });
        if (this.discoveredDevices.getRowCount() > 0) {
            Component[] menuComponents = this.connectToMenu.getMenuComponents();
            boolean located = false;
            for (int i = 0; i < menuComponents.length; ++i) {
                JMenuItem item;
                Component c = menuComponents[i];
                if (c instanceof JPopupMenu.Separator || (item = (JMenuItem)menuComponents[i]).getText().compareToIgnoreCase(name) >= 0) continue;
                this.connectToMenu.insert(connectToDeviceMenuItem, i);
                located = true;
                break;
            }
            if (!located) {
                this.connectToMenu.insert(connectToDeviceMenuItem, 0);
            }
        } else {
            this.connectToMenu.insert(connectToDeviceMenuItem, 0);
        }
        if (this.preferenceModel != null && this.preferenceModel.getAutoConnectDevices() != null && this.preferenceModel.getAutoConnectDevices().contains(name)) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    LOG.info((Object)("Auto-connecting to " + name));
                    ZeroConfPlugin.this.connectTo(info);
                }
            }).start();
        }
    }

    private void deviceRemoved(String name) {
        Component[] menuComponents = this.connectToMenu.getMenuComponents();
        for (int i = 0; i < menuComponents.length; ++i) {
            JMenuItem item;
            Component c = menuComponents[i];
            if (c instanceof JPopupMenu.Separator || (item = (JMenuItem)menuComponents[i]).getText().compareToIgnoreCase(name) != 0) continue;
            this.connectToMenu.remove(item);
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void disconnectFrom(ServiceInfo info) {
        Plugin plugin;
        if (!this.isConnectedTo(info)) {
            return;
        }
        Map map = this.serviceInfoToReceiveMap;
        synchronized (map) {
            plugin = (Plugin)this.serviceInfoToReceiveMap.get(info);
        }
        ((LoggerRepositoryEx)LogManager.getLoggerRepository()).getPluginRegistry().stopPlugin(plugin.getName());
        JMenuItem item = this.locateMatchingMenuItem(info.getName());
        if (item != null) {
            item.setIcon(null);
            item.setEnabled(true);
        }
    }

    boolean isConnectedTo(ServiceInfo info) {
        return this.serviceInfoToReceiveMap.containsKey(info);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void connectTo(ServiceInfo info) {
        LOG.info((Object)("Connection request for " + info));
        Receiver receiver = this.getReceiver(info);
        if (receiver == null) {
            return;
        }
        ((LoggerRepositoryEx)LogManager.getLoggerRepository()).getPluginRegistry().addPlugin(receiver);
        receiver.activateOptions();
        LOG.info((Object)("Receiver '" + receiver.getName() + "' has been started"));
        Map map = this.serviceInfoToReceiveMap;
        synchronized (map) {
            this.serviceInfoToReceiveMap.put(info, receiver);
        }
        JMenuItem item = this.locateMatchingMenuItem(info.getName());
        if (item != null) {
            item.setIcon(new ImageIcon(ChainsawIcons.ANIM_NET_CONNECT));
            item.setEnabled(false);
        }
    }

    private Receiver getReceiver(ServiceInfo info) {
        Receiver receiver;
        String zone = info.getType();
        int port = info.getPort();
        String hostAddress = info.getHostAddress();
        String name = info.getName();
        String decoderClass = info.getPropertyString("decoder");
        if (NEW_UDP_APPENDER_SERVICE_NAME.equals(zone)) {
            UDPReceiver receiver2 = new UDPReceiver();
            receiver2.setPort(port);
            receiver2.setName(name + "-receiver");
            return receiver2;
        }
        if (TCP_APPENDER_SERVICE_NAME.equals(zone)) {
            String contentType = info.getPropertyString("contentType").toLowerCase();
            if ("application/octet-stream".equals(contentType)) {
                SocketReceiver receiver3 = new SocketReceiver();
                receiver3.setPort(port);
                receiver3.setName(name + "-receiver");
                return receiver3;
            }
            if ("text/plain".equals(contentType)) {
                VFSLogFilePatternReceiver receiver4 = new VFSLogFilePatternReceiver();
                receiver4.setAppendNonMatches(true);
                receiver4.setFileURL(info.getPropertyString("fileURI"));
                receiver4.setLogFormat(LogFilePatternLayoutBuilder.getLogFormatFromPatternLayout(info.getPropertyString("format")));
                receiver4.setTimestampFormat(LogFilePatternLayoutBuilder.getTimeStampFormat(info.getPropertyString("format")));
                receiver4.setName(name + "-receiver");
                receiver4.setTailing(true);
                return receiver4;
            }
        }
        if (MULTICAST_APPENDER_SERVICE_NAME.equals(zone)) {
            receiver = new MulticastReceiver();
            ((MulticastReceiver)receiver).setAddress(info.getPropertyString("multicastAddress"));
            ((MulticastReceiver)receiver).setPort(port);
            receiver.setName(name + "-receiver");
            if (decoderClass != null && !decoderClass.equals("")) {
                ((MulticastReceiver)receiver).setDecoder(decoderClass);
            }
            return receiver;
        }
        if (UDP_APPENDER_SERVICE_NAME.equals(zone)) {
            receiver = new UDPReceiver();
            ((UDPReceiver)receiver).setPort(port);
            receiver.setName(name + "-receiver");
            if (decoderClass != null && !decoderClass.equals("")) {
                ((UDPReceiver)receiver).setDecoder(decoderClass);
            }
            return receiver;
        }
        if (XML_SOCKET_APPENDER_SERVICE_NAME.equals(zone)) {
            receiver = new XMLSocketReceiver();
            ((XMLSocketReceiver)receiver).setPort(port);
            receiver.setName(name + "-receiver");
            if (decoderClass != null && !decoderClass.equals("")) {
                ((XMLSocketReceiver)receiver).setDecoder(decoderClass);
            }
            return receiver;
        }
        if (SOCKET_APPENDER_SERVICE_NAME.equals(zone)) {
            receiver = new SocketReceiver();
            ((SocketReceiver)receiver).setPort(port);
            receiver.setName(name + "-receiver");
            return receiver;
        }
        if (SOCKETHUB_APPENDER_SERVICE_NAME.equals(zone)) {
            receiver = new SocketHubReceiver();
            ((SocketHubReceiver)receiver).setHost(hostAddress);
            ((SocketHubReceiver)receiver).setPort(port);
            receiver.setName(name + "-receiver");
            return receiver;
        }
        LogLog.debug((String)("Unable to find receiver for appender with service name: " + zone));
        return null;
    }

    private JMenuItem locateMatchingMenuItem(String name) {
        Component[] menuComponents = this.connectToMenu.getMenuComponents();
        for (int i = 0; i < menuComponents.length; ++i) {
            JMenuItem item;
            Component c = menuComponents[i];
            if (c instanceof JPopupMenu.Separator || (item = (JMenuItem)menuComponents[i]).getText().compareToIgnoreCase(name) != 0) continue;
            return item;
        }
        return null;
    }

    public static void main(String[] args) throws InterruptedException {
        BasicConfigurator.resetConfiguration();
        BasicConfigurator.configure();
        final ZeroConfPlugin plugin = new ZeroConfPlugin();
        JFrame frame = new JFrame();
        frame.setDefaultCloseOperation(3);
        frame.getContentPane().setLayout(new BorderLayout());
        frame.getContentPane().add((Component)plugin, "Center");
        plugin.activateOptions();
        frame.pack();
        frame.setVisible(true);
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                plugin.shutdown();
            }
        });
        Runtime.getRuntime().addShutdownHook(thread);
    }

    private class ConnectorMouseListener
    extends MouseAdapter {
        private ConnectorMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() == 2) {
                int row = ZeroConfPlugin.this.deviceTable.rowAtPoint(e.getPoint());
                if (ZeroConfPlugin.this.deviceTable.columnAtPoint(e.getPoint()) == 2) {
                    return;
                }
                ServiceInfo info = ZeroConfPlugin.this.discoveredDevices.getServiceInfoAtRow(row);
                if (!ZeroConfPlugin.this.isConnectedTo(info)) {
                    ZeroConfPlugin.this.connectTo(info);
                } else {
                    ZeroConfPlugin.this.disconnectFrom(info);
                }
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }
    }

    private class ZeroConfServiceListener
    implements ServiceListener {
        private ZeroConfServiceListener() {
        }

        public void serviceAdded(final ServiceEvent event) {
            LOG.info((Object)("Service Added: " + event));
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    ZeroConfPlugin.this.jmDNS.requestServiceInfo(event.getType(), event.getName());
                }
            };
            Thread thread = new Thread(runnable, "ChainsawZeroConfRequestResolutionThread");
            thread.setPriority(1);
            thread.start();
        }

        public void serviceRemoved(ServiceEvent event) {
            LOG.info((Object)("Service Removed: " + event));
            ZeroConfPlugin.this.deviceRemoved(event.getName());
        }

        public void serviceResolved(ServiceEvent event) {
            LOG.info((Object)("Service Resolved: " + event));
            ZeroConfPlugin.this.deviceDiscovered(event.getInfo());
        }
    }
}

