/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.jobhistory.cache.impl;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.time.DateUtils;
import org.apache.linkis.jobhistory.cache.QueryCacheManager;
import org.apache.linkis.jobhistory.cache.impl.ScheduledCleanJob;
import org.apache.linkis.jobhistory.cache.impl.ScheduledRefreshJob;
import org.apache.linkis.jobhistory.cache.impl.ScheduledRefreshUndoneJob;
import org.apache.linkis.jobhistory.cache.impl.UserTaskResultCache;
import org.apache.linkis.jobhistory.conf.JobhistoryConfiguration;
import org.apache.linkis.jobhistory.dao.JobHistoryMapper;
import org.apache.linkis.jobhistory.util.QueryConfig;
import org.quartz.CronScheduleBuilder;
import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SimpleScheduleBuilder;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.quartz.SchedulerFactoryBean;
import org.springframework.stereotype.Component;

@Component
public class DefaultQueryCacheManager
implements QueryCacheManager,
InitializingBean {
    private static Logger logger = LoggerFactory.getLogger(DefaultQueryCacheManager.class);
    @Autowired
    private SchedulerFactoryBean schedulerFactoryBean;
    @Autowired
    private JobHistoryMapper jobHistoryMapper;
    private Map<String, Cache<String, UserTaskResultCache>> engineUserCaches = Maps.newConcurrentMap();
    private Long undoneTaskMinId = Long.valueOf(String.valueOf(JobhistoryConfiguration.UNDONE_JOB_MINIMUM_ID().getValue()));

    @PostConstruct
    private void init() {
        Thread undoneTask = new Thread(() -> {
            try {
                this.refreshUndoneTask();
            }
            catch (Exception e) {
                logger.info("Failed to init refresh undone task", (Throwable)e);
            }
        });
        undoneTask.setName("refreshUndoneTask");
        undoneTask.start();
    }

    public void afterPropertiesSet() throws Exception {
        Scheduler scheduler = this.schedulerFactoryBean.getScheduler();
        SimpleScheduleBuilder cleanBuilder = SimpleScheduleBuilder.simpleSchedule().withIntervalInMinutes(((Integer)QueryConfig.CACHE_CLEANING_INTERVAL_MINUTE().getValue()).intValue()).repeatForever();
        JobDetail cleanJobDetail = JobBuilder.newJob(ScheduledCleanJob.class).withIdentity("ScheduledCleanJob").storeDurably().build();
        cleanJobDetail.getJobDataMap().put(QueryCacheManager.class.getName(), (Object)this);
        Trigger cleanTrigger = TriggerBuilder.newTrigger().withIdentity("ScheduledCleanJob").withSchedule((ScheduleBuilder)cleanBuilder).build();
        scheduler.scheduleJob(cleanJobDetail, cleanTrigger);
        logger.info("Submitted cache cleaning job.");
        if (((Boolean)QueryConfig.CACHE_DAILY_EXPIRE_ENABLED().getValue()).booleanValue()) {
            CronScheduleBuilder refreshBuilder = CronScheduleBuilder.dailyAtHourAndMinute((int)0, (int)0);
            JobDetail refreshJobDetail = JobBuilder.newJob(ScheduledRefreshJob.class).withIdentity("ScheduledRefreshJob").storeDurably().build();
            refreshJobDetail.getJobDataMap().put(QueryCacheManager.class.getName(), (Object)this);
            Trigger refreshTrigger = TriggerBuilder.newTrigger().withIdentity("ScheduledRefreshJob").withSchedule((ScheduleBuilder)refreshBuilder).build();
            scheduler.scheduleJob(refreshJobDetail, refreshTrigger);
            logger.info("Submitted cache 00:00 refresh job.");
        }
        int hour = 0;
        int minute = 15;
        try {
            String refreshTime = (String)JobhistoryConfiguration.UNDONE_JOB_REFRESH_TIME_DAILY().getValue();
            String[] parts = refreshTime.split(":");
            if (parts.length != 2) {
                logger.error("Invalid UNDONE_JOB_REFRESH_TIME_DAILY value: {}. It should be the format of '00:15'. Will use the default value '00:15'", (Object)refreshTime);
            }
            hour = Integer.parseInt(parts[0]);
            minute = Integer.parseInt(parts[1]);
        }
        catch (Exception ignored) {
            logger.warn("parse the config 'wds.linkis.jobhistory.undone.job.refreshtime.daily' failed. ", (Throwable)ignored);
        }
        CronScheduleBuilder refreshUndoneJobBuilder = CronScheduleBuilder.dailyAtHourAndMinute((int)hour, (int)minute);
        JobDetail refreshUndoneJobDetail = JobBuilder.newJob(ScheduledRefreshUndoneJob.class).withIdentity("ScheduledRefreshUndoneJob").storeDurably().build();
        refreshUndoneJobDetail.getJobDataMap().put(QueryCacheManager.class.getName(), (Object)this);
        Trigger refreshTrigger = TriggerBuilder.newTrigger().withIdentity("ScheduledRefreshUndoneJob").withSchedule((ScheduleBuilder)refreshUndoneJobBuilder).build();
        scheduler.scheduleJob(refreshUndoneJobDetail, refreshTrigger);
        logger.info("Submitted cache 00:15 refresh undone job.");
        if (!scheduler.isShutdown()) {
            scheduler.start();
        }
    }

    @Override
    public UserTaskResultCache getCache(String user, String engineType) {
        UserTaskResultCache userCache;
        Cache<String, UserTaskResultCache> oldCaches;
        Cache<String, UserTaskResultCache> userCaches = this.engineUserCaches.getOrDefault(engineType, null);
        if (userCaches == null && (oldCaches = this.engineUserCaches.putIfAbsent(engineType, userCaches = this.createUserCaches())) != null) {
            userCaches = oldCaches;
        }
        if ((userCache = (UserTaskResultCache)userCaches.getIfPresent((Object)user)) == null) {
            userCache = new UserTaskResultCache();
            userCaches.put((Object)user, (Object)userCache);
        }
        return userCache;
    }

    @Override
    public void cleanAll() {
        this.foreach(UserTaskResultCache::clean);
    }

    @Override
    public void refreshAll() {
        this.foreach(UserTaskResultCache::refresh);
    }

    @Override
    public void refreshUndoneTask() {
        List<Integer> queryTasks = null;
        Date eDate = new Date(System.currentTimeMillis());
        Date sDate = DateUtils.addDays((Date)eDate, (int)-1);
        try {
            queryTasks = this.jobHistoryMapper.searchWithIdOrderAsc(sDate, eDate, this.undoneTaskMinId, Arrays.asList("Running", "Inited", "Scheduled"));
        }
        catch (Exception e) {
            logger.warn("Failed to refresh undone tasks", (Throwable)e);
        }
        if (null != queryTasks && !queryTasks.isEmpty()) {
            this.undoneTaskMinId = ((Integer)queryTasks.get(0)).longValue();
            logger.info("Refreshing undone tasks, minimum id: {}", (Object)this.undoneTaskMinId);
        } else {
            Integer maxID = this.jobHistoryMapper.maxID(sDate, eDate, this.undoneTaskMinId);
            if (null != maxID && (long)maxID.intValue() > this.undoneTaskMinId) {
                this.undoneTaskMinId = maxID.longValue();
            }
        }
    }

    private void foreach(Consumer<UserTaskResultCache> consumer) {
        for (Cache<String, UserTaskResultCache> cacheContainer : this.engineUserCaches.values()) {
            for (UserTaskResultCache cache : cacheContainer.asMap().values()) {
                consumer.accept(cache);
            }
        }
    }

    private Cache<String, UserTaskResultCache> createUserCaches() {
        return CacheBuilder.newBuilder().build();
    }

    public Long getUndoneTaskMinId() {
        return this.undoneTaskMinId;
    }
}

