/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.manager.persistence.impl;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.linkis.common.ServiceInstance;
import org.apache.linkis.manager.common.entity.persistence.PersistenceLabel;
import org.apache.linkis.manager.common.entity.persistence.PersistenceResource;
import org.apache.linkis.manager.dao.LabelManagerMapper;
import org.apache.linkis.manager.dao.NodeManagerMapper;
import org.apache.linkis.manager.dao.ResourceManagerMapper;
import org.apache.linkis.manager.exception.PersistenceErrorException;
import org.apache.linkis.manager.label.entity.Label;
import org.apache.linkis.manager.persistence.ResourceManagerPersistence;
import org.springframework.jdbc.CannotGetJdbcConnectionException;
import org.springframework.retry.annotation.Backoff;
import org.springframework.retry.annotation.Retryable;

public class DefaultResourceManagerPersistence
implements ResourceManagerPersistence {
    private ResourceManagerMapper resourceManagerMapper;
    private NodeManagerMapper nodeManagerMapper;
    private LabelManagerMapper labelManagerMapper;

    public ResourceManagerMapper getResourceManagerMapper() {
        return this.resourceManagerMapper;
    }

    public void setResourceManagerMapper(ResourceManagerMapper resourceManagerMapper) {
        this.resourceManagerMapper = resourceManagerMapper;
    }

    public NodeManagerMapper getNodeManagerMapper() {
        return this.nodeManagerMapper;
    }

    public void setNodeManagerMapper(NodeManagerMapper nodeManagerMapper) {
        this.nodeManagerMapper = nodeManagerMapper;
    }

    public LabelManagerMapper getLabelManagerMapper() {
        return this.labelManagerMapper;
    }

    public void setLabelManagerMapper(LabelManagerMapper labelManagerMapper) {
        this.labelManagerMapper = labelManagerMapper;
    }

    @Override
    public void registerResource(PersistenceResource persistenceResource) throws PersistenceErrorException {
        this.resourceManagerMapper.registerResource(persistenceResource);
    }

    @Override
    public void registerResource(ServiceInstance serviceInstance, PersistenceResource persistenceResource) throws PersistenceErrorException {
        this.resourceManagerMapper.registerResource(persistenceResource);
        int resourceId = persistenceResource.getId();
        List<Integer> labelIds = this.labelManagerMapper.getLabelIdsByInstance(serviceInstance.getInstance());
        this.labelManagerMapper.addLabelsAndResource(resourceId, labelIds);
    }

    @Override
    public List<PersistenceResource> getResourceByLabel(Label label) throws PersistenceErrorException {
        String labelKey = label.getLabelKey();
        String stringValue = label.getStringValue();
        List<PersistenceResource> persistenceResourceList = this.labelManagerMapper.getResourcesByLabel(labelKey, stringValue);
        return persistenceResourceList;
    }

    @Override
    public List<PersistenceResource> getResourceByLabels(List<? extends Label> labels) throws PersistenceErrorException {
        if (CollectionUtils.isNotEmpty(labels)) {
            return this.labelManagerMapper.getResourcesByLabels(labels);
        }
        return new ArrayList<PersistenceResource>();
    }

    @Override
    public List<PersistenceResource> getResourceByUser(String user) throws PersistenceErrorException {
        List<PersistenceResource> persistenceResourceList = this.resourceManagerMapper.getResourceByUserName(user);
        return persistenceResourceList;
    }

    @Override
    public List<PersistenceResource> getResourceByServiceInstance(ServiceInstance serviceInstance, String resourceType) throws PersistenceErrorException {
        List<PersistenceResource> persistenceResourceList = this.resourceManagerMapper.getResourceByInstanceAndResourceType(serviceInstance.getInstance(), resourceType);
        return persistenceResourceList;
    }

    @Override
    public List<PersistenceResource> getResourceByServiceInstance(ServiceInstance serviceInstance) throws PersistenceErrorException {
        List<PersistenceResource> persistenceResourceList = this.resourceManagerMapper.getResourceByServiceInstance(serviceInstance.getInstance());
        return persistenceResourceList;
    }

    @Override
    public void deleteServiceInstanceResource(ServiceInstance serviceInstance) throws PersistenceErrorException {
        this.resourceManagerMapper.deleteResourceByInstance(serviceInstance.getInstance());
        this.resourceManagerMapper.deleteResourceAndLabelId(serviceInstance.getInstance());
    }

    @Override
    public void deleteExpiredTicketIdResource(String ticketId) throws PersistenceErrorException {
        this.labelManagerMapper.deleteLabelResourceByByTicketId(ticketId);
        this.resourceManagerMapper.deleteResourceByTicketId(ticketId);
    }

    @Override
    public void nodeResourceUpdate(ServiceInstance serviceInstance, PersistenceResource persistenceResource) throws PersistenceErrorException {
        int resourceId = this.resourceManagerMapper.getNodeResourceUpdateResourceId(serviceInstance.getInstance());
        this.resourceManagerMapper.nodeResourceUpdateByResourceId(resourceId, persistenceResource);
    }

    @Override
    @Retryable(value={CannotGetJdbcConnectionException.class}, backoff=@Backoff(delay=10000L))
    public PersistenceResource getNodeResourceByTicketId(String ticketId) {
        PersistenceResource persistenceResource = this.resourceManagerMapper.getNodeResourceByTicketId(ticketId);
        return persistenceResource;
    }

    @Override
    public void nodeResourceUpdate(String ticketId, PersistenceResource persistenceResource) {
        this.resourceManagerMapper.nodeResourceUpdate(ticketId, persistenceResource);
    }

    @Override
    public List<PersistenceLabel> getLabelsByTicketId(String ticketId) {
        List<PersistenceLabel> persistenceLabelList = this.resourceManagerMapper.getLabelsByTicketId(ticketId);
        return persistenceLabelList;
    }

    @Override
    public void lockResource(List<Integer> labelIds, PersistenceResource persistenceResource) {
        this.resourceManagerMapper.registerResource(persistenceResource);
        int resourceId = persistenceResource.getId();
        this.labelManagerMapper.addLabelsAndResource(resourceId, labelIds);
    }

    @Override
    public void deleteResourceById(List<Integer> id) {
        this.resourceManagerMapper.deleteResourceById(id);
    }

    @Override
    public void deleteResourceRelByResourceId(List<Integer> id) {
        this.resourceManagerMapper.deleteResourceRelByResourceId(id);
    }

    @Override
    public PersistenceResource getNodeResourceById(Integer id) {
        PersistenceResource resource = this.resourceManagerMapper.getResourceById(id);
        return resource;
    }
}

