/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.parquet.write;

import java.util.List;
import java.util.Map;
import org.apache.hadoop.hive.common.type.Date;
import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.common.type.Timestamp;
import org.apache.hadoop.hive.ql.io.parquet.serde.ParquetHiveSerDe;
import org.apache.hadoop.hive.ql.io.parquet.timestamp.NanoTimeUtils;
import org.apache.hadoop.hive.serde2.io.DateWritableV2;
import org.apache.hadoop.hive.serde2.io.ParquetHiveRecord;
import org.apache.hadoop.hive.serde2.objectinspector.ListObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.MapObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.BinaryObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.BooleanObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.ByteObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.DateObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.DoubleObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.FloatObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.HiveCharObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.HiveDecimalObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.HiveVarcharObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.IntObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.LongObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.ShortObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.StringObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.TimestampObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.DecimalTypeInfo;
import org.apache.parquet.io.api.Binary;
import org.apache.parquet.io.api.RecordConsumer;
import org.apache.parquet.schema.GroupType;
import org.apache.parquet.schema.OriginalType;
import org.apache.parquet.schema.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataWritableWriter {
    private static final Logger LOG = LoggerFactory.getLogger(DataWritableWriter.class);
    protected final RecordConsumer recordConsumer;
    private final GroupType schema;
    private DataWriter messageWriter;

    public DataWritableWriter(RecordConsumer recordConsumer, GroupType schema) {
        this.recordConsumer = recordConsumer;
        this.schema = schema;
    }

    public void write(ParquetHiveRecord record) {
        if (record != null) {
            if (this.messageWriter == null) {
                try {
                    this.messageWriter = this.createMessageWriter(record.getObjectInspector(), this.schema);
                }
                catch (RuntimeException e) {
                    String errorMessage = "Parquet record is malformed: " + e.getMessage();
                    LOG.error(errorMessage, (Throwable)e);
                    throw new RuntimeException(errorMessage, e);
                }
            }
            this.messageWriter.write(record.getObject());
        }
    }

    private MessageDataWriter createMessageWriter(StructObjectInspector inspector, GroupType schema) {
        return new MessageDataWriter(inspector, schema);
    }

    private DataWriter createWriter(ObjectInspector inspector, Type type) {
        if (type.isPrimitive()) {
            this.checkInspectorCategory(inspector, ObjectInspector.Category.PRIMITIVE);
            PrimitiveObjectInspector primitiveInspector = (PrimitiveObjectInspector)inspector;
            switch (primitiveInspector.getPrimitiveCategory()) {
                case BOOLEAN: {
                    return new BooleanDataWriter((BooleanObjectInspector)inspector);
                }
                case BYTE: {
                    return new ByteDataWriter((ByteObjectInspector)inspector);
                }
                case SHORT: {
                    return new ShortDataWriter((ShortObjectInspector)inspector);
                }
                case INT: {
                    return new IntDataWriter((IntObjectInspector)inspector);
                }
                case LONG: {
                    return new LongDataWriter((LongObjectInspector)inspector);
                }
                case FLOAT: {
                    return new FloatDataWriter((FloatObjectInspector)inspector);
                }
                case DOUBLE: {
                    return new DoubleDataWriter((DoubleObjectInspector)inspector);
                }
                case STRING: {
                    return new StringDataWriter((StringObjectInspector)inspector);
                }
                case CHAR: {
                    return new CharDataWriter((HiveCharObjectInspector)inspector);
                }
                case VARCHAR: {
                    return new VarcharDataWriter((HiveVarcharObjectInspector)inspector);
                }
                case BINARY: {
                    return new BinaryDataWriter((BinaryObjectInspector)inspector);
                }
                case TIMESTAMP: {
                    return new TimestampDataWriter((TimestampObjectInspector)inspector);
                }
                case DECIMAL: {
                    return new DecimalDataWriter((HiveDecimalObjectInspector)inspector);
                }
                case DATE: {
                    return new DateDataWriter((DateObjectInspector)inspector);
                }
            }
            throw new IllegalArgumentException("Unsupported primitive data type: " + (Object)((Object)primitiveInspector.getPrimitiveCategory()));
        }
        GroupType groupType = type.asGroupType();
        OriginalType originalType = type.getOriginalType();
        if (originalType != null && originalType.equals((Object)OriginalType.LIST)) {
            this.checkInspectorCategory(inspector, ObjectInspector.Category.LIST);
            return new ListDataWriter((ListObjectInspector)inspector, groupType);
        }
        if (originalType != null && originalType.equals((Object)OriginalType.MAP)) {
            this.checkInspectorCategory(inspector, ObjectInspector.Category.MAP);
            return new MapDataWriter((MapObjectInspector)inspector, groupType);
        }
        this.checkInspectorCategory(inspector, ObjectInspector.Category.STRUCT);
        return new StructDataWriter((StructObjectInspector)inspector, groupType);
    }

    private void checkInspectorCategory(ObjectInspector inspector, ObjectInspector.Category category) {
        if (!inspector.getCategory().equals((Object)category)) {
            throw new IllegalArgumentException("Invalid data type: expected " + (Object)((Object)category) + " type, but found: " + (Object)((Object)inspector.getCategory()));
        }
    }

    private class DateDataWriter
    implements DataWriter {
        private DateObjectInspector inspector;

        public DateDataWriter(DateObjectInspector inspector) {
            this.inspector = inspector;
        }

        @Override
        public void write(Object value) {
            Date vDate = this.inspector.getPrimitiveJavaObject(value);
            DataWritableWriter.this.recordConsumer.addInteger(DateWritableV2.dateToDays(vDate));
        }
    }

    private class DecimalDataWriter
    implements DataWriter {
        private HiveDecimalObjectInspector inspector;

        public DecimalDataWriter(HiveDecimalObjectInspector inspector) {
            this.inspector = inspector;
        }

        @Override
        public void write(Object value) {
            HiveDecimal vDecimal = this.inspector.getPrimitiveJavaObject(value);
            DecimalTypeInfo decTypeInfo = (DecimalTypeInfo)this.inspector.getTypeInfo();
            DataWritableWriter.this.recordConsumer.addBinary(this.decimalToBinary(vDecimal, decTypeInfo));
        }

        private Binary decimalToBinary(HiveDecimal hiveDecimal, DecimalTypeInfo decimalTypeInfo) {
            int scale;
            byte[] decimalBytes;
            int prec = decimalTypeInfo.precision();
            int precToBytes = ParquetHiveSerDe.PRECISION_TO_BYTE_COUNT[prec - 1];
            if (precToBytes == (decimalBytes = hiveDecimal.bigIntegerBytesScaled(scale = decimalTypeInfo.scale())).length) {
                return Binary.fromByteArray(decimalBytes);
            }
            byte[] tgt = new byte[precToBytes];
            if (hiveDecimal.signum() == -1) {
                int i = 0;
                while (i < precToBytes) {
                    int n = i++;
                    tgt[n] = (byte)(tgt[n] | 0xFF);
                }
            }
            System.arraycopy(decimalBytes, 0, tgt, precToBytes - decimalBytes.length, decimalBytes.length);
            return Binary.fromByteArray(tgt);
        }
    }

    private class TimestampDataWriter
    implements DataWriter {
        private TimestampObjectInspector inspector;

        public TimestampDataWriter(TimestampObjectInspector inspector) {
            this.inspector = inspector;
        }

        @Override
        public void write(Object value) {
            Timestamp ts = this.inspector.getPrimitiveJavaObject(value);
            DataWritableWriter.this.recordConsumer.addBinary(NanoTimeUtils.getNanoTime(ts, false).toBinary());
        }
    }

    private class BinaryDataWriter
    implements DataWriter {
        private BinaryObjectInspector inspector;

        public BinaryDataWriter(BinaryObjectInspector inspector) {
            this.inspector = inspector;
        }

        @Override
        public void write(Object value) {
            byte[] vBinary = this.inspector.getPrimitiveJavaObject(value);
            DataWritableWriter.this.recordConsumer.addBinary(Binary.fromByteArray(vBinary));
        }
    }

    private class VarcharDataWriter
    implements DataWriter {
        private HiveVarcharObjectInspector inspector;

        public VarcharDataWriter(HiveVarcharObjectInspector inspector) {
            this.inspector = inspector;
        }

        @Override
        public void write(Object value) {
            String v = this.inspector.getPrimitiveJavaObject(value).getValue();
            DataWritableWriter.this.recordConsumer.addBinary(Binary.fromString(v));
        }
    }

    private class CharDataWriter
    implements DataWriter {
        private HiveCharObjectInspector inspector;

        public CharDataWriter(HiveCharObjectInspector inspector) {
            this.inspector = inspector;
        }

        @Override
        public void write(Object value) {
            String v = this.inspector.getPrimitiveJavaObject(value).getStrippedValue();
            DataWritableWriter.this.recordConsumer.addBinary(Binary.fromString(v));
        }
    }

    private class StringDataWriter
    implements DataWriter {
        private StringObjectInspector inspector;

        public StringDataWriter(StringObjectInspector inspector) {
            this.inspector = inspector;
        }

        @Override
        public void write(Object value) {
            String v = this.inspector.getPrimitiveJavaObject(value);
            DataWritableWriter.this.recordConsumer.addBinary(Binary.fromString(v));
        }
    }

    private class DoubleDataWriter
    implements DataWriter {
        private DoubleObjectInspector inspector;

        public DoubleDataWriter(DoubleObjectInspector inspector) {
            this.inspector = inspector;
        }

        @Override
        public void write(Object value) {
            DataWritableWriter.this.recordConsumer.addDouble(this.inspector.get(value));
        }
    }

    private class FloatDataWriter
    implements DataWriter {
        private FloatObjectInspector inspector;

        public FloatDataWriter(FloatObjectInspector inspector) {
            this.inspector = inspector;
        }

        @Override
        public void write(Object value) {
            DataWritableWriter.this.recordConsumer.addFloat(this.inspector.get(value));
        }
    }

    private class LongDataWriter
    implements DataWriter {
        private LongObjectInspector inspector;

        public LongDataWriter(LongObjectInspector inspector) {
            this.inspector = inspector;
        }

        @Override
        public void write(Object value) {
            DataWritableWriter.this.recordConsumer.addLong(this.inspector.get(value));
        }
    }

    private class IntDataWriter
    implements DataWriter {
        private IntObjectInspector inspector;

        public IntDataWriter(IntObjectInspector inspector) {
            this.inspector = inspector;
        }

        @Override
        public void write(Object value) {
            DataWritableWriter.this.recordConsumer.addInteger(this.inspector.get(value));
        }
    }

    private class ShortDataWriter
    implements DataWriter {
        private ShortObjectInspector inspector;

        public ShortDataWriter(ShortObjectInspector inspector) {
            this.inspector = inspector;
        }

        @Override
        public void write(Object value) {
            DataWritableWriter.this.recordConsumer.addInteger(this.inspector.get(value));
        }
    }

    private class ByteDataWriter
    implements DataWriter {
        private ByteObjectInspector inspector;

        public ByteDataWriter(ByteObjectInspector inspector) {
            this.inspector = inspector;
        }

        @Override
        public void write(Object value) {
            DataWritableWriter.this.recordConsumer.addInteger(this.inspector.get(value));
        }
    }

    private class BooleanDataWriter
    implements DataWriter {
        private BooleanObjectInspector inspector;

        public BooleanDataWriter(BooleanObjectInspector inspector) {
            this.inspector = inspector;
        }

        @Override
        public void write(Object value) {
            DataWritableWriter.this.recordConsumer.addBoolean(this.inspector.get(value));
        }
    }

    private class MapDataWriter
    implements DataWriter {
        private MapObjectInspector inspector;
        private String repeatedGroupName;
        private String keyName;
        private String valueName;
        private DataWriter keyWriter;
        private DataWriter valueWriter;

        public MapDataWriter(MapObjectInspector inspector, GroupType groupType) {
            this.inspector = inspector;
            GroupType repeatedType = groupType.getType(0).asGroupType();
            this.repeatedGroupName = repeatedType.getName();
            Type keyType = repeatedType.getType(0);
            ObjectInspector keyInspector = this.inspector.getMapKeyObjectInspector();
            this.keyName = keyType.getName();
            this.keyWriter = DataWritableWriter.this.createWriter(keyInspector, keyType);
            Type valuetype = repeatedType.getType(1);
            ObjectInspector valueInspector = this.inspector.getMapValueObjectInspector();
            this.valueName = valuetype.getName();
            this.valueWriter = DataWritableWriter.this.createWriter(valueInspector, valuetype);
        }

        @Override
        public void write(Object value) {
            DataWritableWriter.this.recordConsumer.startGroup();
            Map<?, ?> mapValues = this.inspector.getMap(value);
            if (mapValues != null && mapValues.size() > 0) {
                DataWritableWriter.this.recordConsumer.startField(this.repeatedGroupName, 0);
                for (Map.Entry<?, ?> keyValue : mapValues.entrySet()) {
                    DataWritableWriter.this.recordConsumer.startGroup();
                    if (keyValue != null) {
                        Object keyElement = keyValue.getKey();
                        DataWritableWriter.this.recordConsumer.startField(this.keyName, 0);
                        this.keyWriter.write(keyElement);
                        DataWritableWriter.this.recordConsumer.endField(this.keyName, 0);
                        Object valueElement = keyValue.getValue();
                        if (valueElement != null) {
                            DataWritableWriter.this.recordConsumer.startField(this.valueName, 1);
                            this.valueWriter.write(valueElement);
                            DataWritableWriter.this.recordConsumer.endField(this.valueName, 1);
                        }
                    }
                    DataWritableWriter.this.recordConsumer.endGroup();
                }
                DataWritableWriter.this.recordConsumer.endField(this.repeatedGroupName, 0);
            }
            DataWritableWriter.this.recordConsumer.endGroup();
        }
    }

    private class ListDataWriter
    implements DataWriter {
        private ListObjectInspector inspector;
        private String elementName;
        private DataWriter elementWriter;
        private String repeatedGroupName;

        public ListDataWriter(ListObjectInspector inspector, GroupType groupType) {
            this.inspector = inspector;
            GroupType repeatedType = groupType.getType(0).asGroupType();
            this.repeatedGroupName = repeatedType.getName();
            Type elementType = repeatedType.getType(0);
            this.elementName = elementType.getName();
            ObjectInspector elementInspector = this.inspector.getListElementObjectInspector();
            this.elementWriter = DataWritableWriter.this.createWriter(elementInspector, elementType);
        }

        @Override
        public void write(Object value) {
            DataWritableWriter.this.recordConsumer.startGroup();
            int listLength = this.inspector.getListLength(value);
            if (listLength > 0) {
                DataWritableWriter.this.recordConsumer.startField(this.repeatedGroupName, 0);
                for (int i = 0; i < listLength; ++i) {
                    Object element = this.inspector.getListElement(value, i);
                    DataWritableWriter.this.recordConsumer.startGroup();
                    if (element != null) {
                        DataWritableWriter.this.recordConsumer.startField(this.elementName, 0);
                        this.elementWriter.write(element);
                        DataWritableWriter.this.recordConsumer.endField(this.elementName, 0);
                    }
                    DataWritableWriter.this.recordConsumer.endGroup();
                }
                DataWritableWriter.this.recordConsumer.endField(this.repeatedGroupName, 0);
            }
            DataWritableWriter.this.recordConsumer.endGroup();
        }
    }

    private class StructDataWriter
    extends GroupDataWriter
    implements DataWriter {
        public StructDataWriter(StructObjectInspector inspector, GroupType groupType) {
            super(inspector, groupType);
        }

        @Override
        public void write(Object value) {
            DataWritableWriter.this.recordConsumer.startGroup();
            super.write(value);
            DataWritableWriter.this.recordConsumer.endGroup();
        }
    }

    private class MessageDataWriter
    extends GroupDataWriter
    implements DataWriter {
        public MessageDataWriter(StructObjectInspector inspector, GroupType groupType) {
            super(inspector, groupType);
        }

        @Override
        public void write(Object value) {
            DataWritableWriter.this.recordConsumer.startMessage();
            if (value != null) {
                super.write(value);
            }
            DataWritableWriter.this.recordConsumer.endMessage();
        }
    }

    private class GroupDataWriter
    implements DataWriter {
        private StructObjectInspector inspector;
        private List<? extends StructField> structFields;
        private DataWriter[] structWriters;

        public GroupDataWriter(StructObjectInspector inspector, GroupType groupType) {
            this.inspector = inspector;
            this.structFields = this.inspector.getAllStructFieldRefs();
            this.structWriters = new DataWriter[this.structFields.size()];
            for (int i = 0; i < this.structFields.size(); ++i) {
                StructField field = this.structFields.get(i);
                this.structWriters[i] = DataWritableWriter.this.createWriter(field.getFieldObjectInspector(), groupType.getType(i));
            }
        }

        @Override
        public void write(Object value) {
            for (int i = 0; i < this.structFields.size(); ++i) {
                StructField field = this.structFields.get(i);
                Object fieldValue = this.inspector.getStructFieldData(value, field);
                if (fieldValue == null) continue;
                String fieldName = field.getFieldName();
                DataWriter writer = this.structWriters[i];
                DataWritableWriter.this.recordConsumer.startField(fieldName, i);
                writer.write(fieldValue);
                DataWritableWriter.this.recordConsumer.endField(fieldName, i);
            }
        }
    }

    private static interface DataWriter {
        public void write(Object var1);
    }
}

