/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.cs.condition.construction;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.linkis.cs.condition.Condition;
import org.apache.linkis.cs.condition.construction.ConditionParser;
import org.apache.linkis.cs.condition.impl.ContextValueTypeCondition;
import org.apache.linkis.cs.conf.CSConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContextValueTypeConditionParser
implements ConditionParser {
    private static final Logger logger = LoggerFactory.getLogger(ContextValueTypeConditionParser.class);

    @Override
    public Condition parse(Map<Object, Object> conditionMap) {
        Class contextValueType = Object.class;
        try {
            String valueType = (String)conditionMap.get("contextValueType");
            List<String> contextValueTypeWhiteList = Arrays.asList(((String)CSConfiguration.CONTEXT_VALUE_TYPE_PREFIX_WHITE_LIST.getValue()).split(","));
            if (((Boolean)CSConfiguration.ENABLE_CONTEXT_VALUE_TYPE_PREFIX_WHITE_LIST_CHECK.getValue()).booleanValue()) {
                if (contextValueTypeWhiteList.stream().anyMatch(ele -> StringUtils.startsWith((CharSequence)valueType, (CharSequence)ele))) {
                    contextValueType = Class.forName(valueType);
                } else {
                    logger.error("ContextValueType: {} is illegal", (Object)valueType);
                }
            } else {
                contextValueType = Class.forName(valueType);
            }
        }
        catch (ClassNotFoundException e) {
            logger.error("Cannot find contextValueType:" + conditionMap.get("contextValueType"));
        }
        return new ContextValueTypeCondition(contextValueType);
    }

    @Override
    public String getName() {
        return "ContextValueType";
    }
}

