/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.monitor.bml.cleaner.service.impl;

import java.io.IOException;
import org.apache.linkis.common.io.FsPath;
import org.apache.linkis.monitor.bml.cleaner.dao.VersionDao;
import org.apache.linkis.monitor.bml.cleaner.entity.CleanedResourceVersion;
import org.apache.linkis.monitor.bml.cleaner.service.VersionService;
import org.apache.linkis.storage.fs.FileSystem;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class VersionServiceImpl
implements VersionService {
    @Autowired
    VersionDao versionDao;

    public void setVersionDao(VersionDao versionDao) {
        this.versionDao = versionDao;
    }

    @Override
    @Transactional(rollbackFor={Throwable.class})
    public void doMove(FileSystem fs, FsPath srcPath, FsPath destPath, CleanedResourceVersion insertVersion, long delVersionId) throws IOException {
        this.versionDao.insertCleanResourceVersion(insertVersion);
        this.versionDao.deleteResourceVersionById(delVersionId);
        fs.renameTo(srcPath, destPath);
    }

    @Override
    @Transactional
    public void moveOnDb(CleanedResourceVersion insertVersion, long delVersionId) {
        this.versionDao.insertCleanResourceVersion(insertVersion);
        this.versionDao.deleteResourceVersionById(delVersionId);
    }

    public String test() {
        return "this a test string";
    }
}

