/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.druid;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import org.apache.calcite.adapter.druid.ComplexMetric;
import org.apache.calcite.adapter.druid.DruidConnectionImpl;
import org.apache.calcite.adapter.druid.DruidTable;
import org.apache.calcite.schema.Table;
import org.apache.calcite.schema.impl.AbstractSchema;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.util.Compatible;

public class DruidSchema
extends AbstractSchema {
    final String url;
    final String coordinatorUrl;
    private final boolean discoverTables;
    private Map<String, Table> tableMap = null;

    public DruidSchema(String url, String coordinatorUrl, boolean discoverTables) {
        this.url = (String)Preconditions.checkNotNull((Object)url);
        this.coordinatorUrl = (String)Preconditions.checkNotNull((Object)coordinatorUrl);
        this.discoverTables = discoverTables;
    }

    protected Map<String, Table> getTableMap() {
        if (!this.discoverTables) {
            return ImmutableMap.of();
        }
        if (this.tableMap == null) {
            final DruidConnectionImpl connection = new DruidConnectionImpl(this.url, this.coordinatorUrl);
            Set<String> tableNames = connection.tableNames();
            this.tableMap = Compatible.INSTANCE.asMap((Set)ImmutableSet.copyOf(tableNames), (Function)CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<String, Table>(){

                public Table load(@Nonnull String tableName) throws Exception {
                    LinkedHashMap<String, SqlTypeName> fieldMap = new LinkedHashMap<String, SqlTypeName>();
                    LinkedHashSet<String> metricNameSet = new LinkedHashSet<String>();
                    HashMap<String, List<ComplexMetric>> complexMetrics = new HashMap<String, List<ComplexMetric>>();
                    connection.metadata(tableName, "__time", null, fieldMap, metricNameSet, complexMetrics);
                    return DruidTable.create(DruidSchema.this, tableName, null, fieldMap, metricNameSet, "__time", complexMetrics);
                }
            }));
        }
        return this.tableMap;
    }
}

