/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.metadata.query.server.utils;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.net.URLClassLoader;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.linkis.common.conf.CommonVars;
import org.apache.linkis.metadata.query.common.errorcode.LinkisMetadataQueryErrorCodeSummary;
import org.apache.linkis.metadata.query.common.exception.MetaRuntimeException;
import org.apache.linkis.metadata.query.common.service.BaseMetadataService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetadataUtils {
    private static final String JAR_SUF_NAME = ".jar";
    private static final String CLASS_SUF_NAME = ".class";
    private static final Logger LOG = LoggerFactory.getLogger(MetadataUtils.class);
    public static final String NAME_REGEX = (String)CommonVars.apply((String)"linkis.metadata.query.regex", (Object)"^[a-zA-Z\\-\\d_\\.=/:,]+$").getValue();
    public static final Pattern nameRegexPattern = Pattern.compile(NAME_REGEX);

    public static Class<?> getPrimitive(Class<?> clazz) {
        try {
            Class primitive = null;
            if (clazz.isPrimitive()) {
                primitive = clazz;
            } else {
                Class innerType = (Class)clazz.getField("TYPE").get(null);
                if (innerType.isPrimitive()) {
                    primitive = innerType;
                }
            }
            return primitive;
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            return null;
        }
    }

    public static BaseMetadataService loadMetaService(Class<? extends BaseMetadataService> metaServiceClass, ClassLoader metaServiceClassLoader) {
        ClassLoader storeClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(metaServiceClassLoader);
        try {
            Constructor<?>[] constructors = metaServiceClass.getConstructors();
            if (constructors.length <= 0) {
                throw new MetaRuntimeException(MessageFormat.format(LinkisMetadataQueryErrorCodeSummary.NO_CONSTRUCTOR_SERVICE.getErrorDesc(), metaServiceClass.getName()), null);
            }
            List acceptConstructor = Arrays.stream(constructors).filter(constructor -> constructor.getParameterCount() == 0).collect(Collectors.toList());
            if (acceptConstructor.size() > 0) {
                Constructor constructor2 = (Constructor)acceptConstructor.get(0);
                try {
                    BaseMetadataService baseMetadataService = (BaseMetadataService)constructor2.newInstance(new Object[0]);
                    return baseMetadataService;
                }
                catch (Exception e) {
                    throw new MetaRuntimeException(MessageFormat.format(LinkisMetadataQueryErrorCodeSummary.UNABLE_META_SERVICE.getErrorDesc(), metaServiceClass.getName()), (Throwable)e);
                }
            }
            throw new MetaRuntimeException(MessageFormat.format(LinkisMetadataQueryErrorCodeSummary.ILLEGAL_META_SERVICE.getErrorDesc(), metaServiceClass.getName()), null);
        }
        finally {
            Thread.currentThread().setContextClassLoader(storeClassLoader);
        }
    }

    public static String[] searchMetaServiceClassInLoader(URLClassLoader serviceClassLoader) {
        URL[] urlsOfClassLoader = serviceClassLoader.getURLs();
        ArrayList<String> classNameList = new ArrayList<String>();
        for (URL url : urlsOfClassLoader) {
            String pathForUrl = url.getPath();
            List<String> searchResult = MetadataUtils.searchMetaServiceClassFormURI(pathForUrl, className -> MetadataUtils.isSubMetaServiceClass(className, serviceClassLoader));
            if (!Objects.nonNull(searchResult)) continue;
            classNameList.addAll(searchResult);
        }
        return classNameList.toArray(new String[0]);
    }

    public static Class<? extends BaseMetadataService> loadMetaServiceClass(ClassLoader classLoader, String className, boolean initialize, String notFoundMessage) {
        try {
            return Class.forName(className, initialize, classLoader).asSubclass(BaseMetadataService.class);
        }
        catch (ClassNotFoundException ne) {
            LOG.warn(notFoundMessage);
            return null;
        }
    }

    private static List<String> searchMetaServiceClassFormURI(String url, Function<String, Boolean> acceptedFunction) {
        ArrayList<String> classNameList = new ArrayList<String>();
        if (url.endsWith(CLASS_SUF_NAME)) {
            String className = url.substring(0, url.lastIndexOf(CLASS_SUF_NAME));
            int splitIndex = className.lastIndexOf(IOUtils.DIR_SEPARATOR);
            if (splitIndex >= 0) {
                className = className.substring(splitIndex);
            }
            if (acceptedFunction.apply(className).booleanValue()) {
                classNameList.add(className);
            }
        } else if (url.endsWith(JAR_SUF_NAME)) {
            try {
                JarFile jarFile = new JarFile(new File(url));
                Enumeration<JarEntry> en = jarFile.entries();
                while (en.hasMoreElements()) {
                    String name = en.nextElement().getName();
                    if (!name.endsWith(CLASS_SUF_NAME)) continue;
                    String className = name.substring(0, name.lastIndexOf(CLASS_SUF_NAME));
                    if (!acceptedFunction.apply(className = className.replaceAll(String.valueOf('/'), ".")).booleanValue()) continue;
                    classNameList.add(className);
                }
            }
            catch (IOException e) {
                LOG.trace("Fail to parse jar file:[" + url + "] in service classpath", (Throwable)e);
                return classNameList;
            }
        }
        return classNameList;
    }

    private static boolean isSubMetaServiceClass(String className, ClassLoader serviceClassLoader) {
        Class<?> clazz;
        if (StringUtils.isEmpty((CharSequence)className)) {
            return false;
        }
        try {
            clazz = Class.forName(className, false, serviceClassLoader);
            if (Modifier.isAbstract(clazz.getModifiers()) || Modifier.isInterface(clazz.getModifiers())) {
                return false;
            }
        }
        catch (Throwable t) {
            LOG.trace("Class: {} can not be found", (Object)className, (Object)t);
            return false;
        }
        return BaseMetadataService.class.isAssignableFrom(clazz);
    }
}

