/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.datasourcemanager.core.service.impl;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Map;
import org.apache.linkis.common.exception.ErrorException;
import org.apache.linkis.common.exception.WarnException;
import org.apache.linkis.datasourcemanager.common.errorcode.LinkisDatasourceManagerErrorCodeSummary;
import org.apache.linkis.datasourcemanager.core.formdata.FormStreamContent;
import org.apache.linkis.datasourcemanager.core.service.BmlAppService;
import org.apache.linkis.datasourcemanager.core.service.MetadataOperateService;
import org.apache.linkis.metadata.query.common.protocol.MetadataConnect;
import org.apache.linkis.metadata.query.common.protocol.MetadataResponse;
import org.apache.linkis.rpc.Sender;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MetadataOperateServiceImpl
implements MetadataOperateService {
    private static final Logger LOG = LoggerFactory.getLogger(MetadataOperateService.class);
    @Autowired
    private BmlAppService bmlAppService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doRemoteConnect(String mdRemoteServiceName, String dataSourceType, String operator, Map<String, Object> connectParams) throws WarnException {
        block9: {
            ArrayList uploadedResources = new ArrayList();
            try {
                connectParams.entrySet().removeIf(entry -> {
                    Object paramValue = entry.getValue();
                    if (paramValue instanceof FormStreamContent) {
                        FormStreamContent streamContent = (FormStreamContent)paramValue;
                        String fileName = streamContent.getFileName();
                        InputStream inputStream = streamContent.getStream();
                        if (null != inputStream) {
                            try {
                                String resourceId = this.bmlAppService.clientUploadResource(operator, fileName, inputStream);
                                if (null == resourceId) {
                                    return true;
                                }
                                uploadedResources.add(resourceId);
                                entry.setValue(resourceId);
                            }
                            catch (ErrorException e) {
                                throw new WarnException(LinkisDatasourceManagerErrorCodeSummary.OPERATE_FILE_IN_REQUEST.getErrorCode(), LinkisDatasourceManagerErrorCodeSummary.OPERATE_FILE_IN_REQUEST.getErrorDesc());
                            }
                        }
                    }
                    return false;
                });
                LOG.info("Send request to metadata service:[" + mdRemoteServiceName + "] for building a connection");
                Sender sender = Sender.getSender((String)mdRemoteServiceName);
                try {
                    Object object = sender.ask((Object)new MetadataConnect(dataSourceType, operator, connectParams, ""));
                    if (object instanceof MetadataResponse) {
                        MetadataResponse response = (MetadataResponse)object;
                        if (!response.status()) {
                            throw new WarnException(LinkisDatasourceManagerErrorCodeSummary.CONNECTION_FAILED.getErrorCode(), LinkisDatasourceManagerErrorCodeSummary.CONNECTION_FAILED.getErrorDesc() + ", Msg[" + response.data() + "]");
                        }
                        break block9;
                    }
                    throw new WarnException(LinkisDatasourceManagerErrorCodeSummary.REMOTE_SERVICE_ERROR.getErrorCode(), LinkisDatasourceManagerErrorCodeSummary.REMOTE_SERVICE_ERROR.getErrorDesc());
                }
                catch (Exception t) {
                    if (!(t instanceof WarnException)) {
                        throw new WarnException(LinkisDatasourceManagerErrorCodeSummary.REMOTE_SERVICE_ERROR.getErrorCode(), LinkisDatasourceManagerErrorCodeSummary.REMOTE_SERVICE_ERROR.getErrorDesc() + ", message:[" + t.getMessage() + "]");
                    }
                    throw t;
                }
            }
            finally {
                if (!uploadedResources.isEmpty()) {
                    uploadedResources.forEach(resourceId -> {
                        try {
                            this.bmlAppService.clientRemoveResource(operator, (String)resourceId);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    });
                }
            }
        }
    }
}

