/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.engineplugin.spark.datacalc.service.strategy;

import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.linkis.server.BDPJettyServerHelper;

public abstract class DataSourceStrategy {
    public abstract String getJdbcUrl(String var1, Map<String, String> var2, String var3);

    public abstract String defaultDriver();

    public abstract String defaultPort();

    protected String getConnectParams(String paramsStr) {
        if (StringUtils.isBlank((CharSequence)paramsStr)) {
            return "";
        }
        Map paramsMap = (Map)BDPJettyServerHelper.gson().fromJson(paramsStr, Map.class);
        if (paramsMap.isEmpty()) {
            return "";
        }
        String paramsSplitCharacter = this.getParamsSplitCharacter();
        String params = paramsMap.entrySet().stream().map(entry -> (String)entry.getKey() + "=" + entry.getValue()).collect(Collectors.joining(paramsSplitCharacter));
        return this.getParamsStartCharacter() + params;
    }

    protected String getParamsStartCharacter() {
        return "?";
    }

    protected String getParamsSplitCharacter() {
        return "&";
    }
}

