/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql.type;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.AbstractList;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.calcite.linq4j.Ord;
import org.apache.calcite.sql.SqlCallBinding;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlOperandCountRange;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.type.SqlOperandCountRanges;
import org.apache.calcite.sql.type.SqlOperandTypeChecker;
import org.apache.calcite.sql.type.SqlSingleOperandTypeChecker;
import org.apache.calcite.util.Util;

public class CompositeOperandTypeChecker
implements SqlOperandTypeChecker {
    private final SqlOperandCountRange range;
    protected final ImmutableList<? extends SqlOperandTypeChecker> allowedRules;
    protected final Composition composition;
    private final String allowedSignatures;

    CompositeOperandTypeChecker(Composition composition, ImmutableList<? extends SqlOperandTypeChecker> allowedRules, @Nullable String allowedSignatures, @Nullable SqlOperandCountRange range) {
        this.allowedRules = (ImmutableList)Preconditions.checkNotNull(allowedRules);
        this.composition = (Composition)((Object)Preconditions.checkNotNull((Object)((Object)composition)));
        this.allowedSignatures = allowedSignatures;
        this.range = range;
        assert (range != null == (composition == Composition.REPEAT));
        assert (allowedRules.size() + (range == null ? 0 : 1) > 1);
    }

    @Override
    public boolean isOptional(int i) {
        for (SqlOperandTypeChecker allowedRule : this.allowedRules) {
            if (!allowedRule.isOptional(i)) continue;
            return true;
        }
        return false;
    }

    public ImmutableList<? extends SqlOperandTypeChecker> getRules() {
        return this.allowedRules;
    }

    @Override
    public SqlOperandTypeChecker.Consistency getConsistency() {
        return SqlOperandTypeChecker.Consistency.NONE;
    }

    @Override
    public String getAllowedSignatures(SqlOperator op, String opName) {
        if (this.allowedSignatures != null) {
            return this.allowedSignatures;
        }
        if (this.composition == Composition.SEQUENCE) {
            throw new AssertionError((Object)"specify allowedSignatures or override getAllowedSignatures");
        }
        StringBuilder ret = new StringBuilder();
        for (Ord ord : Ord.zip(this.allowedRules)) {
            if (ord.i > 0) {
                ret.append(SqlOperator.NL);
            }
            ret.append(((SqlOperandTypeChecker)ord.e).getAllowedSignatures(op, opName));
            if (this.composition != Composition.AND) continue;
            break;
        }
        return ret.toString();
    }

    @Override
    public SqlOperandCountRange getOperandCountRange() {
        switch (this.composition) {
            case REPEAT: {
                return this.range;
            }
            case SEQUENCE: {
                return SqlOperandCountRanges.of(this.allowedRules.size());
            }
        }
        final AbstractList<SqlOperandCountRange> ranges = new AbstractList<SqlOperandCountRange>(){

            @Override
            public SqlOperandCountRange get(int index) {
                return ((SqlOperandTypeChecker)CompositeOperandTypeChecker.this.allowedRules.get(index)).getOperandCountRange();
            }

            @Override
            public int size() {
                return CompositeOperandTypeChecker.this.allowedRules.size();
            }
        };
        final int min = this.minMin((List<SqlOperandCountRange>)ranges);
        final int max = this.maxMax((List<SqlOperandCountRange>)ranges);
        SqlOperandCountRange composite = new SqlOperandCountRange(){

            @Override
            public boolean isValidCount(int count) {
                switch (CompositeOperandTypeChecker.this.composition) {
                    case AND: {
                        for (SqlOperandCountRange range : ranges) {
                            if (range.isValidCount(count)) continue;
                            return false;
                        }
                        return true;
                    }
                }
                for (SqlOperandCountRange range : ranges) {
                    if (!range.isValidCount(count)) continue;
                    return true;
                }
                return false;
            }

            @Override
            public int getMin() {
                return min;
            }

            @Override
            public int getMax() {
                return max;
            }
        };
        if (max >= 0) {
            for (int i = min; i <= max; ++i) {
                if (composite.isValidCount(i)) continue;
                return composite;
            }
        }
        return min == max ? SqlOperandCountRanges.of(min) : SqlOperandCountRanges.between(min, max);
    }

    private int minMin(List<SqlOperandCountRange> ranges) {
        int min = Integer.MAX_VALUE;
        for (SqlOperandCountRange range : ranges) {
            min = Math.min(min, range.getMax());
        }
        return min;
    }

    private int maxMax(List<SqlOperandCountRange> ranges) {
        int max = Integer.MIN_VALUE;
        for (SqlOperandCountRange range : ranges) {
            if (range.getMax() < 0) {
                if (this.composition != Composition.OR) continue;
                return -1;
            }
            max = Math.max(max, range.getMax());
        }
        return max;
    }

    @Override
    public boolean checkOperandTypes(SqlCallBinding callBinding, boolean throwOnFailure) {
        if (this.check(callBinding)) {
            return true;
        }
        if (!throwOnFailure) {
            return false;
        }
        if (this.composition == Composition.OR) {
            for (SqlOperandTypeChecker allowedRule : this.allowedRules) {
                allowedRule.checkOperandTypes(callBinding, true);
            }
        }
        throw callBinding.newValidationSignatureError();
    }

    private boolean check(SqlCallBinding callBinding) {
        switch (this.composition) {
            case REPEAT: {
                if (!this.range.isValidCount(callBinding.getOperandCount())) {
                    return false;
                }
                for (int operand : Util.range(callBinding.getOperandCount())) {
                    for (SqlOperandTypeChecker rule : this.allowedRules) {
                        if (((SqlSingleOperandTypeChecker)rule).checkSingleOperandType(callBinding, (SqlNode)callBinding.getCall().operand(operand), 0, false)) continue;
                        return false;
                    }
                }
                return true;
            }
            case SEQUENCE: {
                if (callBinding.getOperandCount() != this.allowedRules.size()) {
                    return false;
                }
                for (Ord ord : Ord.zip(this.allowedRules)) {
                    SqlOperandTypeChecker rule = (SqlOperandTypeChecker)ord.e;
                    if (((SqlSingleOperandTypeChecker)rule).checkSingleOperandType(callBinding, (SqlNode)callBinding.getCall().operand(ord.i), 0, false)) continue;
                    return false;
                }
                return true;
            }
            case AND: {
                for (Ord ord : Ord.zip(this.allowedRules)) {
                    SqlOperandTypeChecker rule = (SqlOperandTypeChecker)ord.e;
                    if (rule.checkOperandTypes(callBinding, false)) continue;
                    return false;
                }
                return true;
            }
            case OR: {
                for (Ord ord : Ord.zip(this.allowedRules)) {
                    SqlOperandTypeChecker rule = (SqlOperandTypeChecker)ord.e;
                    if (!rule.checkOperandTypes(callBinding, false)) continue;
                    return true;
                }
                return false;
            }
        }
        throw new AssertionError();
    }

    public static enum Composition {
        AND,
        OR,
        SEQUENCE,
        REPEAT;

    }
}

