/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.eureka.cluster;

import com.netflix.appinfo.ApplicationInfoManager;
import com.netflix.appinfo.InstanceInfo;
import com.netflix.discovery.EurekaClientConfig;
import com.netflix.discovery.endpoint.EndpointUtils;
import com.netflix.eureka.EurekaServerConfig;
import com.netflix.eureka.cluster.PeerEurekaNode;
import com.netflix.eureka.registry.PeerAwareInstanceRegistry;
import com.netflix.eureka.resources.ServerCodecs;
import com.netflix.eureka.transport.JerseyReplicationClient;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class PeerEurekaNodes {
    private static final Logger logger = LoggerFactory.getLogger(PeerEurekaNodes.class);
    protected final PeerAwareInstanceRegistry registry;
    protected final EurekaServerConfig serverConfig;
    protected final EurekaClientConfig clientConfig;
    protected final ServerCodecs serverCodecs;
    private final ApplicationInfoManager applicationInfoManager;
    private volatile List<PeerEurekaNode> peerEurekaNodes = Collections.emptyList();
    private volatile Set<String> peerEurekaNodeUrls = Collections.emptySet();
    private ScheduledExecutorService taskExecutor;

    @Inject
    public PeerEurekaNodes(PeerAwareInstanceRegistry registry, EurekaServerConfig serverConfig, EurekaClientConfig clientConfig, ServerCodecs serverCodecs, ApplicationInfoManager applicationInfoManager) {
        this.registry = registry;
        this.serverConfig = serverConfig;
        this.clientConfig = clientConfig;
        this.serverCodecs = serverCodecs;
        this.applicationInfoManager = applicationInfoManager;
    }

    public List<PeerEurekaNode> getPeerNodesView() {
        return Collections.unmodifiableList(this.peerEurekaNodes);
    }

    public List<PeerEurekaNode> getPeerEurekaNodes() {
        return this.peerEurekaNodes;
    }

    public int getMinNumberOfAvailablePeers() {
        return this.serverConfig.getHealthStatusMinNumberOfAvailablePeers();
    }

    public void start() {
        this.taskExecutor = Executors.newSingleThreadScheduledExecutor(new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread thread = new Thread(r, "Eureka-PeerNodesUpdater");
                thread.setDaemon(true);
                return thread;
            }
        });
        try {
            this.updatePeerEurekaNodes(this.resolvePeerUrls());
            Runnable peersUpdateTask = new Runnable(){

                @Override
                public void run() {
                    try {
                        PeerEurekaNodes.this.updatePeerEurekaNodes(PeerEurekaNodes.this.resolvePeerUrls());
                    }
                    catch (Throwable e) {
                        logger.error("Cannot update the replica Nodes", e);
                    }
                }
            };
            this.taskExecutor.scheduleWithFixedDelay(peersUpdateTask, this.serverConfig.getPeerEurekaNodesUpdateIntervalMs(), this.serverConfig.getPeerEurekaNodesUpdateIntervalMs(), TimeUnit.MILLISECONDS);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        for (PeerEurekaNode node : this.peerEurekaNodes) {
            logger.info("Replica node URL:  {}", (Object)node.getServiceUrl());
        }
    }

    public void shutdown() {
        this.taskExecutor.shutdown();
        List<PeerEurekaNode> toRemove = this.peerEurekaNodes;
        this.peerEurekaNodes = Collections.emptyList();
        this.peerEurekaNodeUrls = Collections.emptySet();
        for (PeerEurekaNode node : toRemove) {
            node.shutDown();
        }
    }

    protected List<String> resolvePeerUrls() {
        InstanceInfo myInfo = this.applicationInfoManager.getInfo();
        String zone = InstanceInfo.getZone((String[])this.clientConfig.getAvailabilityZones(this.clientConfig.getRegion()), (InstanceInfo)myInfo);
        List replicaUrls = EndpointUtils.getDiscoveryServiceUrls((EurekaClientConfig)this.clientConfig, (String)zone, (EndpointUtils.ServiceUrlRandomizer)new EndpointUtils.InstanceInfoBasedUrlRandomizer(myInfo));
        int idx = 0;
        while (idx < replicaUrls.size()) {
            if (this.isThisMyUrl((String)replicaUrls.get(idx))) {
                replicaUrls.remove(idx);
                continue;
            }
            ++idx;
        }
        return replicaUrls;
    }

    protected void updatePeerEurekaNodes(List<String> newPeerUrls) {
        if (newPeerUrls.isEmpty()) {
            logger.warn("The replica size seems to be empty. Check the route 53 DNS Registry");
            return;
        }
        HashSet<String> toShutdown = new HashSet<String>(this.peerEurekaNodeUrls);
        toShutdown.removeAll(newPeerUrls);
        HashSet<String> toAdd = new HashSet<String>(newPeerUrls);
        toAdd.removeAll(this.peerEurekaNodeUrls);
        if (toShutdown.isEmpty() && toAdd.isEmpty()) {
            return;
        }
        ArrayList<PeerEurekaNode> newNodeList = new ArrayList<PeerEurekaNode>(this.peerEurekaNodes);
        if (!toShutdown.isEmpty()) {
            logger.info("Removing no longer available peer nodes {}", toShutdown);
            int i = 0;
            while (i < newNodeList.size()) {
                PeerEurekaNode eurekaNode = (PeerEurekaNode)newNodeList.get(i);
                if (toShutdown.contains(eurekaNode.getServiceUrl())) {
                    newNodeList.remove(i);
                    eurekaNode.shutDown();
                    continue;
                }
                ++i;
            }
        }
        if (!toAdd.isEmpty()) {
            logger.info("Adding new peer nodes {}", toAdd);
            for (String peerUrl : toAdd) {
                newNodeList.add(this.createPeerEurekaNode(peerUrl));
            }
        }
        this.peerEurekaNodes = newNodeList;
        this.peerEurekaNodeUrls = new HashSet<String>(newPeerUrls);
    }

    protected PeerEurekaNode createPeerEurekaNode(String peerEurekaNodeUrl) {
        JerseyReplicationClient replicationClient = JerseyReplicationClient.createReplicationClient(this.serverConfig, this.serverCodecs, peerEurekaNodeUrl);
        String targetHost = PeerEurekaNodes.hostFromUrl(peerEurekaNodeUrl);
        if (targetHost == null) {
            targetHost = "host";
        }
        return new PeerEurekaNode(this.registry, targetHost, peerEurekaNodeUrl, replicationClient, this.serverConfig);
    }

    public static boolean isThisMe(String url) {
        InstanceInfo myInfo = ApplicationInfoManager.getInstance().getInfo();
        String hostName = PeerEurekaNodes.hostFromUrl(url);
        return hostName != null && hostName.equals(myInfo.getHostName());
    }

    public boolean isThisMyUrl(String url) {
        String myUrlConfigured = this.serverConfig.getMyUrl();
        if (myUrlConfigured != null) {
            return myUrlConfigured.equals(url);
        }
        return this.isInstanceURL(url, this.applicationInfoManager.getInfo());
    }

    public boolean isInstanceURL(String url, InstanceInfo instance) {
        String hostName = PeerEurekaNodes.hostFromUrl(url);
        String myInfoComparator = instance.getHostName();
        if (this.clientConfig.getTransportConfig().applicationsResolverUseIp()) {
            myInfoComparator = instance.getIPAddr();
        }
        return hostName != null && hostName.equals(myInfoComparator);
    }

    public static String hostFromUrl(String url) {
        URI uri;
        try {
            uri = new URI(url);
        }
        catch (URISyntaxException e) {
            logger.warn("Cannot parse service URI {}", (Object)url, (Object)e);
            return null;
        }
        return uri.getHost();
    }
}

