/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.manager.am.service.engine;

import com.fasterxml.jackson.databind.JsonNode;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.commons.lang3.StringUtils;
import org.apache.linkis.common.ServiceInstance;
import org.apache.linkis.common.conf.TimeType;
import org.apache.linkis.common.exception.LinkisRetryException;
import org.apache.linkis.common.utils.ByteTimeUtils;
import org.apache.linkis.common.utils.Logging;
import org.apache.linkis.common.utils.Utils$;
import org.apache.linkis.engineplugin.server.service.EngineConnResourceFactoryService;
import org.apache.linkis.governance.common.conf.GovernanceCommonConf$;
import org.apache.linkis.governance.common.utils.JobUtils$;
import org.apache.linkis.manager.am.conf.AMConfiguration;
import org.apache.linkis.manager.am.conf.EngineConnConfigurationService;
import org.apache.linkis.manager.am.exception.AMErrorException;
import org.apache.linkis.manager.am.label.EngineReuseLabelChooser;
import org.apache.linkis.manager.am.label.LabelChecker;
import org.apache.linkis.manager.am.selector.ECAvailableRule$;
import org.apache.linkis.manager.am.selector.NodeSelector;
import org.apache.linkis.manager.am.service.engine.AbstractEngineService;
import org.apache.linkis.manager.am.service.engine.EngineCreateService;
import org.apache.linkis.manager.am.service.engine.EngineStopService;
import org.apache.linkis.manager.am.vo.CanCreateECRes;
import org.apache.linkis.manager.common.entity.enumeration.NodeStatus;
import org.apache.linkis.manager.common.entity.metrics.NodeMetrics;
import org.apache.linkis.manager.common.entity.node.EMNode;
import org.apache.linkis.manager.common.entity.node.EngineNode;
import org.apache.linkis.manager.common.entity.node.Node;
import org.apache.linkis.manager.common.entity.resource.NodeResource;
import org.apache.linkis.manager.common.protocol.engine.EngineCreateRequest;
import org.apache.linkis.manager.common.protocol.engine.EngineStopRequest;
import org.apache.linkis.manager.common.utils.ManagerUtils;
import org.apache.linkis.manager.engineplugin.common.launch.entity.EngineConnBuildRequest;
import org.apache.linkis.manager.engineplugin.common.launch.entity.EngineConnBuildRequestImpl;
import org.apache.linkis.manager.engineplugin.common.launch.entity.EngineConnCreationDesc;
import org.apache.linkis.manager.engineplugin.common.launch.entity.EngineConnCreationDescImpl;
import org.apache.linkis.manager.engineplugin.common.resource.EngineResourceRequest;
import org.apache.linkis.manager.engineplugin.common.resource.TimeoutEngineResourceRequest;
import org.apache.linkis.manager.label.builder.factory.LabelBuilderFactory;
import org.apache.linkis.manager.label.builder.factory.LabelBuilderFactoryContext;
import org.apache.linkis.manager.label.entity.EngineNodeLabel;
import org.apache.linkis.manager.label.entity.Label;
import org.apache.linkis.manager.label.entity.engine.EngineTypeLabel;
import org.apache.linkis.manager.label.entity.node.AliasServiceInstanceLabel;
import org.apache.linkis.manager.label.service.NodeLabelService;
import org.apache.linkis.manager.label.service.UserLabelService;
import org.apache.linkis.manager.label.utils.LabelUtils;
import org.apache.linkis.manager.persistence.NodeMetricManagerPersistence;
import org.apache.linkis.manager.rm.AvailableResource;
import org.apache.linkis.manager.rm.NotEnoughResource;
import org.apache.linkis.manager.rm.ResultResource;
import org.apache.linkis.manager.rm.service.ResourceManager;
import org.apache.linkis.manager.service.common.label.LabelFilter;
import org.apache.linkis.rpc.Sender;
import org.apache.linkis.rpc.message.annotation.Receiver;
import org.apache.linkis.server.BDPJettyServerHelper$;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;

@Service
@ScalaSignature(bytes="\u0006\u0001\r}e\u0001\u0002\u00180\u0001yBQA\u0014\u0001\u0005\u0002=C\u0011\"\u0015\u0001A\u0002\u0003\u0007I\u0011\u0002*\t\u0013e\u0003\u0001\u0019!a\u0001\n\u0013Q\u0006\"C2\u0001\u0001\u0004\u0005\t\u0015)\u0003T\u0011%\t\b\u00011AA\u0002\u0013%!\u000fC\u0005{\u0001\u0001\u0007\t\u0019!C\u0005w\"IQ\u0010\u0001a\u0001\u0002\u0003\u0006Ka\u001d\u0005\u000b\u007f\u0002\u0001\r\u00111A\u0005\n\u0005\u0005\u0001bCA\t\u0001\u0001\u0007\t\u0019!C\u0005\u0003'A1\"a\u0006\u0001\u0001\u0004\u0005\t\u0015)\u0003\u0002\u0004!Y\u00111\u0004\u0001A\u0002\u0003\u0007I\u0011BA\u000f\u0011-\tI\u0004\u0001a\u0001\u0002\u0004%I!a\u000f\t\u0017\u0005}\u0002\u00011A\u0001B\u0003&\u0011q\u0004\u0005\f\u0003\u0007\u0002\u0001\u0019!a\u0001\n\u0013\t)\u0005C\u0006\u0002V\u0001\u0001\r\u00111A\u0005\n\u0005]\u0003bCA.\u0001\u0001\u0007\t\u0011)Q\u0005\u0003\u000fB1\"a\u0018\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002b!Y\u0011\u0011\u000e\u0001A\u0002\u0003\u0007I\u0011BA6\u0011-\ty\u0007\u0001a\u0001\u0002\u0003\u0006K!a\u0019\t\u0017\u0005M\u0004\u00011AA\u0002\u0013%\u0011Q\u000f\u0005\f\u0003\u0007\u0003\u0001\u0019!a\u0001\n\u0013\t)\tC\u0006\u0002\n\u0002\u0001\r\u0011!Q!\n\u0005]\u0004bCAG\u0001\u0001\u0007\t\u0019!C\u0005\u0003\u001fC1\"a)\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002&\"Y\u0011\u0011\u0016\u0001A\u0002\u0003\u0005\u000b\u0015BAI\u0011-\ti\u000b\u0001a\u0001\u0002\u0004%I!a,\t\u0017\u0005u\u0006\u00011AA\u0002\u0013%\u0011q\u0018\u0005\f\u0003\u0007\u0004\u0001\u0019!A!B\u0013\t\t\fC\u0006\u0002H\u0002\u0001\r\u00111A\u0005\n\u0005%\u0007bCAj\u0001\u0001\u0007\t\u0019!C\u0005\u0003+D1\"!7\u0001\u0001\u0004\u0005\t\u0015)\u0003\u0002L\"Y\u0011Q\u001c\u0001A\u0002\u0003\u0007I\u0011BAp\u0011-\t9\u000f\u0001a\u0001\u0002\u0004%I!!;\t\u0017\u00055\b\u00011A\u0001B\u0003&\u0011\u0011\u001d\u0005\n\u0003c\u0004!\u0019!C\u0005\u0003gD\u0001Ba\u0001\u0001A\u0003%\u0011Q\u001f\u0005\b\u0005\u000b\u0001A\u0011\u0001B\u0004\u0011\u001d\u0011I\u0006\u0001C\u0005\u00057BqAa$\u0001\t\u0003\u0012\t\nC\u0004\u0003\u0000\u0002!\ta!\u0001\t\u000f\rE\u0001\u0001\"\u0001\u0004\u0014!91\u0011\t\u0001\u0005\n\r\r\u0003bBB1\u0001\u0011%11\r\u0005\b\u0007g\u0002A\u0011BB;\u0011\u001d\u00199\t\u0001C\u0001\u0007\u0013\u0013!\u0004R3gCVdG/\u00128hS:,7I]3bi\u0016\u001cVM\u001d<jG\u0016T!\u0001M\u0019\u0002\r\u0015tw-\u001b8f\u0015\t\u00114'A\u0004tKJ4\u0018nY3\u000b\u0005Q*\u0014AA1n\u0015\t1t'A\u0004nC:\fw-\u001a:\u000b\u0005aJ\u0014A\u00027j].L7O\u0003\u0002;w\u00051\u0011\r]1dQ\u0016T\u0011\u0001P\u0001\u0004_J<7\u0001A\n\u0005\u0001}\u001ae\t\u0005\u0002A\u00036\tq&\u0003\u0002C_\t)\u0012IY:ue\u0006\u001cG/\u00128hS:,7+\u001a:wS\u000e,\u0007C\u0001!E\u0013\t)uFA\nF]\u001eLg.Z\"sK\u0006$XmU3sm&\u001cW\r\u0005\u0002H\u00196\t\u0001J\u0003\u0002J\u0015\u0006)Q\u000f^5mg*\u00111jN\u0001\u0007G>lWn\u001c8\n\u00055C%a\u0002'pO\u001eLgnZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003A\u0003\"\u0001\u0011\u0001\u0002\u00199|G-Z*fY\u0016\u001cGo\u001c:\u0016\u0003M\u0003\"\u0001V,\u000e\u0003US!AV\u001a\u0002\u0011M,G.Z2u_JL!\u0001W+\u0003\u00199{G-Z*fY\u0016\u001cGo\u001c:\u0002!9|G-Z*fY\u0016\u001cGo\u001c:`I\u0015\fHCA.b!\tav,D\u0001^\u0015\u0005q\u0016!B:dC2\f\u0017B\u00011^\u0005\u0011)f.\u001b;\t\u000f\t\u001c\u0011\u0011!a\u0001'\u0006\u0019\u0001\u0010J\u0019\u0002\u001b9|G-Z*fY\u0016\u001cGo\u001c:!Q\t!Q\r\u0005\u0002g_6\tqM\u0003\u0002iS\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\u000b\u0005)\\\u0017a\u00024bGR|'/\u001f\u0006\u0003Y6\fQAY3b]NT!A\\\u001e\u0002\u001fM\u0004(/\u001b8hMJ\fW.Z<pe.L!\u0001]4\u0003\u0013\u0005+Ho\\<je\u0016$\u0017\u0001\u00058pI\u0016d\u0015MY3m'\u0016\u0014h/[2f+\u0005\u0019\bC\u0001;y\u001b\u0005)(B\u0001\u001aw\u0015\t9X'A\u0003mC\n,G.\u0003\u0002zk\n\u0001bj\u001c3f\u0019\u0006\u0014W\r\\*feZL7-Z\u0001\u0015]>$W\rT1cK2\u001cVM\u001d<jG\u0016|F%Z9\u0015\u0005mc\bb\u00022\u0007\u0003\u0003\u0005\ra]\u0001\u0012]>$W\rT1cK2\u001cVM\u001d<jG\u0016\u0004\u0003FA\u0004f\u0003=\u0011Xm]8ve\u000e,W*\u00198bO\u0016\u0014XCAA\u0002!\u0011\t)!!\u0004\u000e\u0005\u0005\u001d!b\u0001\u001a\u0002\n)\u0019\u00111B\u001b\u0002\u0005Il\u0017\u0002BA\b\u0003\u000f\u0011qBU3t_V\u00148-Z'b]\u0006<WM]\u0001\u0014e\u0016\u001cx.\u001e:dK6\u000bg.Y4fe~#S-\u001d\u000b\u00047\u0006U\u0001\u0002\u00032\n\u0003\u0003\u0005\r!a\u0001\u0002!I,7o\\;sG\u0016l\u0015M\\1hKJ\u0004\u0003F\u0001\u0006f\u0003Aa\u0017MY3m\u0007\",7m[3s\u0019&\u001cH/\u0006\u0002\u0002 A1\u0011\u0011EA\u0016\u0003_i!!a\t\u000b\t\u0005\u0015\u0012qE\u0001\u0005kRLGN\u0003\u0002\u0002*\u0005!!.\u0019<b\u0013\u0011\ti#a\t\u0003\t1K7\u000f\u001e\t\u0005\u0003c\t)$\u0004\u0002\u00024)\u0011qoM\u0005\u0005\u0003o\t\u0019D\u0001\u0007MC\n,Gn\u00115fG.,'/\u0001\u000bmC\n,Gn\u00115fG.,'\u000fT5ti~#S-\u001d\u000b\u00047\u0006u\u0002\u0002\u00032\r\u0003\u0003\u0005\r!a\b\u0002#1\f'-\u001a7DQ\u0016\u001c7.\u001a:MSN$\b\u0005\u000b\u0002\u000eK\u0006YA.\u00192fY\u001aKG\u000e^3s+\t\t9\u0005\u0005\u0003\u0002J\u0005ESBAA&\u0015\r9\u0018Q\n\u0006\u0004\u0017\u0006=#B\u0001\u001a6\u0013\u0011\t\u0019&a\u0013\u0003\u00171\u000b'-\u001a7GS2$XM]\u0001\u0010Y\u0006\u0014W\r\u001c$jYR,'o\u0018\u0013fcR\u00191,!\u0017\t\u0011\t|\u0011\u0011!a\u0001\u0003\u000f\nA\u0002\\1cK24\u0015\u000e\u001c;fe\u0002B#\u0001E3\u0002!U\u001cXM\u001d'bE\u0016d7+\u001a:wS\u000e,WCAA2!\r!\u0018QM\u0005\u0004\u0003O*(\u0001E+tKJd\u0015MY3m'\u0016\u0014h/[2f\u0003Q)8/\u001a:MC\n,GnU3sm&\u001cWm\u0018\u0013fcR\u00191,!\u001c\t\u0011\t\u0014\u0012\u0011!a\u0001\u0003G\n\u0011#^:fe2\u000b'-\u001a7TKJ4\u0018nY3!Q\t\u0019R-\u0001\u0010f]\u001eLg.Z\"p]:\u001cuN\u001c4jOV\u0014\u0018\r^5p]N+'O^5dKV\u0011\u0011q\u000f\t\u0005\u0003s\ny(\u0004\u0002\u0002|)\u0019\u0011QP\u001a\u0002\t\r|gNZ\u0005\u0005\u0003\u0003\u000bYH\u0001\u0010F]\u001eLg.Z\"p]:\u001cuN\u001c4jOV\u0014\u0018\r^5p]N+'O^5dK\u0006\u0011SM\\4j]\u0016\u001cuN\u001c8D_:4\u0017nZ;sCRLwN\\*feZL7-Z0%KF$2aWAD\u0011!\u0011W#!AA\u0002\u0005]\u0014aH3oO&tWmQ8o]\u000e{gNZ5hkJ\fG/[8o'\u0016\u0014h/[2fA!\u0012a#Z\u0001!K:<\u0017N\\3D_:t'+Z:pkJ\u001cWMR1di>\u0014\u0018pU3sm&\u001cW-\u0006\u0002\u0002\u0012B!\u00111SAP\u001b\t\t)JC\u00023\u0003/SA!!'\u0002\u001c\u000611/\u001a:wKJT1!!(8\u00031)gnZ5oKBdWoZ5o\u0013\u0011\t\t+!&\u0003A\u0015sw-\u001b8f\u0007>tgNU3t_V\u00148-\u001a$bGR|'/_*feZL7-Z\u0001%K:<\u0017N\\3D_:t'+Z:pkJ\u001cWMR1di>\u0014\u0018pU3sm&\u001cWm\u0018\u0013fcR\u00191,a*\t\u0011\tD\u0012\u0011!a\u0001\u0003#\u000b\u0011%\u001a8hS:,7i\u001c8o%\u0016\u001cx.\u001e:dK\u001a\u000b7\r^8ssN+'O^5dK\u0002B#!G3\u000299|G-Z'fiJL7-T1oC\u001e,'\u000fU3sg&\u001cH/\u001a8dKV\u0011\u0011\u0011\u0017\t\u0005\u0003g\u000bI,\u0004\u0002\u00026*\u0019\u0011qW\u001b\u0002\u0017A,'o]5ti\u0016t7-Z\u0005\u0005\u0003w\u000b)L\u0001\u000fO_\u0012,W*\u001a;sS\u000el\u0015M\\1hKJ\u0004VM]:jgR,gnY3\u0002A9|G-Z'fiJL7-T1oC\u001e,'\u000fU3sg&\u001cH/\u001a8dK~#S-\u001d\u000b\u00047\u0006\u0005\u0007\u0002\u00032\u001c\u0003\u0003\u0005\r!!-\u0002;9|G-Z'fiJL7-T1oC\u001e,'\u000fU3sg&\u001cH/\u001a8dK\u0002B#\u0001H3\u00021\u0015tw-\u001b8f%\u0016,8/\u001a'bE\u0016d7\t[8pg\u0016\u00148/\u0006\u0002\u0002LB1\u0011\u0011EA\u0016\u0003\u001b\u0004B!!\r\u0002P&!\u0011\u0011[A\u001a\u0005])enZ5oKJ+Wo]3MC\n,Gn\u00115p_N,'/\u0001\u000ff]\u001eLg.\u001a*fkN,G*\u00192fY\u000eCwn\\:feN|F%Z9\u0015\u0007m\u000b9\u000e\u0003\u0005c=\u0005\u0005\t\u0019AAf\u0003e)gnZ5oKJ+Wo]3MC\n,Gn\u00115p_N,'o\u001d\u0011)\u0005})\u0017!E3oO&tWm\u0015;paN+'O^5dKV\u0011\u0011\u0011\u001d\t\u0004\u0001\u0006\r\u0018bAAs_\t\tRI\\4j]\u0016\u001cFo\u001c9TKJ4\u0018nY3\u0002+\u0015tw-\u001b8f'R|\u0007oU3sm&\u001cWm\u0018\u0013fcR\u00191,a;\t\u0011\t\f\u0013\u0011!a\u0001\u0003C\f!#\u001a8hS:,7\u000b^8q'\u0016\u0014h/[2fA!\u0012!%Z\u0001\u0014Y\u0006\u0014W\r\u001c\"vS2$WM\u001d$bGR|'/_\u000b\u0003\u0003k\u0004B!a>\u0002\u00006\u0011\u0011\u0011 \u0006\u0004U\u0006m(bAA\u007fm\u00069!-^5mI\u0016\u0014\u0018\u0002\u0002B\u0001\u0003s\u00141\u0003T1cK2\u0014U/\u001b7eKJ4\u0015m\u0019;pef\fA\u0003\\1cK2\u0014U/\u001b7eKJ4\u0015m\u0019;pef\u0004\u0013A\u00032vS2$G*\u00192fYR1!\u0011\u0002B\u0018\u0005+\u0002b!!\t\u0002,\t-\u0001\u0007\u0002B\u0007\u0005;\u0001bAa\u0004\u0003\u0016\teQB\u0001B\t\u0015\r\u0011\u0019B^\u0001\u0007K:$\u0018\u000e^=\n\t\t]!\u0011\u0003\u0002\u0006\u0019\u0006\u0014W\r\u001c\t\u0005\u00057\u0011i\u0002\u0004\u0001\u0005\u0017\t}Q%!A\u0001\u0002\u000b\u0005!\u0011\u0005\u0002\u0004?\u0012\n\u0014\u0003\u0002B\u0012\u0005S\u00012\u0001\u0018B\u0013\u0013\r\u00119#\u0018\u0002\b\u001d>$\b.\u001b8h!\ra&1F\u0005\u0004\u0005[i&aA!os\"9!\u0011G\u0013A\u0002\tM\u0012A\u00027bE\u0016d7\u000f\u0005\u0005\u0002\"\tU\"\u0011\bB(\u0013\u0011\u00119$a\t\u0003\u00075\u000b\u0007\u000f\u0005\u0003\u0003<\t%c\u0002\u0002B\u001f\u0005\u000b\u00022Aa\u0010^\u001b\t\u0011\tEC\u0002\u0003Du\na\u0001\u0010:p_Rt\u0014b\u0001B$;\u00061\u0001K]3eK\u001aLAAa\u0013\u0003N\t11\u000b\u001e:j]\u001eT1Aa\u0012^!\ra&\u0011K\u0005\u0004\u0005'j&AB!osJ+g\rC\u0004\u0003X\u0015\u0002\rA!\u000f\u0002\tU\u001cXM]\u0001\ng\u0016dWm\u0019;F\u00076#bA!\u0018\u0003n\t}\u0004\u0003\u0002B0\u0005Sj!A!\u0019\u000b\t\t\r$QM\u0001\u0005]>$WM\u0003\u0003\u0003\u0014\t\u001d$BA&6\u0013\u0011\u0011YG!\u0019\u0003\r\u0015kej\u001c3f\u0011\u001d\u0011yG\na\u0001\u0005c\n1#\u001a8hS:,7I]3bi\u0016\u0014V-];fgR\u0004BAa\u001d\u0003|5\u0011!Q\u000f\u0006\u0004a\t]$\u0002\u0002B=\u0005O\n\u0001\u0002\u001d:pi>\u001cw\u000e\\\u0005\u0005\u0005{\u0012)HA\nF]\u001eLg.Z\"sK\u0006$XMU3rk\u0016\u001cH\u000fC\u0004\u0003\u0002\u001a\u0002\rAa!\u0002\u00131\f'-\u001a7MSN$\bCBA\u0011\u0003W\u0011)\t\r\u0003\u0003\b\n-\u0005C\u0002B\b\u0005+\u0011I\t\u0005\u0003\u0003\u001c\t-E\u0001\u0004BG\u0005\u007f\n\t\u0011!A\u0003\u0002\t\u0005\"aA0%g\u0005a1M]3bi\u0016,enZ5oKR1!1\u0013BM\u00057\u0003BAa\u0018\u0003\u0016&!!q\u0013B1\u0005))enZ5oK:{G-\u001a\u0005\b\u0005_:\u0003\u0019\u0001B9\u0011\u001d\u0011ij\na\u0001\u0005?\u000baa]3oI\u0016\u0014\b\u0003\u0002BQ\u0005Ok!Aa)\u000b\u0007\t\u0015v'A\u0002sa\u000eLAA!+\u0003$\n11+\u001a8eKJDSa\nBW\u0005\u007f\u0003R\u0001\u0018BX\u0005gK1A!-^\u0005\u0019!\bN]8xgB!!Q\u0017B^\u001b\t\u00119LC\u0002\u0003:*\u000b\u0011\"\u001a=dKB$\u0018n\u001c8\n\t\tu&q\u0017\u0002\u0015\u0019&t7.[:SKR\u0014\u00180\u0012=dKB$\u0018n\u001c82\u000fy\u0011ID!1\u0003nFJ1Ea1\u0003L\n\r(QZ\u000b\u0005\u0005\u000b\u00149-\u0006\u0002\u0003:\u00119!\u0011Z\u001fC\u0002\tM'!\u0001+\n\t\t5'qZ\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000fJ\u0019\u000b\u0007\tEW,\u0001\u0004uQJ|wo]\t\u0005\u0005G\u0011)\u000e\u0005\u0003\u0003X\nugb\u0001/\u0003Z&\u0019!1\\/\u0002\u000fA\f7m[1hK&!!q\u001cBq\u0005%!\u0006N]8xC\ndWMC\u0002\u0003\\v\u000b\u0014b\tBs\u0005O\u0014IO!5\u000f\u0007q\u00139/C\u0002\u0003Rv\u000bTA\t/^\u0005W\u0014Qa]2bY\u0006\f4A\nBZQ\r9#\u0011\u001f\t\u0005\u0005g\u0014Y0\u0004\u0002\u0003v*\u0019\u0001Na>\u000b\t\te(1U\u0001\b[\u0016\u001c8/Y4f\u0013\u0011\u0011iP!>\u0003\u0011I+7-Z5wKJ\f1bY1o\u0007J,\u0017\r^3F\u0007R!11AB\b!\u0011\u0019)aa\u0003\u000e\u0005\r\u001d!bAB\u0005g\u0005\u0011ao\\\u0005\u0005\u0007\u001b\u00199A\u0001\bDC:\u001c%/Z1uK\u0016\u001b%+Z:\t\u000f\t=\u0004\u00061\u0001\u0003r\u0005\u0001r-\u001a8fe\u0006$XMU3t_V\u00148-\u001a\u000b\u000b\u0007+\u0019\tca\n\u0004*\r]\u0002\u0003BB\f\u0007;i!a!\u0007\u000b\t\rm!QM\u0001\te\u0016\u001cx.\u001e:dK&!1qDB\r\u00051qu\u000eZ3SKN|WO]2f\u0011\u001d\u0019\u0019#\u000ba\u0001\u0007K\tQ\u0001\u001d:paN\u0004\u0002\"!\t\u00036\te\"\u0011\b\u0005\b\u0005/J\u0003\u0019\u0001B\u001d\u0011\u001d\u0011\t)\u000ba\u0001\u0007W\u0001b!!\t\u0002,\r5\u0002\u0007BB\u0018\u0007g\u0001bAa\u0004\u0003\u0016\rE\u0002\u0003\u0002B\u000e\u0007g!Ab!\u000e\u0004*\u0005\u0005\t\u0011!B\u0001\u0005C\u00111a\u0018\u00136\u0011\u001d\u0019I$\u000ba\u0001\u0007w\tq\u0001^5nK>,H\u000fE\u0002]\u0007{I1aa\u0010^\u0005\u0011auN\\4\u0002+\u0019\u0014x.\\#N\u000f\u0016$XI\\4j]\u0016d\u0015MY3mgR!1QIB)!\u0019\t\t#a\u000b\u0004HA\"1\u0011JB'!\u0019\u0011yA!\u0006\u0004LA!!1DB'\t-\u0019yEKA\u0001\u0002\u0003\u0015\tA!\t\u0003\u0007}#s\u0007C\u0004\u0004T)\u0002\ra!\u0016\u0002\u0011\u0015lG*\u00192fYN\u0004b!!\t\u0002,\r]\u0003\u0007BB-\u0007;\u0002bAa\u0004\u0003\u0016\rm\u0003\u0003\u0002B\u000e\u0007;\"Aba\u0018\u0004R\u0005\u0005\t\u0011!B\u0001\u0005C\u00111a\u0018\u00137\u0003-)gn];sKNLE\r\\3\u0015\r\r\u001541NB8!\ra6qM\u0005\u0004\u0007Sj&a\u0002\"p_2,\u0017M\u001c\u0005\b\u0007[Z\u0003\u0019\u0001BJ\u0003))gnZ5oK:{G-\u001a\u0005\b\u0007cZ\u0003\u0019\u0001B\u001d\u0003A\u0011Xm]8ve\u000e,G+[2lKRLE-A\thKR\u001cF/\u0019:u\u000bJ\u0014xN]%oM>$Baa\u001e\u0004\u0004B9Al!\u001f\u0003:\ru\u0014bAB>;\n1A+\u001e9mKJ\u0002R\u0001XB@\u0007KJ1a!!^\u0005\u0019y\u0005\u000f^5p]\"91Q\u0011\u0017A\u0002\te\u0012aA7tO\u0006\tRM\\:ve\u0016,5)\u0011<bS2\f'\r\\3\u0015\u0011\tM51RBG\u0007\u001fCqa!\u001c.\u0001\u0004\u0011\u0019\nC\u0004\u0004r5\u0002\rA!\u000f\t\u000f\reR\u00061\u0001\u0004<!\u001a\u0001aa%\u0011\t\rU51T\u0007\u0003\u0007/S1a!'n\u0003)\u0019H/\u001a:f_RL\b/Z\u0005\u0005\u0007;\u001b9JA\u0004TKJ4\u0018nY3")
public class DefaultEngineCreateService
extends AbstractEngineService
implements EngineCreateService,
Logging {
    @Autowired
    private NodeSelector nodeSelector;
    @Autowired
    private NodeLabelService nodeLabelService;
    @Autowired
    private ResourceManager resourceManager;
    @Autowired
    private List<LabelChecker> labelCheckerList;
    @Autowired
    private LabelFilter labelFilter;
    @Autowired
    private UserLabelService userLabelService;
    @Autowired
    private EngineConnConfigurationService engineConnConfigurationService;
    @Autowired
    private EngineConnResourceFactoryService engineConnResourceFactoryService;
    @Autowired
    private NodeMetricManagerPersistence nodeMetricManagerPersistence;
    @Autowired
    private List<EngineReuseLabelChooser> engineReuseLabelChoosers;
    @Autowired
    private EngineStopService engineStopService;
    private final LabelBuilderFactory labelBuilderFactory;
    private Logger logger;
    private volatile boolean bitmap$0;

    public void trace(Function0<String> message) {
        Logging.trace$((Logging)this, message);
    }

    public void debug(Function0<String> message) {
        Logging.debug$((Logging)this, message);
    }

    public void info(Function0<String> message) {
        Logging.info$((Logging)this, message);
    }

    public void info(Function0<String> message, Throwable t) {
        Logging.info$((Logging)this, message, (Throwable)t);
    }

    public void warn(Function0<String> message) {
        Logging.warn$((Logging)this, message);
    }

    public void warn(Function0<String> message, Throwable t) {
        Logging.warn$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message, Throwable t) {
        Logging.error$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message) {
        Logging.error$((Logging)this, message);
    }

    private Logger logger$lzycompute() {
        DefaultEngineCreateService defaultEngineCreateService = this;
        synchronized (defaultEngineCreateService) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    private NodeSelector nodeSelector() {
        return this.nodeSelector;
    }

    private void nodeSelector_$eq(NodeSelector x$1) {
        this.nodeSelector = x$1;
    }

    private NodeLabelService nodeLabelService() {
        return this.nodeLabelService;
    }

    private void nodeLabelService_$eq(NodeLabelService x$1) {
        this.nodeLabelService = x$1;
    }

    private ResourceManager resourceManager() {
        return this.resourceManager;
    }

    private void resourceManager_$eq(ResourceManager x$1) {
        this.resourceManager = x$1;
    }

    private List<LabelChecker> labelCheckerList() {
        return this.labelCheckerList;
    }

    private void labelCheckerList_$eq(List<LabelChecker> x$1) {
        this.labelCheckerList = x$1;
    }

    private LabelFilter labelFilter() {
        return this.labelFilter;
    }

    private void labelFilter_$eq(LabelFilter x$1) {
        this.labelFilter = x$1;
    }

    private UserLabelService userLabelService() {
        return this.userLabelService;
    }

    private void userLabelService_$eq(UserLabelService x$1) {
        this.userLabelService = x$1;
    }

    private EngineConnConfigurationService engineConnConfigurationService() {
        return this.engineConnConfigurationService;
    }

    private void engineConnConfigurationService_$eq(EngineConnConfigurationService x$1) {
        this.engineConnConfigurationService = x$1;
    }

    private EngineConnResourceFactoryService engineConnResourceFactoryService() {
        return this.engineConnResourceFactoryService;
    }

    private void engineConnResourceFactoryService_$eq(EngineConnResourceFactoryService x$1) {
        this.engineConnResourceFactoryService = x$1;
    }

    private NodeMetricManagerPersistence nodeMetricManagerPersistence() {
        return this.nodeMetricManagerPersistence;
    }

    private void nodeMetricManagerPersistence_$eq(NodeMetricManagerPersistence x$1) {
        this.nodeMetricManagerPersistence = x$1;
    }

    private List<EngineReuseLabelChooser> engineReuseLabelChoosers() {
        return this.engineReuseLabelChoosers;
    }

    private void engineReuseLabelChoosers_$eq(List<EngineReuseLabelChooser> x$1) {
        this.engineReuseLabelChoosers = x$1;
    }

    private EngineStopService engineStopService() {
        return this.engineStopService;
    }

    private void engineStopService_$eq(EngineStopService x$1) {
        this.engineStopService = x$1;
    }

    private LabelBuilderFactory labelBuilderFactory() {
        return this.labelBuilderFactory;
    }

    public List<Label<?>> buildLabel(Map<String, Object> labels, String user) {
        ObjectRef labelList = ObjectRef.create((Object)LabelUtils.distinctLabel((List)this.labelBuilderFactory().getLabels(labels), this.userLabelService().getUserLabels(user)));
        if (this.engineReuseLabelChoosers() != null) {
            ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.engineReuseLabelChoosers()).asScala()).foreach((Function1 & Serializable & scala.Serializable)chooser -> {
                labelList.elem = chooser.chooseLabels((List)labelList.elem);
                return BoxedUnit.UNIT;
            });
        }
        ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.labelCheckerList()).asScala()).foreach((Function1 & Serializable & scala.Serializable)labelChecker -> {
            DefaultEngineCreateService.$anonfun$buildLabel$2(labelList, labelChecker);
            return BoxedUnit.UNIT;
        });
        return (List)labelList.elem;
    }

    private EMNode selectECM(EngineCreateRequest engineCreateRequest, List<Label<?>> labelList) {
        ArrayList emLabelList = new ArrayList(labelList);
        AliasServiceInstanceLabel emInstanceLabel = (AliasServiceInstanceLabel)this.labelBuilderFactory().createLabel(AliasServiceInstanceLabel.class);
        emInstanceLabel.setAlias((String)GovernanceCommonConf$.MODULE$.ENGINE_CONN_MANAGER_SPRING_NAME().getValue());
        emLabelList.add((Label<?>)emInstanceLabel);
        EMNode[] emScoreNodeList = this.getEMService().getEMNodes((List)JavaConverters$.MODULE$.bufferAsJavaListConverter((Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(emLabelList).asScala()).filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)DefaultEngineCreateService.$anonfun$selectECM$1(x$1)))).asJava());
        if (emScoreNodeList == null || new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])emScoreNodeList)).isEmpty()) {
            throw new LinkisRetryException(30002, new StringBuilder(28).append(" The em of labels ").append(engineCreateRequest.getLabels()).append(" not found").toString());
        }
        this.logger().info(new StringBuilder(21).append("Suitable ems size is ").append(emScoreNodeList.length).toString());
        Option<Node> choseNode = this.nodeSelector().choseNode((Node[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])emScoreNodeList)).toArray(ClassTag$.MODULE$.apply(Node.class)));
        if (choseNode == null || choseNode.isEmpty()) {
            throw new LinkisRetryException(30002, new StringBuilder(73).append(" There are corresponding ECM tenant labels ").append(engineCreateRequest.getLabels()).append(", but none of them are healthy").toString());
        }
        return (EMNode)choseNode.get();
    }

    @Override
    @Receiver
    public EngineNode createEngine(EngineCreateRequest engineCreateRequest, Sender sender) throws LinkisRetryException {
        long startTime = System.currentTimeMillis();
        String taskId = JobUtils$.MODULE$.getJobIdFromStringMap(engineCreateRequest.getProperties());
        this.logger().info(new StringBuilder(44).append("Task: ").append(taskId).append(" start to create Engine for request: ").append(engineCreateRequest).append(".").toString());
        long timeout = engineCreateRequest.getTimeout() <= 0L ? ((TimeType)AMConfiguration.ENGINE_START_MAX_TIME.getValue()).toLong() : engineCreateRequest.getTimeout();
        List<Label<?>> labelList = this.buildLabel(engineCreateRequest.getLabels(), engineCreateRequest.getUser());
        EMNode emNode = this.selectECM(engineCreateRequest, labelList);
        if (engineCreateRequest.getProperties() == null) {
            engineCreateRequest.setProperties(new HashMap());
        }
        NodeResource resource = this.generateResource(engineCreateRequest.getProperties(), engineCreateRequest.getUser(), this.labelFilter().choseEngineLabel(labelList), timeout);
        ResultResource resultResource = this.resourceManager().requestResource(LabelUtils.distinctLabel(labelList, (List)emNode.getLabels()), resource, engineCreateRequest, timeout);
        if (!(resultResource instanceof AvailableResource)) {
            if (resultResource instanceof NotEnoughResource) {
                NotEnoughResource notEnoughResource = (NotEnoughResource)resultResource;
                String reason = notEnoughResource.reason();
                this.logger().warn(new StringBuilder(21).append("not enough resource: ").append(reason).toString());
                throw new LinkisRetryException(30002, new StringBuilder(23).append("not enough resource: : ").append(reason).toString());
            }
            throw new MatchError((Object)resultResource);
        }
        AvailableResource availableResource = (AvailableResource)resultResource;
        String ticketId = availableResource.ticketId();
        String resourceTicketId = ticketId;
        EngineConnBuildRequestImpl engineBuildRequest = new EngineConnBuildRequestImpl(resourceTicketId, this.labelFilter().choseEngineLabel(labelList), resource, (EngineConnCreationDesc)new EngineConnCreationDescImpl(engineCreateRequest.getCreateService(), engineCreateRequest.getDescription(), engineCreateRequest.getProperties()));
        ServiceInstance oldServiceInstance = new ServiceInstance();
        oldServiceInstance.setApplicationName((String)GovernanceCommonConf$.MODULE$.ENGINE_CONN_SPRING_NAME().getValue());
        oldServiceInstance.setInstance(resourceTicketId);
        EngineNode engineNode = (EngineNode)Utils$.MODULE$.tryCatch((Function0 & Serializable & scala.Serializable)() -> this.getEMService().createEngine((EngineConnBuildRequest)engineBuildRequest, emNode), (Function1 & Serializable & scala.Serializable)x0$1 -> {
            Throwable throwable = x0$1;
            if (throwable != null) {
                Throwable throwable2 = throwable;
                this.logger().info(new StringBuilder(30).append("Failed to create ec(").append(resourceTicketId).append(") ask ecm ").append(emNode.getServiceInstance()).toString());
                EngineNode failedEcNode = this.getEngineNodeManager().getEngineNode(oldServiceInstance);
                if (failedEcNode == null) {
                    this.logger().info(new StringBuilder(35).append(" engineConn does not exist in db: ").append(oldServiceInstance).append(" ").toString());
                } else {
                    failedEcNode.setLabels(this.nodeLabelService().getNodeLabels(oldServiceInstance));
                    failedEcNode.getLabels().addAll(LabelUtils.distinctLabel(this.labelFilter().choseEngineLabel(labelList), (List)emNode.getLabels()));
                    failedEcNode.setNodeStatus(NodeStatus.Failed);
                    this.engineStopService().engineConnInfoClear(failedEcNode);
                }
                throw throwable2;
            }
            throw new MatchError((Object)throwable);
        });
        this.logger().info(new StringBuilder(52).append("Task: ").append(taskId).append(" finished to create  engineConn ").append(engineNode).append(". ticketId is ").append(resourceTicketId).toString());
        engineNode.setTicketId(resourceTicketId);
        Utils$.MODULE$.tryCatch((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.getEngineNodeManager().updateEngineNode(oldServiceInstance, engineNode), (Function1 & Serializable & scala.Serializable)t -> {
            this.logger().warn(new StringBuilder(28).append("Failed to update engineNode ").append(engineNode).toString(), t);
            Throwable throwable = t;
            if (throwable instanceof LinkisRetryException) {
                this.logger().warn(new StringBuilder(64).append("node ").append(oldServiceInstance).append(" update failed,caused by retry Exception, do not to stop ec").toString());
            } else {
                EngineStopRequest stopEngineRequest = new EngineStopRequest(engineNode.getServiceInstance(), ManagerUtils.getAdminUser());
                this.engineStopService().asyncStopEngine(stopEngineRequest);
            }
            EngineNode failedEcNode = this.getEngineNodeManager().getEngineNode(oldServiceInstance);
            if (failedEcNode == null) {
                this.logger().info(new StringBuilder(35).append(" engineConn does not exist in db: ").append(oldServiceInstance).append(" ").toString());
            } else {
                failedEcNode.setLabels(this.nodeLabelService().getNodeLabels(oldServiceInstance));
                failedEcNode.getLabels().addAll(LabelUtils.distinctLabel(this.labelFilter().choseEngineLabel(labelList), (List)emNode.getLabels()));
                failedEcNode.setNodeStatus(NodeStatus.Failed);
                this.engineStopService().engineConnInfoClear(failedEcNode);
            }
            throw new LinkisRetryException(30002, new StringBuilder(29).append("Failed to update engineNode: ").append(t.getMessage()).toString());
        });
        AliasServiceInstanceLabel engineConnAliasLabel = (AliasServiceInstanceLabel)this.labelBuilderFactory().createLabel(AliasServiceInstanceLabel.class);
        engineConnAliasLabel.setAlias((String)GovernanceCommonConf$.MODULE$.ENGINE_CONN_SPRING_NAME().getValue());
        labelList.add((Label<?>)engineConnAliasLabel);
        this.nodeLabelService().addLabelsToNode(engineNode.getServiceInstance(), this.labelFilter().choseEngineLabel(LabelUtils.distinctLabel(labelList, this.fromEMGetEngineLabels(emNode.getLabels()))));
        if (System.currentTimeMillis() - startTime >= timeout && engineCreateRequest.isIgnoreTimeout()) {
            this.logger().info(new StringBuilder(104).append("Return a EngineConn ").append(engineNode).append(" for request: ").append(engineCreateRequest).append(" since the creator set ignoreTimeout=true and maxStartTime is reached.").toString());
            return engineNode;
        }
        long leftWaitTime = timeout - (System.currentTimeMillis() - startTime);
        if (ECAvailableRule$.MODULE$.getInstance().isNeedAvailable(labelList)) {
            this.ensureECAvailable(engineNode, resourceTicketId, leftWaitTime);
            this.logger().info(new StringBuilder(81).append("Task: ").append(taskId).append(" finished to create Engine for request: ").append(engineCreateRequest).append(" and get engineNode ").append(engineNode).append(". time taken ").append(System.currentTimeMillis() - startTime).append("ms").toString());
        } else {
            this.logger().info(new StringBuilder(115).append("Task: ").append(taskId).append(" finished to create Engine for request: ").append(engineCreateRequest).append(" and get engineNode ").append(engineNode).append(".And did not judge the availability,time taken ").append(System.currentTimeMillis() - startTime).append("ms").toString());
        }
        return engineNode;
    }

    public CanCreateECRes canCreateEC(EngineCreateRequest engineCreateRequest) {
        List<Label<?>> labelList = this.buildLabel(engineCreateRequest.getLabels(), engineCreateRequest.getUser());
        EMNode emNode = this.selectECM(engineCreateRequest, labelList);
        if (engineCreateRequest.getProperties() == null) {
            engineCreateRequest.setProperties(new HashMap());
        }
        NodeResource resource = this.generateResource(engineCreateRequest.getProperties(), engineCreateRequest.getUser(), this.labelFilter().choseEngineLabel(labelList), ((TimeType)AMConfiguration.ENGINE_START_MAX_TIME.getValue()).toLong());
        return this.resourceManager().canRequestResource(LabelUtils.distinctLabel(labelList, (List)emNode.getLabels()), resource, engineCreateRequest);
    }

    public NodeResource generateResource(Map<String, String> props, String user, List<Label<?>> labelList, long timeout) {
        String crossQueue;
        Map<String, String> configProp = this.engineConnConfigurationService().getConsoleConfiguration(labelList);
        if (configProp != null && ((TraversableOnce)JavaConverters$.MODULE$.mapAsScalaMapConverter(configProp).asScala()).nonEmpty()) {
            ((IterableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(configProp).asScala()).foreach((Function1 & Serializable & scala.Serializable)keyValue -> {
                if (!props.containsKey(keyValue._1())) {
                    return props.put((String)keyValue._1(), (String)keyValue._2());
                }
                return BoxedUnit.UNIT;
            });
        }
        if (StringUtils.isNotBlank((CharSequence)(crossQueue = props.get("crossQueue")))) {
            String queueName = props.getOrDefault("wds.linkis.rm.yarnqueue", "default");
            props.put("wds.linkis.rm.yarnqueue", crossQueue);
            this.logger().info(new StringBuilder(59).append("Switch queues according to queueRule with crossQueue : ").append(queueName).append(" to ").append(crossQueue).toString());
        }
        TimeoutEngineResourceRequest timeoutEngineResourceRequest = new TimeoutEngineResourceRequest(timeout, user, labelList, props);
        return this.engineConnResourceFactoryService().createEngineResource((EngineResourceRequest)timeoutEngineResourceRequest);
    }

    private List<Label<?>> fromEMGetEngineLabels(List<Label<?>> emLabels) {
        return (List)JavaConverters$.MODULE$.bufferAsJavaListConverter((Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(emLabels).asScala()).filter((Function1 & Serializable & scala.Serializable)label -> BoxesRunTime.boxToBoolean((boolean)DefaultEngineCreateService.$anonfun$fromEMGetEngineLabels$1(label)))).asJava();
    }

    private boolean ensuresIdle(EngineNode engineNode, String resourceTicketId) {
        EngineNode engineNodeInfo = (EngineNode)Utils$.MODULE$.tryAndWarnMsg((Function0 & Serializable & scala.Serializable)() -> {
            String string = engineNode.getMark();
            String string2 = "cluster_process";
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                return this.getEngineNodeManager().getEngineNodeInfoByTicketId(resourceTicketId);
            }
            return this.getEngineNodeManager().getEngineNodeInfoByDB(engineNode);
        }, "Failed to from db get engine node info", this.logger());
        if (engineNodeInfo == null) {
            return false;
        }
        if (engineNodeInfo.getServiceInstance() != null) {
            engineNode.setServiceInstance(engineNodeInfo.getServiceInstance());
        }
        if (Predef$.MODULE$.Boolean2boolean(NodeStatus.isCompleted((NodeStatus)engineNodeInfo.getNodeStatus()))) {
            NodeMetrics metrics = this.nodeMetricManagerPersistence().getNodeMetrics((Node)engineNodeInfo);
            String msg = metrics != null ? metrics.getHeartBeatMsg() : null;
            Tuple2<String, Option<Object>> tuple2 = this.getStartErrorInfo(msg);
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            String reason = (String)tuple2._1();
            Option canRetry = (Option)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)reason, (Object)canRetry);
            String reason2 = (String)tuple22._1();
            Option canRetry2 = (Option)tuple22._2();
            if (canRetry2.isDefined()) {
                throw new LinkisRetryException(30001, new StringBuilder(48).append(engineNode.getServiceInstance()).append(" ticketID:").append(resourceTicketId).append(" Failed to initialize engine, reason: ").append(reason2).toString());
            }
            throw new AMErrorException(30002, new StringBuilder(48).append(engineNode.getServiceInstance()).append(" ticketID:").append(resourceTicketId).append(" Failed to initialize engine, reason: ").append(reason2).toString());
        }
        return Predef$.MODULE$.Boolean2boolean(NodeStatus.isAvailable((NodeStatus)engineNodeInfo.getNodeStatus()));
    }

    private Tuple2<String, Option<Object>> getStartErrorInfo(String msg) {
        JsonNode jsonNode;
        if (StringUtils.isNotBlank((CharSequence)msg) && (jsonNode = BDPJettyServerHelper$.MODULE$.jacksonJson().readTree(msg)) != null && jsonNode.has("start_reason")) {
            String startReason = jsonNode.get("start_reason").asText();
            if (jsonNode.has("ec_can_try")) {
                return new Tuple2((Object)startReason, (Object)new Some((Object)BoxesRunTime.boxToBoolean((boolean)true)));
            }
            return new Tuple2((Object)startReason, (Object)None$.MODULE$);
        }
        return new Tuple2(null, (Object)None$.MODULE$);
    }

    public EngineNode ensureECAvailable(EngineNode engineNode, String resourceTicketId, long timeout) {
        Utils$.MODULE$.tryCatch((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.logger().info(new StringBuilder(59).append("Start to wait engineConn(").append(engineNode).append(") to be available, but only ").append(ByteTimeUtils.msDurationToString((long)timeout)).append(" left.").toString());
            Utils$.MODULE$.waitUntil((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> this.ensuresIdle(engineNode, resourceTicketId), (Duration)Duration$.MODULE$.apply(timeout, TimeUnit.MILLISECONDS));
        }, (Function1 & Serializable & scala.Serializable)x0$1 -> {
            DefaultEngineCreateService.$anonfun$ensureECAvailable$3(this, engineNode, resourceTicketId, timeout, x0$1);
            return BoxedUnit.UNIT;
        });
        return engineNode;
    }

    public static final /* synthetic */ void $anonfun$buildLabel$2(ObjectRef labelList$1, LabelChecker labelChecker) {
        if (!labelChecker.checkEngineLabel((List)labelList$1.elem)) {
            throw new AMErrorException(30002, "Need to specify engineType and userCreator label");
        }
    }

    public static final /* synthetic */ boolean $anonfun$selectECM$1(Label x$1) {
        return !(x$1 instanceof EngineTypeLabel);
    }

    public static final /* synthetic */ boolean $anonfun$fromEMGetEngineLabels$1(Label label) {
        return label instanceof EngineNodeLabel && !(label instanceof EngineTypeLabel);
    }

    public static final /* synthetic */ void $anonfun$ensureECAvailable$3(DefaultEngineCreateService $this, EngineNode engineNode$3, String resourceTicketId$3, long timeout$1, Throwable x0$1) {
        Throwable throwable = x0$1;
        if (throwable instanceof TimeoutException) {
            $this.logger().info(new StringBuilder(72).append("Waiting for engineNode:").append(engineNode$3).append("(").append(resourceTicketId$3).append(") initialization TimeoutException , now stop it.").toString());
            EngineStopRequest stopEngineRequest = new EngineStopRequest(engineNode$3.getServiceInstance(), ManagerUtils.getAdminUser());
            $this.engineStopService().asyncStopEngine(stopEngineRequest);
            throw new LinkisRetryException(30001, new StringBuilder(78).append("Waiting for engineNode:").append(engineNode$3).append("(").append(resourceTicketId$3).append(") initialization TimeoutException, already waiting ").append(timeout$1).append(" ms").toString());
        }
        if (throwable != null) {
            Throwable throwable2 = throwable;
            $this.logger().info(new StringBuilder(52).append("Waiting for ").append(engineNode$3).append("(").append(resourceTicketId$3).append(") initialization failure , now stop it.").toString());
            EngineStopRequest stopEngineRequest = new EngineStopRequest(engineNode$3.getServiceInstance(), ManagerUtils.getAdminUser());
            $this.engineStopService().asyncStopEngine(stopEngineRequest);
            throw throwable2;
        }
        throw new MatchError((Object)throwable);
    }

    public DefaultEngineCreateService() {
        Logging.$init$((Logging)this);
        this.labelBuilderFactory = LabelBuilderFactoryContext.getLabelBuilderFactory();
    }
}

