/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.engineplugin.cache;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.RemovalCause;
import com.google.common.cache.RemovalListener;
import java.util.concurrent.TimeUnit;
import org.apache.linkis.engineplugin.cache.EngineConnPluginCache;
import org.apache.linkis.engineplugin.cache.config.EngineConnPluginCacheConfig;
import org.apache.linkis.engineplugin.cache.refresh.DefaultRefreshPluginCacheContainer;
import org.apache.linkis.engineplugin.cache.refresh.PluginCacheRefresher;
import org.apache.linkis.engineplugin.cache.refresh.RefreshPluginCacheContainer;
import org.apache.linkis.engineplugin.cache.refresh.RefreshPluginCacheOperation;
import org.apache.linkis.engineplugin.cache.refresh.RefreshableEngineConnPluginCache;
import org.apache.linkis.manager.engineplugin.common.exception.EngineConnPluginNotFoundException;
import org.apache.linkis.manager.engineplugin.common.loader.entity.EngineConnPluginInfo;
import org.apache.linkis.manager.engineplugin.common.loader.entity.EngineConnPluginInstance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GuavaEngineConnPluginCache
implements RefreshableEngineConnPluginCache {
    private static final Logger LOG = LoggerFactory.getLogger(GuavaEngineConnPluginCache.class);
    private Cache<String, EngineConnPluginInstance> pluginCache;
    private PluginCacheRefresher refresher;
    private RefreshPluginCacheContainer refreshContainer = new DefaultRefreshPluginCacheContainer(this);

    public GuavaEngineConnPluginCache() {
        this(null);
    }

    public GuavaEngineConnPluginCache(PluginCacheRefresher refresher) {
        this.refresher = refresher;
        this.pluginCache = this.constructCache((Integer)EngineConnPluginCacheConfig.PLUGIN_CACHE_SIZE.getValue(), (Long)EngineConnPluginCacheConfig.PLUGIN_CACHE_EXPIRE_TIME_SECONDS.getValue(), (RemovalListener<String, EngineConnPluginInstance>)((RemovalListener)removalNotification -> {
            String cacheKey = (String)removalNotification.getKey();
            LOG.info("Remove cache of engine conn plugin:[ " + cacheKey + " ], cause: " + removalNotification.getCause());
            if (!RemovalCause.REPLACED.equals((Object)removalNotification.getCause())) {
                this.refreshContainer.removeRefreshOperation(((EngineConnPluginInstance)removalNotification.getValue()).info());
            }
        }));
        if (null != refresher) {
            this.refreshContainer.start(refresher);
        }
    }

    private Cache<String, EngineConnPluginInstance> constructCache(int cacheSize, long expireTimeInSeconds, RemovalListener<String, EngineConnPluginInstance> removeListener) {
        CacheBuilder cacheBuilder = CacheBuilder.newBuilder().maximumSize((long)cacheSize).removalListener(removeListener);
        if (expireTimeInSeconds > 0L) {
            cacheBuilder.expireAfterAccess(expireTimeInSeconds, TimeUnit.SECONDS);
        }
        return cacheBuilder.build();
    }

    @Override
    public void addRefreshListener(RefreshableEngineConnPluginCache.RefreshListener refreshListener) {
        this.refreshContainer.addRefreshListener(refreshListener);
    }

    @Override
    public synchronized void setRefresher(PluginCacheRefresher refresher) {
        if (null != refresher) {
            if (null != this.refresher) {
                this.refreshContainer.stop();
            }
            this.refreshContainer.start(refresher);
            this.refresher = refresher;
        }
    }

    @Override
    public void refresh(EngineConnPluginInfo pluginInfo, EngineConnPluginInstance pluginInstance) throws Exception {
        this.put(pluginInfo, pluginInstance);
    }

    @Override
    public void put(EngineConnPluginInfo pluginInfo, EngineConnPluginInstance pluginInstance) throws Exception {
        this.pluginCache.put((Object)pluginInfo.toString(), (Object)pluginInstance);
    }

    @Override
    public EngineConnPluginInstance get(EngineConnPluginInfo pluginInfo, EngineConnPluginCache.PluginGetter caller) throws Exception {
        return (EngineConnPluginInstance)this.pluginCache.get((Object)pluginInfo.toString(), () -> {
            EngineConnPluginInstance instance = caller.call(pluginInfo);
            if (null != this.refresher) {
                this.refreshContainer.addRefreshOperation(pluginInfo, new RefreshPluginCacheOperation(info -> {
                    try {
                        return caller.call((EngineConnPluginInfo)info);
                    }
                    catch (EngineConnPluginNotFoundException ne) {
                        LOG.trace("Not need to refresh the cache of plugin: [" + info.toString() + "], because the resource is not found");
                        return null;
                    }
                    catch (Exception e) {
                        LOG.error("Refresh cache of plugin: [" + info.toString() + "] failed, message: [" + e.getMessage() + "]", (Throwable)e);
                        return null;
                    }
                }));
            }
            return instance;
        });
    }

    @Override
    public EngineConnPluginInstance remove(EngineConnPluginInfo pluginInfo) throws Exception {
        EngineConnPluginInstance instance = (EngineConnPluginInstance)this.pluginCache.getIfPresent((Object)pluginInfo.toString());
        this.pluginCache.invalidate((Object)pluginInfo.toString());
        return instance;
    }
}

