/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.storage.source;

import java.io.InputStream;
import java.io.Serializable;
import org.apache.linkis.common.io.Fs;
import org.apache.linkis.common.io.FsPath;
import org.apache.linkis.common.io.FsReader;
import org.apache.linkis.common.io.MetaData;
import org.apache.linkis.common.io.Record;
import org.apache.linkis.common.io.resultset.ResultSet;
import org.apache.linkis.common.io.resultset.ResultSetReader;
import org.apache.linkis.common.utils.Logging;
import org.apache.linkis.storage.conf.LinkisStorageConf$;
import org.apache.linkis.storage.errorcode.LinkisStorageErrorCodeSummary;
import org.apache.linkis.storage.exception.StorageErrorException;
import org.apache.linkis.storage.resultset.ResultSetFactory$;
import org.apache.linkis.storage.resultset.ResultSetReader$;
import org.apache.linkis.storage.script.ScriptFsReader;
import org.apache.linkis.storage.script.ScriptFsReader$;
import org.apache.linkis.storage.source.FileSource;
import org.apache.linkis.storage.source.FileSplit;
import org.apache.linkis.storage.source.FileSplit$;
import org.apache.linkis.storage.source.ResultsetFileSource;
import org.apache.linkis.storage.source.TextFileSource;
import org.apache.linkis.storage.utils.StorageConfiguration$;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class FileSource$
implements Logging {
    public static FileSource$ MODULE$;
    private final String[] fileType;
    private final Function2<String, String, Object> suffixPredicate;
    private Logger logger;
    private volatile boolean bitmap$0;

    static {
        new FileSource$();
    }

    public void trace(Function0<String> message) {
        Logging.trace$((Logging)this, message);
    }

    public void debug(Function0<String> message) {
        Logging.debug$((Logging)this, message);
    }

    public void info(Function0<String> message) {
        Logging.info$((Logging)this, message);
    }

    public void info(Function0<String> message, Throwable t) {
        Logging.info$((Logging)this, message, (Throwable)t);
    }

    public void warn(Function0<String> message) {
        Logging.warn$((Logging)this, message);
    }

    public void warn(Function0<String> message, Throwable t) {
        Logging.warn$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message, Throwable t) {
        Logging.error$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message) {
        Logging.error$((Logging)this, message);
    }

    private Logger logger$lzycompute() {
        FileSource$ fileSource$ = this;
        synchronized (fileSource$) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    private String[] fileType() {
        return this.fileType;
    }

    private Function2<String, String, Object> suffixPredicate() {
        return this.suffixPredicate;
    }

    public boolean isResultSet(String path) {
        return BoxesRunTime.unboxToBoolean((Object)this.suffixPredicate().apply((Object)path, new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.fileType())).head()));
    }

    public boolean isResultSet(FsPath fsPath) {
        return this.isResultSet(fsPath.getPath());
    }

    public FileSource create(FsPath[] fsPaths, Fs fs) {
        FileSplit[] fileSplits = (FileSplit[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fsPaths)).map((Function1 & Serializable & scala.Serializable)x$1 -> MODULE$.createResultSetFileSplit((FsPath)x$1, fs), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(FileSplit.class))))).filter((Function1 & Serializable & scala.Serializable)fileSplit -> BoxesRunTime.boxToBoolean((boolean)FileSource$.MODULE$.isTableResultSet(fileSplit)));
        return new ResultsetFileSource(fileSplits);
    }

    private boolean isTableResultSet(FileSplit fileSplit) {
        return fileSplit.type().equals(ResultSetFactory$.MODULE$.TABLE_TYPE());
    }

    public boolean isTableResultSet(FileSource fileSource) {
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fileSource.getFileSplits())).forall((Function1 & Serializable & scala.Serializable)fileSplit -> BoxesRunTime.boxToBoolean((boolean)FileSource$.MODULE$.isTableResultSet(fileSplit)));
    }

    public FileSource create(FsPath fsPath, Fs fs) {
        if (!this.canRead(fsPath.getPath())) {
            throw new StorageErrorException(LinkisStorageErrorCodeSummary.UNSUPPORTED_OPEN_FILE_TYPE.getErrorCode(), LinkisStorageErrorCodeSummary.UNSUPPORTED_OPEN_FILE_TYPE.getErrorDesc());
        }
        if (this.isResultSet(fsPath)) {
            return new ResultsetFileSource((FileSplit[])((Object[])new FileSplit[]{this.createResultSetFileSplit(fsPath, fs)}));
        }
        return new TextFileSource((FileSplit[])((Object[])new FileSplit[]{this.createTextFileSplit(fsPath, fs)}));
    }

    public FileSource create(FsPath fsPath, InputStream is) {
        if (!this.canRead(fsPath.getPath())) {
            throw new StorageErrorException(LinkisStorageErrorCodeSummary.UNSUPPORTED_OPEN_FILE_TYPE.getErrorCode(), LinkisStorageErrorCodeSummary.UNSUPPORTED_OPEN_FILE_TYPE.getErrorDesc());
        }
        if (this.isResultSet(fsPath)) {
            return new ResultsetFileSource((FileSplit[])((Object[])new FileSplit[]{this.createResultSetFileSplit(fsPath, is)}));
        }
        return new TextFileSource((FileSplit[])((Object[])new FileSplit[]{this.createTextFileSplit(fsPath, is)}));
    }

    private FileSplit createResultSetFileSplit(FsPath fsPath, InputStream is) {
        ResultSet<? extends MetaData, ? extends Record> resultset = ResultSetFactory$.MODULE$.getInstance().getResultSetByPath(fsPath);
        ResultSetReader<? extends MetaData, ? extends Record> resultsetReader = ResultSetReader$.MODULE$.getResultSetReader(resultset, is);
        return new FileSplit((FsReader<? extends MetaData, ? extends Record>)resultsetReader, resultset.resultSetType());
    }

    private FileSplit createResultSetFileSplit(FsPath fsPath, Fs fs) {
        this.logger().info(new StringBuilder(43).append("try create result set file split with path:").append(fsPath.getPath()).toString());
        ResultSet<? extends MetaData, ? extends Record> resultset = ResultSetFactory$.MODULE$.getInstance().getResultSetByPath(fsPath, fs);
        ResultSetReader<? extends MetaData, ? extends Record> resultsetReader = ResultSetReader$.MODULE$.getResultSetReader(resultset, fs.read(fsPath));
        return new FileSplit((FsReader<? extends MetaData, ? extends Record>)resultsetReader, resultset.resultSetType());
    }

    private FileSplit createTextFileSplit(FsPath fsPath, InputStream is) {
        ScriptFsReader scriptFsReader = ScriptFsReader$.MODULE$.getScriptFsReader(fsPath, (String)StorageConfiguration$.MODULE$.STORAGE_RS_FILE_TYPE().getValue(), is);
        return new FileSplit(scriptFsReader, FileSplit$.MODULE$.$lessinit$greater$default$2());
    }

    private FileSplit createTextFileSplit(FsPath fsPath, Fs fs) {
        ScriptFsReader scriptFsReader = ScriptFsReader$.MODULE$.getScriptFsReader(fsPath, (String)StorageConfiguration$.MODULE$.STORAGE_RS_FILE_TYPE().getValue(), fs.read(fsPath));
        return new FileSplit(scriptFsReader, FileSplit$.MODULE$.$lessinit$greater$default$2());
    }

    private boolean canRead(String path) {
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.fileType())).exists((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)FileSource$.$anonfun$canRead$1(path, x$2)));
    }

    public static final /* synthetic */ boolean $anonfun$canRead$1(String path$1, String x$2) {
        return BoxesRunTime.unboxToBoolean((Object)MODULE$.suffixPredicate().apply((Object)path$1, (Object)x$2));
    }

    private FileSource$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
        this.fileType = LinkisStorageConf$.MODULE$.getFileTypeArr();
        this.suffixPredicate = (Function2 & Serializable & scala.Serializable)(path, suffix) -> BoxesRunTime.boxToBoolean((boolean)path.endsWith(new StringBuilder(1).append(".").append(suffix).toString()));
    }
}

