/*
 * Decompiled with CFR 0.152.
 */
package py4j;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import py4j.Gateway;
import py4j.GatewayConnection;
import py4j.GatewayServerListener;
import py4j.NetworkUtil;
import py4j.Protocol;
import py4j.Py4JClientConnection;
import py4j.Py4JException;
import py4j.Py4JJavaServer;
import py4j.Py4JNetworkException;
import py4j.Py4JPythonClientPerThread;
import py4j.Py4JServerConnection;
import py4j.commands.Command;

public class ClientServerConnection
implements Py4JServerConnection,
Py4JClientConnection,
Runnable {
    private boolean used = false;
    private boolean initiatedFromClient = false;
    protected Socket socket;
    protected BufferedWriter writer;
    protected BufferedReader reader;
    protected final Map<String, Command> commands;
    protected final Logger logger = Logger.getLogger(ClientServerConnection.class.getName());
    protected final Py4JJavaServer javaServer;
    protected final Py4JPythonClientPerThread pythonClient;
    protected final int blockingReadTimeout;
    protected final int nonBlockingReadTimeout;

    public ClientServerConnection(Gateway gateway, Socket socket, List<Class<? extends Command>> customCommands, Py4JPythonClientPerThread pythonClient, Py4JJavaServer javaServer, int readTimeout) throws IOException {
        this.socket = socket;
        this.reader = new BufferedReader(new InputStreamReader(socket.getInputStream(), Charset.forName("UTF-8")));
        this.writer = new BufferedWriter(new OutputStreamWriter(socket.getOutputStream(), Charset.forName("UTF-8")));
        this.commands = new HashMap<String, Command>();
        this.initCommands(gateway, GatewayConnection.getBaseCommands());
        if (customCommands != null) {
            this.initCommands(gateway, customCommands);
        }
        this.javaServer = javaServer;
        this.pythonClient = pythonClient;
        this.blockingReadTimeout = readTimeout;
        this.nonBlockingReadTimeout = readTimeout > 0 ? readTimeout : 1000;
    }

    public void startServerConnection() {
        Thread t = new Thread(this);
        t.start();
    }

    @Override
    public void run() {
        this.pythonClient.setPerThreadConnection(this);
        this.waitForCommands();
    }

    protected void initCommands(Gateway gateway, List<Class<? extends Command>> commandsClazz) {
        for (Class<? extends Command> clazz : commandsClazz) {
            try {
                Command cmd = clazz.newInstance();
                cmd.init(gateway, this);
                this.commands.put(cmd.getCommandName(), cmd);
            }
            catch (Exception e) {
                String name = "null";
                if (clazz != null) {
                    name = clazz.getName();
                }
                this.logger.log(Level.SEVERE, "Could not initialize command " + name, e);
            }
        }
    }

    protected void fireConnectionStopped() {
        this.logger.info("Connection Stopped");
        for (GatewayServerListener listener : this.javaServer.getListeners()) {
            try {
                listener.connectionStopped(this);
            }
            catch (Exception e) {
                this.logger.log(Level.SEVERE, "A listener crashed.", e);
            }
        }
    }

    protected void quietSendError(BufferedWriter writer, Throwable exception) {
        try {
            String returnCommand = Protocol.getOutputErrorCommand(exception);
            this.logger.fine("Trying to return error: " + returnCommand);
            writer.write(returnCommand);
            writer.flush();
        }
        catch (Exception e) {
            this.logger.log(Level.FINEST, "Error in quiet send.", e);
        }
    }

    @Override
    public Socket getSocket() {
        return this.socket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForCommands() {
        boolean reset = false;
        boolean executing = false;
        Exception error = null;
        try {
            this.logger.info("Gateway Connection ready to receive messages");
            String commandLine = null;
            do {
                commandLine = this.reader.readLine();
                executing = true;
                this.logger.fine("Received command: " + commandLine);
                Command command = this.commands.get(commandLine);
                if (command != null) {
                    command.execute(commandLine, this.reader, this.writer);
                    executing = false;
                    continue;
                }
                this.logger.log(Level.WARNING, "Unknown command " + commandLine);
            } while (commandLine != null && !commandLine.equals("q"));
        }
        catch (SocketTimeoutException ste) {
            this.logger.log(Level.WARNING, "Timeout occurred while waiting for a command.", ste);
            reset = true;
            error = ste;
        }
        catch (Exception e) {
            this.logger.log(Level.WARNING, "Error occurred while waiting for a command.", e);
            error = e;
        }
        finally {
            if (error != null && executing && this.writer != null) {
                this.quietSendError(this.writer, error);
            }
            this.shutdown(reset);
        }
    }

    @Override
    public String sendCommand(String command) {
        return this.sendCommand(command, true);
    }

    @Override
    public String sendCommand(String command, boolean blocking) {
        this.logger.log(Level.INFO, "Sending Python command: " + command);
        String returnCommand = null;
        try {
            this.writer.write(command);
            this.writer.flush();
        }
        catch (Exception e) {
            throw new Py4JNetworkException("Error while sending a command: " + command, e, Py4JNetworkException.ErrorTime.ERROR_ON_SEND);
        }
        try {
            while (true) {
                if ((returnCommand = blocking ? this.readBlockingResponse(this.reader) : this.readNonBlockingResponse(this.socket, this.reader)) == null || returnCommand.trim().equals("")) {
                    throw new Py4JException("Received empty command");
                }
                if (Protocol.isReturnMessage(returnCommand)) {
                    returnCommand = returnCommand.substring(1);
                    this.logger.log(Level.INFO, "Returning CB command: " + returnCommand);
                    return returnCommand;
                }
                Command commandObj = this.commands.get(returnCommand);
                if (commandObj != null) {
                    commandObj.execute(returnCommand, this.reader, this.writer);
                    continue;
                }
                this.logger.log(Level.WARNING, "Unknown command " + returnCommand);
            }
        }
        catch (Exception e) {
            throw new Py4JNetworkException("Error while sending a command: " + command, e, Py4JNetworkException.ErrorTime.ERROR_ON_RECEIVE);
        }
    }

    @Override
    public void shutdown() {
        this.shutdown(false);
    }

    @Override
    public void shutdown(boolean reset) {
        if (reset) {
            NetworkUtil.quietlySetLinger(this.socket);
        }
        NetworkUtil.quietlyClose(this.socket);
        NetworkUtil.quietlyClose(this.reader);
        NetworkUtil.quietlyClose(this.writer);
        this.socket = null;
        this.writer = null;
        this.reader = null;
        if (!this.initiatedFromClient) {
            this.fireConnectionStopped();
        }
    }

    @Override
    public void start() throws IOException {
    }

    @Override
    public void setUsed(boolean used) {
        this.used = used;
    }

    @Override
    public boolean wasUsed() {
        return this.used;
    }

    public boolean isInitiatedFromClient() {
        return this.initiatedFromClient;
    }

    public void setInitiatedFromClient(boolean initiatedFromClient) {
        this.initiatedFromClient = initiatedFromClient;
    }

    protected String readBlockingResponse(BufferedReader reader) throws IOException {
        return reader.readLine();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String readNonBlockingResponse(Socket socket, BufferedReader reader) throws IOException {
        String returnCommand = null;
        socket.setSoTimeout(this.nonBlockingReadTimeout);
        try {
            returnCommand = reader.readLine();
        }
        finally {
            socket.setSoTimeout(this.blockingReadTimeout);
        }
        socket.setSoTimeout(this.blockingReadTimeout);
        return returnCommand;
    }
}

