/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.builders;

import java.util.Arrays;
import java.util.List;
import springfox.documentation.builders.ParameterSpecificationContext;
import springfox.documentation.builders.ParameterSpecificationProvider;
import springfox.documentation.schema.ModelSpecification;
import springfox.documentation.service.CollectionFormat;
import springfox.documentation.service.ContentSpecification;
import springfox.documentation.service.ParameterSpecification;
import springfox.documentation.service.ParameterStyle;
import springfox.documentation.service.SimpleParameterSpecification;

class QueryParameterSpecificationProvider
implements ParameterSpecificationProvider {
    static final List<ParameterStyle> VALID_COLLECTION_STYLES = Arrays.asList(ParameterStyle.FORM, ParameterStyle.SPACEDELIMITED, ParameterStyle.PIPEDELIMITED);
    static final List<ParameterStyle> VALID_OBJECT_STYLES = Arrays.asList(ParameterStyle.FORM, ParameterStyle.DEEPOBJECT);

    QueryParameterSpecificationProvider() {
    }

    @Override
    public ParameterSpecification create(ParameterSpecificationContext context) {
        SimpleParameterSpecification simpleParameter = context.getSimpleParameter();
        SimpleParameterSpecification validSimpleParameter = null;
        ContentSpecification validContentEncoding = null;
        if (simpleParameter != null) {
            ParameterStyle style;
            ModelSpecification model = simpleParameter.getModel();
            if (model != null) {
                if (model.getScalar().isPresent()) {
                    validSimpleParameter = context.getSimpleParameterSpecificationBuilder().copyOf(simpleParameter).explode(simpleParameter.getExplode()).style(ParameterStyle.FORM).build();
                } else if (model.getCollection().isPresent()) {
                    style = VALID_COLLECTION_STYLES.contains((Object)simpleParameter.getStyle()) ? simpleParameter.getStyle() : (simpleParameter.nullSafeIsExplode() != false ? ParameterStyle.FORM : ParameterStyle.PIPEDELIMITED);
                    validSimpleParameter = context.getSimpleParameterSpecificationBuilder().copyOf(simpleParameter).explode(simpleParameter.getExplode()).style(style).collectionFormat(CollectionFormat.MULTI).build();
                }
            }
            if (validSimpleParameter == null) {
                style = VALID_OBJECT_STYLES.contains((Object)simpleParameter.getStyle()) ? simpleParameter.getStyle() : (simpleParameter.nullSafeIsExplode() != false ? ParameterStyle.FORM : ParameterStyle.DEEPOBJECT);
                validSimpleParameter = context.getSimpleParameterSpecificationBuilder().copyOf(simpleParameter).explode(style == ParameterStyle.DEEPOBJECT ? Boolean.TRUE : simpleParameter.getExplode()).style(style).collectionFormat(null).build();
            }
        }
        if (context.getContentParameter() != null) {
            validContentEncoding = context.getContentSpecificationBuilder().copyOf(context.getContentParameter()).build();
        }
        return new ParameterSpecification(validSimpleParameter, validContentEncoding);
    }
}

