/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.entrance.persistence;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.linkis.common.exception.ErrorException;
import org.apache.linkis.common.utils.JsonUtils;
import org.apache.linkis.entrance.conf.EntranceConfiguration;
import org.apache.linkis.entrance.conf.EntranceConfiguration$;
import org.apache.linkis.entrance.errorcode.EntranceErrorCodeSummary;
import org.apache.linkis.entrance.exception.EntranceIllegalParamException;
import org.apache.linkis.entrance.exception.EntranceRPCException;
import org.apache.linkis.entrance.exception.QueryFailedException;
import org.apache.linkis.entrance.persistence.AbstractPersistenceEngine;
import org.apache.linkis.governance.common.conf.GovernanceCommonConf;
import org.apache.linkis.governance.common.constant.job.JobRequestConstants;
import org.apache.linkis.governance.common.entity.job.JobRequest;
import org.apache.linkis.governance.common.entity.task.RequestPersistTask;
import org.apache.linkis.governance.common.entity.task.RequestReadAllTask;
import org.apache.linkis.governance.common.entity.task.ResponsePersist;
import org.apache.linkis.governance.common.protocol.job.JobReqInsert;
import org.apache.linkis.governance.common.protocol.job.JobReqUpdate;
import org.apache.linkis.governance.common.protocol.job.JobRespProtocol;
import org.apache.linkis.protocol.message.RequestProtocol;
import org.apache.linkis.protocol.task.Task;
import org.apache.linkis.rpc.Sender;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;

public class QueryPersistenceEngine
extends AbstractPersistenceEngine {
    private Sender sender = Sender.getSender((String)((String)EntranceConfiguration$.MODULE$.JOBHISTORY_SPRING_APPLICATION_NAME().getValue()));
    private static final Logger logger = LoggerFactory.getLogger(QueryPersistenceEngine.class);
    private static final int MAX_DESC_LEN = GovernanceCommonConf.ERROR_CODE_DESC_LEN();

    private JobRespProtocol sendToJobHistoryAndRetry(RequestProtocol jobReq, String msg) throws QueryFailedException {
        JobRespProtocol jobRespProtocol = null;
        int retryTimes = 0;
        boolean retry = true;
        while (retry && retryTimes < (Integer)EntranceConfiguration.JOBINFO_UPDATE_RETRY_MAX_TIME().getHotValue()) {
            try {
                ++retryTimes;
                jobRespProtocol = (JobRespProtocol)this.sender.ask((Object)jobReq);
                if (jobRespProtocol.getStatus() == 2) {
                    logger.warn("Request jobHistory failed, joReq msg{}, retry times: {}, reason {}", new Object[]{msg, retryTimes, jobRespProtocol.getMsg()});
                } else {
                    retry = false;
                }
            }
            catch (Exception e) {
                logger.warn("Request jobHistory failed, joReq msg{}, retry times: {}, reason {}", new Object[]{msg, retryTimes, e});
            }
            if (!retry) continue;
            try {
                Thread.sleep(((Integer)EntranceConfiguration.JOBINFO_UPDATE_RETRY_INTERVAL().getHotValue()).intValue());
            }
            catch (Exception ex) {
                logger.warn(ex.getMessage());
            }
        }
        if (jobRespProtocol != null) {
            int status = jobRespProtocol.getStatus();
            String message = jobRespProtocol.getMsg();
            if (status != 0) {
                throw new QueryFailedException(EntranceErrorCodeSummary.REQUEST_JOBHISTORY_FAILED.getErrorCode(), MessageFormat.format(EntranceErrorCodeSummary.REQUEST_JOBHISTORY_FAILED.getErrorDesc(), message));
            }
        } else {
            throw new QueryFailedException(EntranceErrorCodeSummary.JOBRESP_PROTOCOL_NULL.getErrorCode(), EntranceErrorCodeSummary.JOBRESP_PROTOCOL_NULL.getErrorDesc());
        }
        return jobRespProtocol;
    }

    @Override
    public void updateIfNeeded(JobRequest jobReq) throws ErrorException, QueryFailedException {
        if (null == jobReq) {
            throw new EntranceIllegalParamException(EntranceErrorCodeSummary.JOBREQ_NOT_NULL.getErrorCode(), EntranceErrorCodeSummary.JOBREQ_NOT_NULL.getErrorDesc());
        }
        JobRequest jobReqForUpdate = new JobRequest();
        BeanUtils.copyProperties((Object)jobReq, (Object)jobReqForUpdate);
        if (null != jobReq.getErrorDesc() && jobReq.getErrorDesc().length() > MAX_DESC_LEN) {
            jobReqForUpdate.setErrorDesc(jobReq.getErrorDesc().substring(0, MAX_DESC_LEN));
        }
        jobReqForUpdate.setUpdatedTime(new Date());
        JobReqUpdate jobReqUpdate = new JobReqUpdate(jobReqForUpdate);
        JobRespProtocol jobRespProtocol = this.sendToJobHistoryAndRetry((RequestProtocol)jobReqUpdate, "job:" + jobReq.getReqId() + "status:" + jobReq.getStatus());
    }

    @Override
    public void persist(JobRequest jobReq) throws ErrorException {
        JobReqInsert jobReqInsert;
        JobRespProtocol jobRespProtocol;
        if (null == jobReq) {
            throw new EntranceIllegalParamException(EntranceErrorCodeSummary.JOBREQUEST_NOT_NULL.getErrorCode(), EntranceErrorCodeSummary.JOBREQUEST_NOT_NULL.getErrorDesc());
        }
        if (logger.isDebugEnabled()) {
            try {
                logger.debug("jobReq:" + JsonUtils.jackson().writeValueAsString((Object)jobReq));
            }
            catch (JsonProcessingException e) {
                logger.debug("convert jobReq to string with error:" + e.getMessage());
            }
        }
        if (null != (jobRespProtocol = this.sendToJobHistoryAndRetry((RequestProtocol)(jobReqInsert = new JobReqInsert(jobReq)), "Insert job"))) {
            Map data = jobRespProtocol.getData();
            Object object = data.get(JobRequestConstants.JOB_ID());
            if (null == object) {
                throw new QueryFailedException(20011, "Insert JobReq failed, reason : " + jobRespProtocol.getMsg());
            }
            String jobIdStr = object.toString();
            Long jobId = Long.parseLong(jobIdStr);
            jobReq.setId(jobId);
        }
    }

    @Override
    public Task[] readAll(String instance) throws EntranceIllegalParamException, EntranceRPCException, QueryFailedException {
        ArrayList<RequestPersistTask> retList = new ArrayList<RequestPersistTask>();
        if (instance == null || "".equals(instance)) {
            throw new EntranceIllegalParamException(EntranceErrorCodeSummary.INSTANCE_NOT_NULL.getErrorCode(), EntranceErrorCodeSummary.INSTANCE_NOT_NULL.getErrorDesc());
        }
        RequestReadAllTask requestReadAllTask = new RequestReadAllTask(instance);
        ResponsePersist responsePersist = null;
        try {
            responsePersist = (ResponsePersist)this.sender.ask((Object)requestReadAllTask);
        }
        catch (Exception e) {
            throw new EntranceRPCException(EntranceErrorCodeSummary.SENDER_RPC_FAILED.getErrorCode(), EntranceErrorCodeSummary.SENDER_RPC_FAILED.getErrorDesc(), e);
        }
        if (responsePersist != null) {
            int status = responsePersist.getStatus();
            String message = responsePersist.getMsg();
            if (status != 0) {
                throw new QueryFailedException(EntranceErrorCodeSummary.READ_TASKS_FAILED.getErrorCode(), MessageFormat.format(EntranceErrorCodeSummary.READ_TASKS_FAILED.getErrorDesc(), message));
            }
            Map data = responsePersist.getData();
            Object object = data.get("task");
            if (object instanceof List) {
                List list = (List)object;
                if (list.size() == 0) {
                    logger.info("no running task in this instance: {}", (Object)instance);
                }
                for (Object o : list) {
                    if (!(o instanceof RequestPersistTask)) continue;
                    retList.add((RequestPersistTask)o);
                }
            }
        }
        return retList.toArray(new Task[0]);
    }

    @Override
    public JobRequest retrieveJobReq(Long jobGroupId) throws ErrorException {
        return null;
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public void flush() throws IOException {
    }
}

