/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.gateway.security;

import java.io.File;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.text.DateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.linkis.common.conf.CommonVars$;
import org.apache.linkis.common.conf.Configuration$;
import org.apache.linkis.common.exception.LinkisException;
import org.apache.linkis.common.utils.Logging;
import org.apache.linkis.common.utils.Utils$;
import org.apache.linkis.gateway.config.GatewayConfiguration$;
import org.apache.linkis.gateway.http.GatewayContext;
import org.apache.linkis.gateway.http.GatewayHttpResponse;
import org.apache.linkis.gateway.security.GatewaySSOUtils$;
import org.apache.linkis.gateway.security.UserRestful;
import org.apache.linkis.gateway.security.oauth.OAuth2Authentication$;
import org.apache.linkis.gateway.security.sso.SSOInterceptor$;
import org.apache.linkis.gateway.security.token.TokenAuthentication$;
import org.apache.linkis.server.Message;
import org.apache.linkis.server.Message$;
import org.apache.linkis.server.conf.ServerConfiguration$;
import org.apache.linkis.server.exception.LoginExpireException;
import org.apache.linkis.server.exception.NonLoginException;
import org.apache.linkis.server.package$;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.collection.mutable.ArrayOps;
import scala.io.BufferedSource;
import scala.io.Source$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.java8.JFunction0;

public final class SecurityFilter$
implements Logging {
    public static SecurityFilter$ MODULE$;
    private final boolean refererValidate;
    private final String referers;
    private final String testUser;
    private final String ACCESS_CONTROL_USER_PREFIX;
    private final HashSet<String> ipSet;
    private UserRestful userRestful;
    private Logger logger;
    private volatile boolean bitmap$0;

    static {
        new SecurityFilter$();
    }

    public void trace(Function0<String> message) {
        Logging.trace$((Logging)this, message);
    }

    public void debug(Function0<String> message) {
        Logging.debug$((Logging)this, message);
    }

    public void info(Function0<String> message) {
        Logging.info$((Logging)this, message);
    }

    public void info(Function0<String> message, Throwable t) {
        Logging.info$((Logging)this, message, (Throwable)t);
    }

    public void warn(Function0<String> message) {
        Logging.warn$((Logging)this, message);
    }

    public void warn(Function0<String> message, Throwable t) {
        Logging.warn$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message, Throwable t) {
        Logging.error$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message) {
        Logging.error$((Logging)this, message);
    }

    private Logger logger$lzycompute() {
        SecurityFilter$ securityFilter$ = this;
        synchronized (securityFilter$) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    private boolean refererValidate() {
        return this.refererValidate;
    }

    private String referers() {
        return this.referers;
    }

    public String testUser() {
        return this.testUser;
    }

    private String ACCESS_CONTROL_USER_PREFIX() {
        return this.ACCESS_CONTROL_USER_PREFIX;
    }

    private HashSet<String> ipSet() {
        return this.ipSet;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean doFilter(GatewayContext gatewayContext) {
        Object object = new Object();
        try {
            Boolean bl;
            this.addAccessHeaders(gatewayContext);
            if (BoxesRunTime.unboxToBoolean((Object)GatewayConfiguration$.MODULE$.ENABLE_GATEWAY_AUTH().getValue())) {
                String host = gatewayContext.getRequest().getRemoteAddress().getAddress().toString().replaceAll("/", "");
                int port = gatewayContext.getRequest().getRemoteAddress().getPort();
                if (!this.ipSet().contains(host)) {
                    this.logger().error(new StringBuilder(42).append(host).append(" and ").append(port).append(" is not in whitelist, it is dangerous").toString());
                    this.filterResponse(gatewayContext, Message$.MODULE$.error(new StringBuilder(20).append(host).append(" is not in whitelist").toString()));
                    return false;
                }
            }
            if (this.refererValidate()) {
                String[] referer = gatewayContext.getRequest().getHeaders().get("Referer");
                String[] refList = StringUtils.isNotEmpty((CharSequence)this.referers()) ? this.referers().split(",") : (String[])Array$.MODULE$.empty(ClassTag$.MODULE$.Nothing());
                boolean flag = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])refList)).exists((Function1 & Serializable & scala.Serializable)ref -> BoxesRunTime.boxToBoolean((boolean)SecurityFilter$.$anonfun$doFilter$1(referer, ref)));
                if (referer != null && new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])referer)).nonEmpty() && StringUtils.isNotEmpty((CharSequence)((CharSequence)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])referer)).head())) && !flag) {
                    this.filterResponse(gatewayContext, package$.MODULE$.validateFailed("Unallowed cross-site request(\u4e0d\u5141\u8bb8\u7684\u8de8\u7ad9\u8bf7\u6c42)\uff01"));
                    return false;
                }
                if (!gatewayContext.isWebSocketRequest() && (referer == null || new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])referer)).isEmpty() || StringUtils.isEmpty((CharSequence)((CharSequence)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])referer)).head())))) {
                    this.filterResponse(gatewayContext, package$.MODULE$.validateFailed("referer\u4e3a\u7a7a,\u4e0d\u80fd\u7ee7\u7eed\u8bbf\u95ee"));
                    return false;
                }
                String string = gatewayContext.getRequest().getMethod().toUpperCase(Locale.getDefault());
                if (!("GET".equals(string) ? true : ("POST".equals(string) ? true : ("PUT".equals(string) ? true : ("DELETE".equals(string) ? true : ("HEAD".equals(string) ? true : ("TRACE".equals(string) ? true : ("CONNECT".equals(string) ? true : "OPTIONS".equals(string))))))))) {
                    this.filterResponse(gatewayContext, package$.MODULE$.validateFailed("Do not use HTTP verbs to tamper with(\u4e0d\u53ef\u4f7f\u7528HTTP\u52a8\u8bcd\u7be1\u6539)\uff01"));
                    return false;
                }
            }
            boolean isPassAuthRequest = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])GatewayConfiguration$.MODULE$.PASS_AUTH_REQUEST_URI())).exists((Function1 & Serializable & scala.Serializable)r -> BoxesRunTime.boxToBoolean((boolean)SecurityFilter$.$anonfun$doFilter$2(gatewayContext, r)));
            boolean isUserRestful = gatewayContext.getRequest().getRequestURI().startsWith((String)ServerConfiguration$.MODULE$.BDP_SERVER_USER_URI().getValue());
            if (isUserRestful) {
                Utils$.MODULE$.tryCatch((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> MODULE$.userRestful().doUserRequest(gatewayContext), (Function1 & Serializable & scala.Serializable)t -> {
                    SecurityFilter$.$anonfun$doFilter$4(gatewayContext, t);
                    return BoxedUnit.UNIT;
                });
                return false;
            }
            if (isPassAuthRequest && !BoxesRunTime.unboxToBoolean((Object)GatewayConfiguration$.MODULE$.ENABLE_SSO_LOGIN().getValue())) {
                this.logger().info(new StringBuilder(31).append("No login needed for proxy uri: ").append(gatewayContext.getRequest().getRequestURI()).toString());
                bl = BoxedUnit.UNIT;
            } else if (TokenAuthentication$.MODULE$.isTokenRequest(gatewayContext)) {
                bl = BoxesRunTime.boxToBoolean((boolean)TokenAuthentication$.MODULE$.tokenAuth(gatewayContext, TokenAuthentication$.MODULE$.tokenAuth$default$2()));
            } else if (OAuth2Authentication$.MODULE$.isOAuth2Request(gatewayContext)) {
                bl = BoxesRunTime.boxToBoolean((boolean)OAuth2Authentication$.MODULE$.OAuth2Entry(gatewayContext, OAuth2Authentication$.MODULE$.OAuth2Entry$default$2()));
            } else {
                block26: {
                    Option userName = (Option)Utils$.MODULE$.tryCatch((Function0 & Serializable & scala.Serializable)() -> GatewaySSOUtils$.MODULE$.getLoginUser(gatewayContext), (Function1 & Serializable & scala.Serializable)x0$1 -> {
                        Throwable throwable = x0$1;
                        if (throwable instanceof NonLoginException ? true : throwable instanceof LoginExpireException) {
                            if (BoxesRunTime.unboxToBoolean((Object)Configuration$.MODULE$.IS_TEST_MODE().getValue())) {
                                return None$.MODULE$;
                            }
                            MODULE$.filterResponse(gatewayContext, Message$.MODULE$.noLogin(throwable.getMessage()).$less$less(gatewayContext.getRequest().getRequestURI()));
                            throw new NonLocalReturnControl.mcZ.sp(object, false);
                        }
                        if (throwable != null) {
                            Throwable throwable2 = throwable;
                            MODULE$.logger().warn("", throwable2);
                            throw throwable2;
                        }
                        throw new MatchError((Object)throwable);
                    });
                    if (userName.isDefined()) {
                        this.logger().info(new StringBuilder(20).append("User ").append(userName).append(" has logged in.").toString());
                    } else if (BoxesRunTime.unboxToBoolean((Object)Configuration$.MODULE$.IS_TEST_MODE().getValue())) {
                        this.logger().info(new StringBuilder(26).append("test mode! login for uri: ").append(gatewayContext.getRequest().getRequestURI()).toString());
                        GatewaySSOUtils$.MODULE$.setLoginUser(gatewayContext, this.testUser());
                    } else {
                        if (BoxesRunTime.unboxToBoolean((Object)GatewayConfiguration$.MODULE$.ENABLE_SSO_LOGIN().getValue())) {
                            String user = SSOInterceptor$.MODULE$.getSSOInterceptor().getUser(gatewayContext);
                            if (StringUtils.isNotBlank((CharSequence)user)) {
                                GatewaySSOUtils$.MODULE$.setLoginUser(gatewayContext.getRequest(), user, GatewaySSOUtils$.MODULE$.setLoginUser$default$3());
                                break block26;
                            } else {
                                if (isPassAuthRequest) {
                                    gatewayContext.getResponse().redirectTo(SSOInterceptor$.MODULE$.getSSOInterceptor().redirectTo(gatewayContext.getRequest().getURI()));
                                    gatewayContext.getResponse().sendResponse();
                                    return false;
                                }
                                this.filterResponse(gatewayContext, Message$.MODULE$.noLogin("You are not logged in, please login first(\u60a8\u5c1a\u672a\u767b\u5f55\uff0c\u8bf7\u5148\u767b\u5f55)!").data("enableSSO", (Object)BoxesRunTime.boxToBoolean((boolean)true)).data("SSOURL", (Object)SSOInterceptor$.MODULE$.getSSOInterceptor().redirectTo(gatewayContext.getRequest().getURI())).$less$less(gatewayContext.getRequest().getRequestURI()));
                                return false;
                            }
                        }
                        if (!gatewayContext.getRequest().getRequestURI().matches((String)GatewayConfiguration$.MODULE$.GATEWAY_NO_AUTH_URL_REGEX().getValue())) {
                            this.filterResponse(gatewayContext, Message$.MODULE$.noLogin("You are not logged in, please login first(\u60a8\u5c1a\u672a\u767b\u5f55\uff0c\u8bf7\u5148\u767b\u5f55)!").$less$less(gatewayContext.getRequest().getRequestURI()));
                            return false;
                        }
                        this.logger().info(new StringBuilder(56).append("Not logged in, still let it pass (GATEWAY_NO_AUTH_URL): ").append(gatewayContext.getRequest().getRequestURI()).toString());
                    }
                }
                bl = BoxedUnit.UNIT;
            }
            if (BoxesRunTime.unboxToBoolean((Object)GatewayConfiguration$.MODULE$.ACCESS_CONTROL_USER_ENABLED().getValue()) && !isPassAuthRequest && !isUserRestful) {
                String userName = GatewaySSOUtils$.MODULE$.getLoginUsername(gatewayContext);
                String userIps = (String)CommonVars$.MODULE$.apply(new StringBuilder(0).append(this.ACCESS_CONTROL_USER_PREFIX()).append(userName).toString(), (Object)"").getValue();
                String host = gatewayContext.getRequest().getRemoteAddress().getAddress().toString().replaceAll("/", "");
                if (StringUtils.isNotEmpty((CharSequence)userIps) && !userIps.contains(host)) {
                    Message message = Message$.MODULE$.error(new StringBuilder(99).append("Unauthorized access! User ").append(userName).append(" is prohibited from accessing from the current IP ").append(host).append(". (\u672a\u6388\u6743\u7684\u8bbf\u95ee\uff01\u7528\u6237").append(userName).append("\u7981\u6b62\u5728\u5f53\u524dIP").append(host).append("\u8bbf\u95ee\u3002)").toString());
                    this.filterResponse(gatewayContext, message);
                    return false;
                }
            }
            if (!BoxesRunTime.unboxToBoolean((Object)GatewayConfiguration$.MODULE$.ACCESS_CONTROL_ENABLED().getValue())) return true;
            if (isPassAuthRequest) return true;
            if (isUserRestful) return true;
            if (!StringUtils.isNotEmpty((CharSequence)((CharSequence)GatewayConfiguration$.MODULE$.ACCESS_CONTROL_IP().getValue()))) return true;
            if (!StringUtils.isNotEmpty((CharSequence)((CharSequence)GatewayConfiguration$.MODULE$.ACCESS_CONTROL_URL().getValue()))) return true;
            String host = gatewayContext.getRequest().getRemoteAddress().getAddress().toString().replaceAll("/", "");
            if (!((String)GatewayConfiguration$.MODULE$.ACCESS_CONTROL_IP().getValue()).contains(host)) return true;
            String requestUrl = gatewayContext.getRequest().getRequestURI();
            if (((String)GatewayConfiguration$.MODULE$.ACCESS_CONTROL_URL().getValue()).contains(requestUrl)) return true;
            Message message = Message$.MODULE$.error(new StringBuilder(86).append("Unauthorized access! IP ").append(host).append(" is prohibited from accessing this URL. (\u672a\u6388\u6743\u7684\u8bbf\u95ee\uff01\u5f53\u524dIP").append(host).append("\u7981\u6b62\u8bbf\u95ee\u6b64URL\u3002)").toString());
            this.filterResponse(gatewayContext, message);
            return false;
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() != object) throw ex;
            boolean bl = ex.value$mcZ$sp();
            return bl;
        }
    }

    private UserRestful userRestful() {
        return this.userRestful;
    }

    private void userRestful_$eq(UserRestful x$1) {
        this.userRestful = x$1;
    }

    public void setUserRestful(UserRestful userRestful) {
        this.userRestful_$eq(userRestful);
    }

    public void filterResponse(GatewayContext gatewayContext, Message message) {
        gatewayContext.getResponse().setStatus(Message$.MODULE$.messageToHttpStatus(message));
        gatewayContext.getResponse().write(Message$.MODULE$.response(message));
        gatewayContext.getResponse().sendResponse();
    }

    public void org$apache$linkis$gateway$security$SecurityFilter$$init() {
        Utils$.MODULE$.tryAndError((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            File authFile = new File(MODULE$.getClass().getClassLoader().getResource((String)GatewayConfiguration$.MODULE$.AUTH_IP_FILE().getValue()).toURI().getPath());
            BufferedSource source = Source$.MODULE$.fromFile(authFile, "UTF-8");
            String[] lines = (String[])Utils$.MODULE$.tryFinally((Function0 & Serializable & scala.Serializable)() -> (String[])source.getLines().toArray(ClassTag$.MODULE$.apply(String.class)), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> source.close());
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])lines)).foreach((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)SecurityFilter$.$anonfun$init$4(x$1)));
        }, this.logger());
    }

    public void addAccessHeaders(GatewayContext gatewayContext) {
        GatewayHttpResponse response = gatewayContext.getResponse();
        response.setHeader("Access-Control-Allow-Origin", (String)GatewayConfiguration$.MODULE$.GATEWAY_HEADER_ALLOW_ORIGIN().getValue());
        response.setHeader("Access-Control-Allow-Credentials", "true");
        response.setHeader("Access-Control-Allow-Headers", "authorization,Content-Type");
        response.setHeader("Access-Control-Allow-Methods", (String)GatewayConfiguration$.MODULE$.GATEWAY_HEADER_ALLOW_METHOD().getValue());
        DateFormat fullDateFormatEN = DateFormat.getDateTimeInstance(0, 0, new Locale("EN", "en"));
        response.setHeader("Date", fullDateFormatEN.format(new Date()));
    }

    public static final /* synthetic */ boolean $anonfun$doFilter$1(String[] referer$1, String ref) {
        return referer$1 != null && new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])referer$1)).nonEmpty() && StringUtils.isNotEmpty((CharSequence)((CharSequence)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])referer$1)).head())) && ((String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])referer$1)).head()).trim().contains(ref);
    }

    public static final /* synthetic */ boolean $anonfun$doFilter$2(GatewayContext gatewayContext$1, String r) {
        return !r.equals("") && gatewayContext$1.getRequest().getRequestURI().startsWith(r);
    }

    public static final /* synthetic */ void $anonfun$doFilter$4(GatewayContext gatewayContext$1, Throwable t) {
        String string;
        Throwable throwable = t;
        if (throwable instanceof LinkisException) {
            LinkisException linkisException = (LinkisException)throwable;
            string = linkisException.getMessage();
        } else {
            string = new StringBuilder(22).append("login failed! reason: ").append(ExceptionUtils.getRootCauseMessage((Throwable)t)).toString();
        }
        String message = string;
        MODULE$.logger().error(new StringBuilder(22).append("login failed! Reason: ").append(message).toString(), t);
        MODULE$.filterResponse(gatewayContext$1, Message$.MODULE$.error(message).$less$less(gatewayContext$1.getRequest().getRequestURI()));
    }

    public static final /* synthetic */ boolean $anonfun$init$4(String x$1) {
        return MODULE$.ipSet().add(x$1);
    }

    private SecurityFilter$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
        this.refererValidate = BoxesRunTime.unboxToBoolean((Object)ServerConfiguration$.MODULE$.BDP_SERVER_SECURITY_REFERER_VALIDATE().getValue());
        this.referers = (String)ServerConfiguration$.MODULE$.BDP_SERVER_ADDRESS().getValue();
        this.testUser = (String)ServerConfiguration$.MODULE$.BDP_TEST_USER().getValue();
        this.ACCESS_CONTROL_USER_PREFIX = "linkis.client.access.control.user.";
        this.ipSet = new HashSet();
        Object object = BoxesRunTime.unboxToBoolean((Object)GatewayConfiguration$.MODULE$.ENABLE_GATEWAY_AUTH().getValue()) ? Utils$.MODULE$.defaultScheduler().scheduleAtFixedRate(new Runnable(){

            public void run() {
                Utils$.MODULE$.tryAndError((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> SecurityFilter$.MODULE$.org$apache$linkis$gateway$security$SecurityFilter$$init(), SecurityFilter$.MODULE$.logger());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$run$1()}, serializedLambda);
            }
        }, 0L, 2L, TimeUnit.MINUTES) : BoxedUnit.UNIT;
    }
}

