/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.httpclient.authentication;

import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpResponse;
import org.apache.linkis.common.utils.Logging;
import org.apache.linkis.httpclient.Client;
import org.apache.linkis.httpclient.authentication.Authentication;
import org.apache.linkis.httpclient.authentication.AuthenticationAction;
import org.apache.linkis.httpclient.authentication.AuthenticationResult;
import org.apache.linkis.httpclient.authentication.AuthenticationStrategy;
import org.apache.linkis.httpclient.config.ClientConfig;
import org.apache.linkis.httpclient.request.Action;
import org.apache.linkis.httpclient.request.UserAction;
import org.apache.linkis.httpclient.response.Result;
import org.slf4j.Logger;
import scala.Function0;
import scala.MatchError;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005\re!\u0002\u000e\u001c\u0003\u00031\u0003\"B\u001d\u0001\t\u0003Q\u0004\"\u0003\u001f\u0001\u0001\u0004\u0005\r\u0011\"\u0003>\u0011%\u0011\u0005\u00011AA\u0002\u0013%1\tC\u0005J\u0001\u0001\u0007\t\u0011)Q\u0005}!9!\n\u0001b\u0001\n\u0013Y\u0005B\u00023\u0001A\u0003%A\nC\u0005f\u0001\u0001\u0007\t\u0019!C\u0005M\"IQ\u000e\u0001a\u0001\u0002\u0004%IA\u001c\u0005\na\u0002\u0001\r\u0011!Q!\n\u001dDq!\u001d\u0001C\u0002\u001bE!\u000fC\u0003w\u0001\u0011\u0005q\u000fC\u0003z\u0001\u0011\u0005Q\bC\u0003{\u0001\u0011E1\u0010C\u0004\u0002\u0002\u0001!\t\"a\u0001\t\u000f\u0005U\u0001\u0001\"\u0005\u0002\u0018!9\u0011Q\u0004\u0001\u0005\u0012\u0005}\u0001bBA\u0013\u0001\u0011\u0005\u0011q\u0005\u0005\u0007\u0003W\u0001A\u0011\u00014\t\u000f\u00055\u0002\u0001\"\u0001\u00020!9\u0011Q\u0007\u0001\u0005\u0002\u0005]\u0002bBA\u001f\u0001\u0011\u0005\u0011q\b\u0005\b\u0003\u000b\u0002a\u0011CA$\u0011\u001d\t\u0019\u0006\u0001D\u0001\u0003+Bq!a\u001c\u0001\t\u0003\t\t\bC\u0004\u0002|\u0001!\t!! \u0003=\u0005\u00137\u000f\u001e:bGR\fU\u000f\u001e5f]RL7-\u0019;j_:\u001cFO]1uK\u001eL(B\u0001\u000f\u001e\u00039\tW\u000f\u001e5f]RL7-\u0019;j_:T!AH\u0010\u0002\u0015!$H\u000f]2mS\u0016tGO\u0003\u0002!C\u00051A.\u001b8lSNT!AI\u0012\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005!\u0013aA8sO\u000e\u00011\u0003\u0002\u0001([E\u0002\"\u0001K\u0016\u000e\u0003%R\u0011AK\u0001\u0006g\u000e\fG.Y\u0005\u0003Y%\u0012a!\u00118z%\u00164\u0007C\u0001\u00180\u001b\u0005Y\u0012B\u0001\u0019\u001c\u0005Y\tU\u000f\u001e5f]RL7-\u0019;j_:\u001cFO]1uK\u001eL\bC\u0001\u001a8\u001b\u0005\u0019$B\u0001\u001b6\u0003\u0015)H/\u001b7t\u0015\t1t$\u0001\u0004d_6lwN\\\u0005\u0003qM\u0012q\u0001T8hO&tw-\u0001\u0004=S:LGO\u0010\u000b\u0002wA\u0011a\u0006A\u0001\u0007G2LWM\u001c;\u0016\u0003y\u0002\"a\u0010!\u000e\u0003uI!!Q\u000f\u0003\r\rc\u0017.\u001a8u\u0003)\u0019G.[3oi~#S-\u001d\u000b\u0003\t\u001e\u0003\"\u0001K#\n\u0005\u0019K#\u0001B+oSRDq\u0001S\u0002\u0002\u0002\u0003\u0007a(A\u0002yIE\nqa\u00197jK:$\b%A\rvg\u0016\u0014h*Y7f)>\fU\u000f\u001e5f]RL7-\u0019;j_:\u001cX#\u0001'\u0011\t5#f+Y\u0007\u0002\u001d*\u0011q\nU\u0001\u000bG>t7-\u001e:sK:$(BA)S\u0003\u0011)H/\u001b7\u000b\u0003M\u000bAA[1wC&\u0011QK\u0014\u0002\u0012\u0007>t7-\u001e:sK:$\b*Y:i\u001b\u0006\u0004\bCA,_\u001d\tAF\f\u0005\u0002ZS5\t!L\u0003\u0002\\K\u00051AH]8pizJ!!X\u0015\u0002\rA\u0013X\rZ3g\u0013\ty\u0006M\u0001\u0004TiJLgn\u001a\u0006\u0003;&\u0002\"A\f2\n\u0005\r\\\"AD!vi\",g\u000e^5dCRLwN\\\u0001\u001bkN,'OT1nKR{\u0017)\u001e;iK:$\u0018nY1uS>t7\u000fI\u0001\rG2LWM\u001c;D_:4\u0017nZ\u000b\u0002OB\u0011\u0001n[\u0007\u0002S*\u0011!.H\u0001\u0007G>tg-[4\n\u00051L'\u0001D\"mS\u0016tGoQ8oM&<\u0017\u0001E2mS\u0016tGoQ8oM&<w\fJ3r)\t!u\u000eC\u0004I\u0011\u0005\u0005\t\u0019A4\u0002\u001b\rd\u0017.\u001a8u\u0007>tg-[4!\u0003M\u0019Xm]:j_:l\u0015\r_!mSZ,G+[7f+\u0005\u0019\bC\u0001\u0015u\u0013\t)\u0018F\u0001\u0003M_:<\u0017!C:fi\u000ec\u0017.\u001a8u)\t!\u0005\u0010C\u0003=\u0017\u0001\u0007a(A\u0005hKR\u001cE.[3oi\u0006\u0011r-\u001a;LKf\u0014\u00150V:fe\u0006sG-\u0016*M)\r1FP \u0005\u0006{6\u0001\rAV\u0001\u0005kN,'\u000fC\u0003\u0000\u001b\u0001\u0007a+A\u0005tKJ4XM]+sY\u00069q-\u001a;Vg\u0016\u0014Hc\u0001,\u0002\u0006!9\u0011q\u0001\bA\u0002\u0005%\u0011!\u0004:fcV,7\u000f^!di&|g\u000e\u0005\u0003\u0002\f\u0005EQBAA\u0007\u0015\r\ty!H\u0001\be\u0016\fX/Z:u\u0013\u0011\t\u0019\"!\u0004\u0003\r\u0005\u001bG/[8o\u0003\u00199W\r^&fsR)a+!\u0007\u0002\u001c!9\u0011qA\bA\u0002\u0005%\u0001\"B@\u0010\u0001\u00041\u0016\u0001H4fi\u0006+H\u000f[3oi&\u001c\u0017\r^5p]\u0006\u001bG/[8o\u0005f\\U-\u001f\u000b\u0004C\u0006\u0005\u0002BBA\u0012!\u0001\u0007a+A\u0002lKf\fqb]3u\u00072LWM\u001c;D_:4\u0017n\u001a\u000b\u0004\t\u0006%\u0002\"B3\u0012\u0001\u00049\u0017aD4fi\u000ec\u0017.\u001a8u\u0007>tg-[4\u0002\u000b1|w-\u001b8\u0015\u000b\u0005\f\t$a\r\t\u000f\u0005\u001d1\u00031\u0001\u0002\n!)qp\u0005a\u0001-\u0006AAO]=M_\u001eLg\u000eF\u0003b\u0003s\tY\u0004C\u0004\u0002\bQ\u0001\r!!\u0003\t\u000b}$\u0002\u0019\u0001,\u0002\u0019\u0015tgm\u001c:dK2{w-\u001b8\u0015\u000b\u0005\f\t%a\u0011\t\u000f\u0005\u001dQ\u00031\u0001\u0002\n!)q0\u0006a\u0001-\u00069r-\u001a;BkRDWM\u001c;jG\u0006$\u0018n\u001c8BGRLwN\u001c\u000b\u0007\u0003\u0013\ny%!\u0015\u0011\u00079\nY%C\u0002\u0002Nm\u0011A#Q;uQ\u0016tG/[2bi&|g.Q2uS>t\u0007bBA\u0004-\u0001\u0007\u0011\u0011\u0002\u0005\u0006\u007fZ\u0001\rAV\u0001\u0018O\u0016$\u0018)\u001e;iK:$\u0018nY1uS>t'+Z:vYR$b!a\u0016\u0002^\u00055\u0004c\u0001\u0018\u0002Z%\u0019\u00111L\u000e\u0003)\u0005+H\u000f[3oi&\u001c\u0017\r^5p]J+7/\u001e7u\u0011\u001d\tyf\u0006a\u0001\u0003C\n\u0001B]3ta>t7/\u001a\t\u0005\u0003G\nI'\u0004\u0002\u0002f)\u0019\u0011qM\u0011\u0002\t!$H\u000f]\u0005\u0005\u0003W\n)G\u0001\u0007IiR\u0004(+Z:q_:\u001cX\rC\u0004\u0002\b]\u0001\r!!\u0013\u0002\u0013%\u001cH+[7f_V$H\u0003BA:\u0003s\u00022\u0001KA;\u0013\r\t9(\u000b\u0002\b\u0005>|G.Z1o\u0011\u0015a\u0002\u00041\u0001b\u0003)\u0001X\u000f^*fgNLwN\u001c\u000b\u0006\t\u0006}\u0014\u0011\u0011\u0005\u0007\u0003GI\u0002\u0019\u0001,\t\u000bqI\u0002\u0019A1")
public abstract class AbstractAuthenticationStrategy
implements AuthenticationStrategy,
Logging {
    private Client client;
    private final ConcurrentHashMap<String, Authentication> userNameToAuthentications;
    private ClientConfig clientConfig;
    private Logger logger;
    private volatile boolean bitmap$0;

    public void trace(Function0<String> message) {
        Logging.trace$((Logging)this, message);
    }

    public void debug(Function0<String> message) {
        Logging.debug$((Logging)this, message);
    }

    public void info(Function0<String> message) {
        Logging.info$((Logging)this, message);
    }

    public void info(Function0<String> message, Throwable t) {
        Logging.info$((Logging)this, message, (Throwable)t);
    }

    public void warn(Function0<String> message) {
        Logging.warn$((Logging)this, message);
    }

    public void warn(Function0<String> message, Throwable t) {
        Logging.warn$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message, Throwable t) {
        Logging.error$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message) {
        Logging.error$((Logging)this, message);
    }

    private Logger logger$lzycompute() {
        AbstractAuthenticationStrategy abstractAuthenticationStrategy = this;
        synchronized (abstractAuthenticationStrategy) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    private Client client() {
        return this.client;
    }

    private void client_$eq(Client x$1) {
        this.client = x$1;
    }

    private ConcurrentHashMap<String, Authentication> userNameToAuthentications() {
        return this.userNameToAuthentications;
    }

    private ClientConfig clientConfig() {
        return this.clientConfig;
    }

    private void clientConfig_$eq(ClientConfig x$1) {
        this.clientConfig = x$1;
    }

    public abstract long sessionMaxAliveTime();

    public void setClient(Client client) {
        this.client_$eq(client);
    }

    public Client getClient() {
        return this.client();
    }

    public String getKeyByUserAndURL(String user, String serverUrl) {
        return new StringBuilder(1).append(user).append("@").append(serverUrl).toString();
    }

    public String getUser(Action requestAction) {
        Action action = requestAction;
        if (action instanceof AuthenticationAction) {
            return null;
        }
        if (action instanceof UserAction) {
            Action action2 = action;
            return ((UserAction)((Object)action2)).getUser();
        }
        if (StringUtils.isNotBlank((CharSequence)this.clientConfig().getAuthTokenKey())) {
            return this.clientConfig().getAuthTokenKey();
        }
        return null;
    }

    public String getKey(Action requestAction, String serverUrl) {
        String user = this.getUser(requestAction);
        if (user == null) {
            return null;
        }
        return this.getKeyByUserAndURL(user, serverUrl);
    }

    public Authentication getAuthenticationActionByKey(String key) {
        return this.userNameToAuthentications().get(key);
    }

    public void setClientConfig(ClientConfig clientConfig) {
        this.clientConfig_$eq(clientConfig);
    }

    public ClientConfig getClientConfig() {
        return this.clientConfig();
    }

    @Override
    public Authentication login(Action requestAction, String serverUrl) {
        Authentication authentication;
        String key = this.getKey(requestAction, serverUrl);
        if (key == null) {
            return null;
        }
        Authentication oldAuth = this.getAuthenticationActionByKey(key);
        if (oldAuth != null && !this.isTimeout(oldAuth)) {
            Authentication authenticationAction = oldAuth;
            authenticationAction.updateLastAccessTime();
            return authenticationAction;
        }
        String string = key.intern();
        synchronized (string) {
            Authentication authentication2 = this.getAuthenticationActionByKey(key);
            if (authentication2 == null || this.isTimeout(authentication2)) {
                authentication2 = this.tryLogin(requestAction, serverUrl);
                this.putSession(key, authentication2);
                this.logger().info(new StringBuilder(12).append(key).append(" try reLogin").toString());
            }
            authentication = authentication2;
        }
        return authentication;
    }

    public Authentication tryLogin(Action requestAction, String serverUrl) {
        AuthenticationAction action = this.getAuthenticationAction(requestAction, serverUrl);
        Result result = this.client().execute((Action)action, 5000L);
        if (result instanceof AuthenticationResult) {
            AuthenticationResult authenticationResult = (AuthenticationResult)result;
            return authenticationResult.getAuthentication();
        }
        throw new MatchError((Object)result);
    }

    public Authentication enforceLogin(Action requestAction, String serverUrl) {
        return this.login(requestAction, serverUrl);
    }

    public abstract AuthenticationAction getAuthenticationAction(Action var1, String var2);

    public abstract AuthenticationResult getAuthenticationResult(HttpResponse var1, AuthenticationAction var2);

    public boolean isTimeout(Authentication authentication) {
        return System.currentTimeMillis() - authentication.getLastAccessTime() >= this.sessionMaxAliveTime();
    }

    public void putSession(String key, Authentication authentication) {
        this.userNameToAuthentications().put(key, authentication);
    }

    public AbstractAuthenticationStrategy() {
        Logging.$init$((Logging)this);
        this.userNameToAuthentications = new ConcurrentHashMap();
    }
}

