/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.cs.server.restful;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.linkis.cs.common.entity.listener.CommonContextIDListenerDomain;
import org.apache.linkis.cs.common.entity.listener.CommonContextKeyListenerDomain;
import org.apache.linkis.cs.common.entity.listener.ContextIDListenerDomain;
import org.apache.linkis.cs.common.entity.listener.ContextKeyListenerDomain;
import org.apache.linkis.cs.common.entity.source.ContextID;
import org.apache.linkis.cs.common.entity.source.ContextKey;
import org.apache.linkis.cs.common.exception.CSErrorException;
import org.apache.linkis.cs.errorcode.LinkisCsServerErrorCodeSummary;
import org.apache.linkis.cs.listener.callback.imp.ContextKeyValueBean;
import org.apache.linkis.cs.server.enumeration.ServiceType;
import org.apache.linkis.cs.server.restful.CsRestfulParent;
import org.apache.linkis.cs.server.service.ContextListenerService;
import org.apache.linkis.server.Message;
import org.apache.linkis.server.utils.ModuleUserUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"cs(contextservice) listener operation"})
@RestController
@RequestMapping(path={"/contextservice"})
public class ContextListenerRestfulApi
implements CsRestfulParent {
    @Autowired
    private ContextListenerService contextListenerService;

    @ApiOperation(value="onBindIDListener", notes="on bind id listener", response=Message.class)
    @ApiOperationSupport(ignoreParameters={"jsonNode"})
    @RequestMapping(path={"onBindIDListener"}, method={RequestMethod.POST})
    public Message onBindIDListener(HttpServletRequest req, @RequestBody JsonNode jsonNode) throws InterruptedException, CSErrorException, IOException, ClassNotFoundException {
        String source = jsonNode.get("source").textValue();
        ContextID contextID = this.getContextIDFromJsonNode(jsonNode);
        if (StringUtils.isEmpty((CharSequence)contextID.getContextId())) {
            throw new CSErrorException(LinkisCsServerErrorCodeSummary.PARAMS_CANNOT_EMPTY.getErrorCode(), MessageFormat.format(LinkisCsServerErrorCodeSummary.PARAMS_CANNOT_EMPTY.getErrorDesc(), "ContextID"));
        }
        ModuleUserUtils.getOperationUser((HttpServletRequest)req, (String)("onBindIDListener,contextID:" + contextID.getContextId()));
        CommonContextIDListenerDomain listener = new CommonContextIDListenerDomain();
        listener.setSource(source);
        this.contextListenerService.onBind(contextID, (ContextIDListenerDomain)listener);
        return this.generateMessage(null, "listener");
    }

    @ApiOperation(value="onBindKeyListener", notes="on bind key listener", response=Message.class)
    @ApiOperationSupport(ignoreParameters={"jsonNode"})
    @RequestMapping(path={"onBindKeyListener"}, method={RequestMethod.POST})
    public Message onBindKeyListener(HttpServletRequest req, @RequestBody JsonNode jsonNode) throws CSErrorException, IOException, ClassNotFoundException {
        String source = jsonNode.get("source").textValue();
        ContextID contextID = this.getContextIDFromJsonNode(jsonNode);
        if (StringUtils.isEmpty((CharSequence)contextID.getContextId())) {
            throw new CSErrorException(LinkisCsServerErrorCodeSummary.PARAMS_CANNOT_EMPTY.getErrorCode(), MessageFormat.format(LinkisCsServerErrorCodeSummary.PARAMS_CANNOT_EMPTY.getErrorDesc(), "ContextID"));
        }
        ModuleUserUtils.getOperationUser((HttpServletRequest)req, (String)("onBindKeyListener,contextID:" + contextID.getContextId()));
        ContextKey contextKey = this.getContextKeyFromJsonNode(jsonNode);
        CommonContextKeyListenerDomain listener = new CommonContextKeyListenerDomain();
        listener.setSource(source);
        this.contextListenerService.onBind(contextID, contextKey, (ContextKeyListenerDomain)listener);
        return this.generateMessage(null, "listener");
    }

    @ApiOperation(value="heartbeat", notes="heart beat", response=Message.class)
    @ApiOperationSupport(ignoreParameters={"jsonNode"})
    @RequestMapping(path={"heartbeat"}, method={RequestMethod.POST})
    public Message heartbeat(HttpServletRequest req, @RequestBody JsonNode jsonNode) throws CSErrorException {
        ModuleUserUtils.getOperationUser((HttpServletRequest)req, (String)"heartbeat");
        String source = jsonNode.get("source").textValue();
        List<ContextKeyValueBean> res = this.contextListenerService.heartbeat(source);
        return this.generateMessage(res, "ContextKeyValueBean");
    }

    @Override
    public ServiceType getServiceType() {
        return ServiceType.CONTEXT_LISTENER;
    }
}

