/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.cs.persistence.util;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.math3.util.Pair;
import org.apache.linkis.cs.common.exception.CSErrorException;
import org.apache.linkis.cs.common.exception.CSWarnException;
import org.apache.linkis.cs.common.serialize.helper.ContextSerializationHelper;
import org.apache.linkis.cs.common.serialize.helper.SerializationHelper;
import org.apache.linkis.cs.persistence.annotation.Ignore;
import org.apache.linkis.cs.persistence.entity.ExtraFieldClass;
import org.apache.linkis.cs.persistence.exception.ThrowingFunction;
import org.apache.linkis.server.BDPJettyServerHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;

public class PersistenceUtils {
    private static ObjectMapper json = BDPJettyServerHelper.jacksonJson();
    private static final Logger logger = LoggerFactory.getLogger(PersistenceUtils.class);
    private static final String LONG_TYP = "java.lang.Long";
    public static final SerializationHelper SERIALIZE = ContextSerializationHelper.getInstance();

    private static String generateGetMethod(Field field) {
        String fieldName = field.getName();
        return String.format("get%s%s", fieldName.substring(0, 1).toUpperCase(), fieldName.substring(1));
    }

    public static String generateSetMethod(String fieldName) {
        return String.format("set%s%s", fieldName.substring(0, 1).toUpperCase(), fieldName.substring(1));
    }

    private static boolean canIgnore(Field field) {
        return field.getAnnotation(Ignore.class) != null;
    }

    private static List<String> getIgnoreFieldName(Class<?> clazz) {
        if (clazz.getAnnotation(Ignore.class) != null) {
            return Arrays.stream(clazz.getDeclaredFields()).map(Field::getName).collect(Collectors.toList());
        }
        return Arrays.stream(clazz.getDeclaredFields()).filter(PersistenceUtils::canIgnore).map(Field::getName).collect(Collectors.toList());
    }

    public static <T, S> Pair<S, ExtraFieldClass> transfer(T t, Class<S> sClass) throws CSErrorException {
        try {
            ExtraFieldClass extraFieldClass = new ExtraFieldClass();
            S s = sClass.newInstance();
            BeanUtils.copyProperties(t, s);
            Class<?> tClass = t.getClass();
            extraFieldClass.setClassName(tClass.getName());
            List<String> canIgnore = PersistenceUtils.getIgnoreFieldName(sClass);
            for (Field field : tClass.getDeclaredFields()) {
                Method method;
                if (canIgnore.contains(field.getName()) || null == (method = tClass.getMethod(PersistenceUtils.generateGetMethod(field), new Class[0])).invoke(t, new Object[0])) continue;
                Object invoke = method.invoke(t, new Object[0]);
                extraFieldClass.addFieldName(field.getName());
                if (invoke == null) {
                    extraFieldClass.addFieldType(field.getType().getName());
                } else {
                    extraFieldClass.addFieldType(invoke.getClass().getName());
                }
                extraFieldClass.addFieldValue(invoke);
            }
            return new Pair(s, (Object)extraFieldClass);
        }
        catch (Exception e) {
            throw new CSErrorException(97000, "transfer bean failed:", (Throwable)e);
        }
    }

    public static <T, S> T transfer(ExtraFieldClass extraFieldClass, S s) throws CSErrorException {
        if (s == null) {
            return null;
        }
        try {
            Class<?> tClass = Class.forName(extraFieldClass.getClassName());
            Object t = tClass.newInstance();
            BeanUtils.copyProperties(s, t);
            for (int i = 0; i < extraFieldClass.getFieldNames().size(); ++i) {
                Field field = tClass.getDeclaredField(extraFieldClass.getOneFieldName(i));
                field.setAccessible(true);
                if (LONG_TYP.equals(extraFieldClass.getOneFieldType(i))) {
                    Long value = new Long(extraFieldClass.getOneFieldValue(i).toString());
                    field.set(t, value);
                    continue;
                }
                if (Enum.class.isAssignableFrom(Class.forName(extraFieldClass.getOneFieldType(i)))) {
                    Class<?> enumClass = Class.forName(extraFieldClass.getOneFieldType(i));
                    Method valueOf = enumClass.getMethod("valueOf", String.class);
                    Object invoke = valueOf.invoke(null, extraFieldClass.getOneFieldValue(i));
                    field.set(t, invoke);
                    continue;
                }
                if (!BeanUtils.isSimpleProperty(Class.forName(extraFieldClass.getOneFieldType(i)))) {
                    Object o = json.convertValue(extraFieldClass.getOneFieldValue(i), Class.forName(extraFieldClass.getOneFieldType(i)));
                    field.set(t, o);
                    continue;
                }
                field.set(t, extraFieldClass.getOneFieldValue(i));
            }
            return (T)t;
        }
        catch (Exception e) {
            throw new CSErrorException(97000, "transfer bean failed:", (Throwable)e);
        }
    }

    public static <T, R, E extends Exception> Function<T, R> map(ThrowingFunction<T, R, E> throwingFunction) {
        return i -> {
            try {
                return throwingFunction.accept(i);
            }
            catch (Exception e) {
                throw new CSWarnException(97000, "execute failed,reason:", (Throwable)e);
            }
        };
    }

    public static String serialize(Object o) throws CSErrorException {
        if (o instanceof String) {
            return (String)o;
        }
        return SERIALIZE.serialize(o);
    }

    public static <T> T deserialize(String Str) throws CSErrorException {
        return (T)SERIALIZE.deserialize(Str);
    }
}

