/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.cs.highavailable.ha.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.apache.commons.lang3.StringUtils;
import org.apache.linkis.common.ServiceInstance;
import org.apache.linkis.cs.common.exception.CSErrorException;
import org.apache.linkis.cs.highavailable.exception.CSErrorCode;
import org.apache.linkis.cs.highavailable.ha.BackupInstanceGenerator;
import org.apache.linkis.cs.highavailable.ha.ContextHAChecker;
import org.apache.linkis.cs.highavailable.ha.instancealias.InstanceAliasManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class BackupInstanceGeneratorImpl
implements BackupInstanceGenerator {
    private static final Logger logger = LoggerFactory.getLogger(BackupInstanceGeneratorImpl.class);
    @Autowired
    private InstanceAliasManager instanceAliasManager;
    @Autowired
    private ContextHAChecker contextHAChecker;

    @Override
    public String getBackupInstance(String haIDKey) throws CSErrorException {
        String alias = null;
        if (!StringUtils.isNotBlank((CharSequence)haIDKey) || !this.contextHAChecker.isHAIDValid(haIDKey)) {
            throw new CSErrorException(CSErrorCode.INVALID_HAID, "Invalid HAID :" + haIDKey);
        }
        alias = this.contextHAChecker.parseHAIDFromKey(haIDKey).getBackupInstance();
        return alias;
    }

    @Override
    public String chooseBackupInstance(String mainInstanceAlias) throws CSErrorException {
        ServiceInstance mainInstance = null;
        try {
            mainInstance = this.instanceAliasManager.getInstanceByAlias(mainInstanceAlias);
        }
        catch (Exception e) {
            logger.error("Get Instance error, alias : {}, message : {}", (Object)mainInstanceAlias, (Object)e.getMessage());
            throw new CSErrorException(CSErrorCode.INVALID_INSTANCE_ALIAS, e.getMessage() + ", alias : " + mainInstanceAlias);
        }
        List<ServiceInstance> allInstanceList = this.instanceAliasManager.getAllInstanceList();
        ArrayList<ServiceInstance> remainInstanceList = new ArrayList<ServiceInstance>();
        for (ServiceInstance instance : allInstanceList) {
            if (instance.equals((Object)mainInstance)) continue;
            remainInstanceList.add(instance);
        }
        if (remainInstanceList.size() > 0) {
            int index = this.getBackupInstanceIndex(remainInstanceList);
            return this.instanceAliasManager.getAliasByServiceInstance((ServiceInstance)remainInstanceList.get(index));
        }
        logger.error("Only one instance, no remains.");
        return this.instanceAliasManager.getAliasByServiceInstance(mainInstance);
    }

    private int getBackupInstanceIndex(List<ServiceInstance> instanceList) {
        return new Random().nextInt(instanceList.size());
    }
}

