/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.orchestrator.ecm.service.impl;

import java.io.Serializable;
import java.util.Set;
import org.apache.linkis.common.ServiceInstance;
import org.apache.linkis.common.utils.Utils$;
import org.apache.linkis.governance.common.conf.GovernanceCommonConf$;
import org.apache.linkis.governance.common.entity.ExecutionNodeStatus;
import org.apache.linkis.governance.common.protocol.task.RequestTask;
import org.apache.linkis.governance.common.protocol.task.RequestTaskKill;
import org.apache.linkis.governance.common.protocol.task.RequestTaskStatus;
import org.apache.linkis.governance.common.protocol.task.ResponseTaskStatus;
import org.apache.linkis.manager.common.entity.node.EngineNode;
import org.apache.linkis.manager.common.protocol.RequestManagerUnlock;
import org.apache.linkis.orchestrator.ecm.conf.ECMPluginConf$;
import org.apache.linkis.orchestrator.ecm.exception.ECMPluginErrorException;
import org.apache.linkis.orchestrator.ecm.service.AbstractEngineConnExecutor;
import org.apache.linkis.orchestrator.ecm.utils.ECMPUtils$;
import org.apache.linkis.rpc.Sender;
import org.apache.linkis.rpc.Sender$;
import org.apache.linkis.scheduler.executer.ErrorExecuteResponse;
import org.apache.linkis.scheduler.executer.ExecuteResponse;
import org.apache.linkis.scheduler.executer.OutputExecuteResponse;
import org.apache.linkis.scheduler.executer.SubmitResponse;
import org.apache.linkis.scheduler.executer.SuccessExecuteResponse;
import scala.Function0;
import scala.Function1;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u00055b\u0001\u0002\u000b\u0016\u0001\u0011B\u0001\"\u000b\u0001\u0003\u0002\u0003\u0006IA\u000b\u0005\u0006m\u0001!\ta\u000e\u0005\bw\u0001\u0011\r\u0011\"\u0003=\u0011\u0019Q\u0005\u0001)A\u0005{!)1\n\u0001C!\u0019\")!\u000b\u0001C\u0005'\")!\f\u0001C!y!)1\f\u0001C!9\")\u0011\r\u0001C!E\")a\r\u0001C!O\")\u0001\u000e\u0001C!S\"1q\u0010\u0001C!\u0003\u0003Aq!a\u0002\u0001\t\u0003\nI\u0001C\u0004\u0002\f\u0001!\t%!\u0004\t\u000f\u0005E\u0001\u0001\"\u0011\u0002\n!9\u00111\u0003\u0001\u0005B\u0005U\u0001bBA\r\u0001\u0011\u0005\u0013\u0011\u0002\u0005\b\u00037\u0001A\u0011IA\u000f\u0011\u0019\tY\u0003\u0001C\u0005'\ni2i\\7qkR\fG/[8o\u000b:<\u0017N\\3D_:tW\t_3dkR|'O\u0003\u0002\u0017/\u0005!\u0011.\u001c9m\u0015\tA\u0012$A\u0004tKJ4\u0018nY3\u000b\u0005iY\u0012aA3d[*\u0011A$H\u0001\r_J\u001c\u0007.Z:ue\u0006$xN\u001d\u0006\u0003=}\ta\u0001\\5oW&\u001c(B\u0001\u0011\"\u0003\u0019\t\u0007/Y2iK*\t!%A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001KA\u0011aeJ\u0007\u0002/%\u0011\u0001f\u0006\u0002\u001b\u0003\n\u001cHO]1di\u0016sw-\u001b8f\u0007>tg.\u0012=fGV$xN]\u0001\u000bK:<\u0017N\\3O_\u0012,\u0007CA\u00165\u001b\u0005a#BA\u0017/\u0003\u0011qw\u000eZ3\u000b\u0005=\u0002\u0014AB3oi&$\u0018P\u0003\u00022e\u000511m\\7n_:T!aM\u000f\u0002\u000f5\fg.Y4fe&\u0011Q\u0007\f\u0002\u000b\u000b:<\u0017N\\3O_\u0012,\u0017A\u0002\u001fj]&$h\b\u0006\u00029uA\u0011\u0011\bA\u0007\u0002+!)\u0011F\u0001a\u0001U\u00051An\\2lKJ,\u0012!\u0010\t\u0003}\u001ds!aP#\u0011\u0005\u0001\u001bU\"A!\u000b\u0005\t\u001b\u0013A\u0002\u001fs_>$hHC\u0001E\u0003\u0015\u00198-\u00197b\u0013\t15)\u0001\u0004Qe\u0016$WMZ\u0005\u0003\u0011&\u0013aa\u0015;sS:<'B\u0001$D\u0003\u001dawnY6fe\u0002\n!cZ3u'\u0016\u0014h/[2f\u0013:\u001cH/\u00198dKV\tQ\n\u0005\u0002O!6\tqJ\u0003\u00022;%\u0011\u0011k\u0014\u0002\u0010'\u0016\u0014h/[2f\u0013:\u001cH/\u00198dK\u0006\u0019r-\u001a;F]\u001eLg.Z\"p]:\u001cVM\u001c3feV\tA\u000b\u0005\u0002V16\taK\u0003\u0002X;\u0005\u0019!\u000f]2\n\u0005e3&AB*f]\u0012,'/A\u0006hKR$\u0016nY6fi&#\u0017!B2m_N,G#A/\u0011\u0005y{V\"A\"\n\u0005\u0001\u001c%\u0001B+oSR\fQ\"^:f\u000b:<\u0017N\\3D_:tW#A2\u0011\u0005y#\u0017BA3D\u0005\u001d\u0011un\u001c7fC:\fq\"\u001e8Vg\u0016,enZ5oK\u000e{gN\\\u000b\u0002;\u00069Q\r_3dkR,GC\u00016s!\tY\u0007/D\u0001m\u0015\tig.\u0001\u0005fq\u0016\u001cW\u000f^3s\u0015\tyW$A\u0005tG\",G-\u001e7fe&\u0011\u0011\u000f\u001c\u0002\u0010\u000bb,7-\u001e;f%\u0016\u001c\bo\u001c8tK\")1o\u0003a\u0001i\u0006Y!/Z9vKN$H+Y:l!\t)X0D\u0001w\u0015\t9\b0\u0001\u0003uCN\\'BA={\u0003!\u0001(o\u001c;pG>d'BA\u0019|\u0015\taX$\u0001\u0006h_Z,'O\\1oG\u0016L!A <\u0003\u0017I+\u0017/^3tiR\u000b7o[\u0001\tW&dG\u000eV1tWR\u00191-a\u0001\t\r\u0005\u0015A\u00021\u0001>\u0003\u0019)\u00070Z2JI\u000691.\u001b7m\u00032dG#A2\u0002\u000bA\fWo]3\u0015\u0007\r\fy\u0001\u0003\u0004\u0002\u00069\u0001\r!P\u0001\ta\u0006,8/Z!mY\u00061!/Z:v[\u0016$2aYA\f\u0011\u0019\t)\u0001\u0005a\u0001{\u0005I!/Z:v[\u0016\fE\u000e\\\u0001\u0007gR\fG/^:\u0015\t\u0005}\u0011\u0011\u0006\t\u0005\u0003C\t)#\u0004\u0002\u0002$)\u0011qF_\u0005\u0005\u0003O\t\u0019CA\nFq\u0016\u001cW\u000f^5p]:{G-Z*uCR,8\u000f\u0003\u0004\u0002\u0006I\u0001\r!P\u0001\u0011O\u0016$X*\u00198bO\u0016\u00148+\u001a8eKJ\u0004")
public class ComputationEngineConnExecutor
extends AbstractEngineConnExecutor {
    private final EngineNode engineNode;
    private final String locker;

    private String locker() {
        return this.locker;
    }

    @Override
    public ServiceInstance getServiceInstance() {
        return this.engineNode.getServiceInstance();
    }

    private Sender getEngineConnSender() {
        return Sender$.MODULE$.getSender(this.getServiceInstance());
    }

    @Override
    public String getTicketId() {
        return this.engineNode.getTicketId();
    }

    @Override
    public void close() {
        this.logger().info("Start to release engineConn {}", new Object[]{this.getServiceInstance()});
        RequestManagerUnlock requestManagerUnlock = new RequestManagerUnlock(this.getServiceInstance(), this.locker(), Sender$.MODULE$.getThisServiceInstance());
        this.killAll();
        this.getManagerSender().send((Object)requestManagerUnlock);
        this.logger().debug("Finished to release engineConn {}", new Object[]{this.getServiceInstance()});
    }

    @Override
    public boolean useEngineConn() {
        if (this.isAvailable()) {
            this.available_$eq(false);
            return true;
        }
        return false;
    }

    @Override
    public void unUseEngineConn() {
        if (!this.isAvailable()) {
            this.available_$eq(true);
            return;
        }
    }

    @Override
    public ExecuteResponse execute(RequestTask requestTask) {
        this.logger().debug("Start to submit task {} to engineConn({})", (Object)requestTask.getSourceID(), (Object)this.getServiceInstance());
        requestTask.setLabels(ECMPUtils$.MODULE$.filterJobStrategyLabel(requestTask.getLabels()));
        requestTask.setLock(this.locker());
        Object object = this.getEngineConnSender().ask((Object)requestTask);
        if (object instanceof SubmitResponse) {
            SubmitResponse submitResponse = (SubmitResponse)object;
            this.logger().info("Succeed to submit task {} to engineConn({}), Get asyncResponse execID is {}", new Object[]{requestTask.getSourceID(), this.getServiceInstance(), submitResponse});
            this.getRunningTasks().put(submitResponse.taskId(), requestTask);
            return submitResponse;
        }
        if (object instanceof OutputExecuteResponse) {
            OutputExecuteResponse outputExecuteResponse = (OutputExecuteResponse)object;
            this.logger().info("engineConn({}) Succeed to execute task {}, and get Res", (Object)this.getServiceInstance(), (Object)requestTask.getSourceID());
            return outputExecuteResponse;
        }
        if (object instanceof ErrorExecuteResponse) {
            ErrorExecuteResponse errorExecuteResponse = (ErrorExecuteResponse)object;
            this.logger().error("engineConn({}) Failed to execute task {} ,error msg {}", new Object[]{this.getServiceInstance(), requestTask.getSourceID(), errorExecuteResponse.message(), errorExecuteResponse.t()});
            return errorExecuteResponse;
        }
        if (object instanceof SuccessExecuteResponse) {
            SuccessExecuteResponse successExecuteResponse = (SuccessExecuteResponse)object;
            this.logger().info("engineConn({}) Succeed to execute task {}, no res", (Object)this.getServiceInstance(), (Object)requestTask.getSourceID());
            return successExecuteResponse;
        }
        throw new ECMPluginErrorException(ECMPluginConf$.MODULE$.ECM_ERROR_CODE(), new StringBuilder(55).append("engineConn(").append(this.getServiceInstance()).append(") Failed to execute task").append(requestTask.getSourceID()).append(", get response error").toString());
    }

    @Override
    public boolean killTask(String execId) {
        return BoxesRunTime.unboxToBoolean((Object)Utils$.MODULE$.tryCatch((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            this.logger().info("begin to send RequestTaskKill to engineConn({}), execID: {}", (Object)this.getServiceInstance(), (Object)execId);
            this.getEngineConnSender().send((Object)new RequestTaskKill(execId));
            this.logger().info("Finished to send RequestTaskKill to engineConn({}), execID: {}", (Object)this.getServiceInstance(), (Object)execId);
            return true;
        }, (Function1 & Serializable & scala.Serializable)t -> BoxesRunTime.boxToBoolean((boolean)ComputationEngineConnExecutor.$anonfun$killTask$2(this, execId, t))));
    }

    @Override
    public boolean killAll() {
        Set<String> execIds = this.getRunningTasks().keySet();
        if (execIds == null || execIds.isEmpty()) {
            for (String execId : execIds) {
                this.killTask(execId);
            }
        }
        this.getRunningTasks().clear();
        return true;
    }

    @Override
    public boolean pause(String execId) {
        return true;
    }

    @Override
    public boolean pauseAll() {
        return true;
    }

    @Override
    public boolean resume(String execId) {
        return true;
    }

    @Override
    public boolean resumeAll() {
        return true;
    }

    @Override
    public ExecutionNodeStatus status(String execId) {
        Object object = this.getEngineConnSender().ask((Object)new RequestTaskStatus(execId));
        if (object instanceof ResponseTaskStatus) {
            ResponseTaskStatus responseTaskStatus = (ResponseTaskStatus)object;
            ExecutionNodeStatus status = responseTaskStatus.status();
            return status;
        }
        throw new ECMPluginErrorException(ECMPluginConf$.MODULE$.ECM_ERROR_CODE(), new StringBuilder(34).append("Failed to get engineConn(").append(this.getServiceInstance()).append(") status ").toString());
    }

    private Sender getManagerSender() {
        return Sender$.MODULE$.getSender((String)GovernanceCommonConf$.MODULE$.MANAGER_SERVICE_NAME().getValue());
    }

    public static final /* synthetic */ boolean $anonfun$killTask$2(ComputationEngineConnExecutor $this, String execId$1, Throwable t) {
        $this.logger().error("Failed to kill task {} engineConn({})", new Object[]{execId$1, $this.getServiceInstance(), t});
        return false;
    }

    public ComputationEngineConnExecutor(EngineNode engineNode) {
        this.engineNode = engineNode;
        this.locker = engineNode.getLock();
    }
}

