/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.dialect.oracle.ast.stmt;

import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLName;
import com.alibaba.druid.sql.ast.SQLObject;
import com.alibaba.druid.sql.ast.statement.SQLExprTableSource;
import com.alibaba.druid.sql.ast.statement.SQLLockTableStatement;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleStatementImpl;
import com.alibaba.druid.sql.dialect.oracle.visitor.OracleASTVisitor;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;
import java.util.ArrayList;
import java.util.List;

public class OracleLockTableStatement
extends OracleStatementImpl
implements SQLLockTableStatement {
    private SQLExprTableSource table;
    private LockMode lockMode;
    private boolean noWait;
    private SQLExpr wait;
    private SQLExpr partition;

    public boolean isNoWait() {
        return this.noWait;
    }

    public void setNoWait(boolean noWait) {
        this.noWait = noWait;
    }

    public SQLExpr getWait() {
        return this.wait;
    }

    public void setWait(SQLExpr wait) {
        this.wait = wait;
    }

    public SQLExprTableSource getTable() {
        return this.table;
    }

    public void setTable(SQLExprTableSource table) {
        if (table != null) {
            table.setParent(this);
        }
        this.table = table;
    }

    public void setTable(SQLName table) {
        this.setTable(new SQLExprTableSource(table));
        this.table.setParent(this);
    }

    public LockMode getLockMode() {
        return this.lockMode;
    }

    public void setLockMode(LockMode lockMode) {
        this.lockMode = lockMode;
    }

    public SQLExpr getPartition() {
        return this.partition;
    }

    public void setPartition(SQLExpr partition) {
        this.partition = partition;
    }

    @Override
    public void accept0(OracleASTVisitor visitor) {
        if (visitor.visit(this)) {
            this.acceptChild((SQLASTVisitor)visitor, this.table);
            this.acceptChild((SQLASTVisitor)visitor, this.partition);
            this.acceptChild((SQLASTVisitor)visitor, this.wait);
        }
        visitor.endVisit(this);
    }

    @Override
    public List<SQLObject> getChildren() {
        ArrayList<SQLObject> children = new ArrayList<SQLObject>();
        if (this.table != null) {
            children.add(this.table);
        }
        if (this.wait != null) {
            children.add(this.wait);
        }
        if (this.partition != null) {
            children.add(this.partition);
        }
        return children;
    }

    public static enum LockMode {
        ROW_SHARE,
        ROW_EXCLUSIVE,
        SHARE_UPDATE,
        SHARE,
        SHARE_ROW_EXCLUSIVE,
        EXCLUSIVE;


        public String toString() {
            switch (this) {
                case ROW_SHARE: {
                    return "ROW SHARE";
                }
                case ROW_EXCLUSIVE: {
                    return "ROW EXCLUSIVE";
                }
                case SHARE_UPDATE: {
                    return "SHARE UPDATE";
                }
                case SHARE_ROW_EXCLUSIVE: {
                    return "SHARE ROW EXCLUSIVE";
                }
            }
            return this.name();
        }
    }
}

